<?php $__env->startSection('title', 'Manage Jobs - SKILLPOTS'); ?>
<?php $__env->startSection('content'); ?>

<style>
    .job-management-container {
        max-width: 1400px;
        margin: 0 auto;
        padding: 40px 20px;
        background-color: #f8f9fa;
        min-height: 100vh;
    }

    .job-tabs {
        display: flex;
        gap: 30px;
        border-bottom: 2px solid #e0e0e0;
        margin-bottom: 40px;
    }

    .job-tab {
        background: none;
        border: none;
        padding: 15px 5px;
        font-size: 16px;
        color: #6c757d;
        cursor: pointer;
        position: relative;
        transition: all 0.3s ease;
        font-weight: 500;
    }

    .job-tab:hover {
        color: #1a4d2e;
    }

    .job-tab.active {
        color: #1a4d2e;
        font-weight: 600;
    }

    .job-tab.active::after {
        content: '';
        position: absolute;
        bottom: -2px;
        left: 0;
        right: 0;
        height: 3px;
        background-color: #1a4d2e;
    }

    .job-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 30px;
    }

    .job-count {
        font-size: 32px;
        font-weight: 600;
        color: #2c3e50;
    }

    .search-container {
        position: relative;
        flex: 1;
        max-width: 500px;
    }

    .search-icon {
        position: absolute;
        left: 15px;
        top: 50%;
        transform: translateY(-50%);
        color: #6c757d;
        font-size: 18px;
    }

    .search-input {
        width: 100%;
        padding: 12px 15px 12px 45px;

        border-radius: 8px;
        font-size: 15px;
        transition: all 0.3s ease;
    }

    .search-input:focus {
        outline: none;


    }

    .create-job-btn {
        background-color: #0e636b;
        color: white;
        padding: 12px 28px;
        border: none;
        border-radius: 8px;
        font-size: 15px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .create-job-btn:hover {
        background-color: #0e636b;
        transform: translateY(-2px);

    }

    .empty-state {
        text-align: center;
        padding: 80px 20px;
        background-color: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    }

    .empty-icon {
        width: 200px;
        height: 200px;
        margin: 0 auto 30px;
        background: linear-gradient(135deg, #e3f2fd 0%, #f3e5f5 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
    }

    .empty-icon svg {
        width: 100px;
        height: 100px;
        color: #5c6bc0;
    }

    .search-icon-large {
        position: absolute;
        right: 30px;
        bottom: 30px;
        width: 60px;
        height: 60px;
        background-color: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .search-icon-large svg {
        width: 30px;
        height: 30px;
        color: #1a4d2e;
    }

    .empty-title {
        font-size: 24px;
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 15px;
    }

    .empty-description {
        font-size: 16px;
        color: #6c757d;
        margin-bottom: 30px;
    }

    .create-job-btn-outline {
        background-color: white;
        color: #2c3e50;
        padding: 12px 28px;
        border: 2px solid #2c3e50;
        border-radius: 8px;
        font-size: 15px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .create-job-btn-outline:hover {
        background-color: #2c3e50;
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(44, 62, 80, 0.2);
    }

    /* Job List Styles */
    .job-list {
        display: grid;
        gap: 20px;
    }

    .job-card {
        background-color: white;
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
        border: 1px solid #e0e0e0;
    }

    .job-card:hover {
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
        transform: translateY(-2px);
    }

    .job-card-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 15px;
    }

    .job-title-section h3 {
        font-size: 20px;
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 8px;
    }

    .job-meta {
        display: flex;
        gap: 20px;
        color: #6c757d;
        font-size: 14px;
    }

    .job-meta span {
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .job-actions {
        display: flex;
        gap: 10px;
    }

    .action-btn {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        border: 1px solid #e0e0e0;
        background-color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .action-btn:hover {
        background-color: #f8f9fa;
        border-color: #1a4d2e;
    }

    .job-stats {
        display: flex;
        gap: 30px;
        padding-top: 15px;
        border-top: 1px solid #e0e0e0;
    }

    .stat-item {
        display: flex;
        align-items: center;
        gap: 8px;
        color: #6c757d;
        font-size: 14px;
    }

    .stat-number {
        font-weight: 600;
        color: #1a4d2e;
        font-size: 16px;
    }

    .status-badge {
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .status-active {
        background-color: #d4edda;
        color: #155724;
    }

    .status-draft {
        background-color: #fff3cd;
        color: #856404;
    }

    .status-expired {
        background-color: #f8d7da;
        color: #721c24;
    }
</style>

<main class="job-management-container">
    <!-- Tabs -->
    <div class="job-tabs">
        <button class="job-tab active">Open</button>
        <button class="job-tab">Expired</button>
        <button class="job-tab">Draft</button>
        <button class="job-tab">Past applicants</button>
    </div>

    <!-- Header -->
    <div class="job-header">
        <h1 class="job-count">0 job ads</h1>
        <div class="search-container">
            <i class="fas fa-search search-icon"></i>
            <input
                type="text"
                class="search-input"
                placeholder="Search job title or reference number"
            />
        </div>
        <a href="<?php echo e(route('web.employer.create.job.post')); ?>" class="create-job-btn">Create a job ad</a>
    </div>

    <!-- Empty State -->
    <div class="empty-state">
        <div class="empty-icon">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
            </svg>
            <div class="search-icon-large">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                </svg>
            </div>
        </div>
        <h2 class="empty-title">You have no open jobs</h2>
        <p class="empty-description">Create your job ad now</p>
        <button class="create-job-btn-outline">Create a job ad</button>
    </div>

    <!-- Example Job List (hidden by default, shown when jobs exist) -->
    <div class="job-list" style="display: none;">
        <div class="job-card">
            <div class="job-card-header">
                <div class="job-title-section">
                    <h3>Senior React Developer</h3>
                    <div class="job-meta">
                        <span><i class="fas fa-map-marker-alt"></i> Sydney, NSW</span>
                        <span><i class="fas fa-briefcase"></i> Full-time</span>
                        <span><i class="fas fa-clock"></i> Posted 2 days ago</span>
                    </div>
                </div>
                <div style="display: flex; align-items: center; gap: 15px;">
                    <span class="status-badge status-active">Active</span>
                    <div class="job-actions">
                        <button class="action-btn" title="Edit">
                            <i class="fas fa-edit"></i>
                        </button>
                        <button class="action-btn" title="More">
                            <i class="fas fa-ellipsis-v"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="job-stats">
                <div class="stat-item">
                    <i class="fas fa-eye"></i>
                    <span><span class="stat-number">245</span> views</span>
                </div>
                <div class="stat-item">
                    <i class="fas fa-users"></i>
                    <span><span class="stat-number">18</span> applicants</span>
                </div>
                <div class="stat-item">
                    <i class="fas fa-calendar"></i>
                    <span>Expires in <span class="stat-number">28</span> days</span>
                </div>
            </div>
        </div>

        <div class="job-card">
            <div class="job-card-header">
                <div class="job-title-section">
                    <h3>UX/UI Designer</h3>
                    <div class="job-meta">
                        <span><i class="fas fa-map-marker-alt"></i> Melbourne, VIC</span>
                        <span><i class="fas fa-briefcase"></i> Full-time</span>
                        <span><i class="fas fa-clock"></i> Posted 5 days ago</span>
                    </div>
                </div>
                <div style="display: flex; align-items: center; gap: 15px;">
                    <span class="status-badge status-active">Active</span>
                    <div class="job-actions">
                        <button class="action-btn" title="Edit">
                            <i class="fas fa-edit"></i>
                        </button>
                        <button class="action-btn" title="More">
                            <i class="fas fa-ellipsis-v"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="job-stats">
                <div class="stat-item">
                    <i class="fas fa-eye"></i>
                    <span><span class="stat-number">189</span> views</span>
                </div>
                <div class="stat-item">
                    <i class="fas fa-users"></i>
                    <span><span class="stat-number">12</span> applicants</span>
                </div>
                <div class="stat-item">
                    <i class="fas fa-calendar"></i>
                    <span>Expires in <span class="stat-number">25</span> days</span>
                </div>
            </div>
        </div>

        <div class="job-card">
            <div class="job-card-header">
                <div class="job-title-section">
                    <h3>Marketing Manager - Draft</h3>
                    <div class="job-meta">
                        <span><i class="fas fa-map-marker-alt"></i> Brisbane, QLD</span>
                        <span><i class="fas fa-briefcase"></i> Full-time</span>
                        <span><i class="fas fa-clock"></i> Last edited 1 hour ago</span>
                    </div>
                </div>
                <div style="display: flex; align-items: center; gap: 15px;">
                    <span class="status-badge status-draft">Draft</span>
                    <div class="job-actions">
                        <button class="action-btn" title="Edit">
                            <i class="fas fa-edit"></i>
                        </button>
                        <button class="action-btn" title="More">
                            <i class="fas fa-ellipsis-v"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="job-stats">
                <div class="stat-item">
                    <i class="fas fa-info-circle"></i>
                    <span>Complete your job posting to publish</span>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
    // Tab switching functionality
    document.querySelectorAll('.job-tab').forEach(tab => {
        tab.addEventListener('click', function() {
            document.querySelectorAll('.job-tab').forEach(t => t.classList.remove('active'));
            this.classList.add('active');

            // Here you would typically load different job data based on the tab
            const tabName = this.textContent.trim();
            console.log('Switched to tab:', tabName);
        });
    });

    // Example: Toggle between empty state and job list
    // Remove this in production and handle with actual data
    document.querySelectorAll('.create-job-btn, .create-job-btn-outline').forEach(btn => {
        btn.addEventListener('click', function() {
            alert('Redirecting to create job page...');
            // window.location.href = '/employer/jobs/create';
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.employersiteapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\skillpots\skillpots\resources\views/web/home/employer/postjob.blade.php ENDPATH**/ ?>