<?php

use App\Http\Controllers\Backendcontroller;
use App\Http\Middleware\RedirectByCountry;
use App\Livewire\Admin\Dashboard\Admindashboard;
use App\Livewire\Admin\Dashboard\Jobcategory\Jobcategorydashboard;
use App\Livewire\Web\Index\Profile\Myprofile;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FrontController;
use App\Livewire\Admin\Login;
use App\Livewire\Web\Index\Jobseeker\Jobseekerdashboard;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Str;

// Main Pages

Route::get('/', function () {
    return view('home');
})->middleware('redirect.country')->name('skillpot.home');

Route::get('/home', [FrontController::class, 'app'])->name('app');
Route::get('/find-job', [FrontController::class, 'find_job'])->name('skillpot.find.jobs');


    // Email verification notice
    Route::get('/email/verify', function () {
        return view('auth.verify-email');
    })->name('verification.notice');

    // Verify email
    // Route::get('/email/verify/{id}/{hash}', function (EmailVerificationRequest $request) {
    //     $request->fulfill();
    //     return redirect('/home'); // Redirect after verification
    // })->name('verification.verify');

    // Resend verification email
    Route::post('/email/verification-notification', function (Request $request) {
        $request->user()->sendEmailVerificationNotification();
        return back()->with('message', 'Verification link sent!');
    })->name('verification.send');

// Email verification link


 Route::get('/email/verify/{id}/{hash}', [FrontController::class, 'verifyAccount'])->name('verification.verify');
// Resend verification link
Route::post('/email/verification-notification', function (Request $request) {
    $request->user()->sendEmailVerificationNotification();
    return back()->with('message', 'Verification link sent!');
})->middleware(['auth', 'throttle:6,1'])->name('verification.send');

// Password reset routes
Route::get('/forgot-password', function () {
    return view('auth.forgot-password');
})->name('password.request');

Route::post('/forgot-password', function (Request $request) {
    $request->validate(['email' => 'required|email']);

    $status = Password::sendResetLink(
        $request->only('email')
    );

    return $status === Password::RESET_LINK_SENT
                ? back()->with(['status' => __($status)])
                : back()->withErrors(['email' => __($status)]);
})->name('password.email');

Route::get('/reset-password/{token}', function ($token) {
    return view('auth.reset-password', ['token' => $token]);
})->name('password.reset');

Route::post('/reset-password', function (Request $request) {
    $request->validate([
        'token' => 'required',
        'email' => 'required|email',
        'password' => 'required|min:8|confirmed',
    ]);

    $status = Password::reset(
        $request->only('email', 'password', 'password_confirmation', 'token'),
        function ($user, $password) {
            $user->forceFill([
                'password' => Hash::make($password)
            ])->setRememberToken(Str::random(60));

            $user->save();

            event(new PasswordReset($user));
        }
    );

   return $status === Password::PASSWORD_RESET
    ? redirect()->route('skillpot.home')->with('openSigninModal', true)
    : back()->withErrors(['email' => [__($status)]]);

})->name('password.update');


Route::get('/apply/{slug}', [FrontController::class, 'job_apply'])->name('skillpot.apply.job');
Route::get('/create-job', [FrontController::class, 'create_job'])->name('jobs.create');

Route::get('/provider', [FrontController::class, 'gmailCallBack'])->name('login.gmail');
Route::get('/callback', [FrontController::class, 'handleCallback'])->name('handleCallbackGmail.newGmail'); // new gmail login

Route::get('/sign-out', [FrontController::class, 'sign_out'])->name('sign.out');
Route::get('/my-profile', [FrontController::class, 'my_profile'])->name('my.profile.dashboard');

Route::get('/employer-dashboard', [FrontController::class, 'employerdashboard'])->name('my.employer.dashboard');

Route::get('/login', [FrontController::class, 'loginpage'])->name('skillpot.login.page');
Route::get('/register', [FrontController::class, 'registerpage'])->name('skillpot.create.account');


Route::get('/jobseeker-profile',[FrontController::class, 'jobseekerindex'])->name('web.user.jobseeker.myprofile');
Route::get('/employer-profile',[FrontController::class, 'employerindex'])->name('web.user.employer.myprofile');
Route::get('/employer-site',[FrontController::class, 'employersite'])->name('skillpot.employer.home');
Route::get('/employer-job-post',[FrontController::class, 'employer_jobpost'])->name('employer.post.job.section');
Route::get('/employer-create-job-post',[FrontController::class, 'employer_jobpostcreate'])->name('web.employer.create.job.post');



/////////////////////////////////////////////admin/////////////////////////////////////////
Route::get('/admin/login',Login::class)->name('admin.login');
Route::get('/admin/dashboard',Admindashboard::class)->name('admin.dashboard');
Route::get('/admin/job/category',Jobcategorydashboard::class)->name('admin.job.category');

Route::get('/logout-systemuser',[Backendcontroller::class, 'logout_systemuser'])->name('admin.logout');

