@extends('layouts.employersiteapp')
@section('title', 'Manage Jobs - SKILLPOTS')
@section('content')

  <div class="container" style="padding: 10%">
        <h1>Create a job ad</h1>

        <!-- Progress Steps -->
        <div class="progress-steps">
            <div class="step" id="step-classify">
                <div class="step-circle"></div>
                <span class="step-label">Classify</span>
            </div>
            <div class="step" id="step-adtypes">
                <div class="step-circle"></div>
                <span class="step-label">Ad Types</span>
            </div>
            <div class="step" id="step-write">
                <div class="step-circle"></div>
                <span class="step-label">Write</span>
            </div>
            <div class="step" id="step-manage">
                <div class="step-circle"></div>
                <span class="step-label">Manage</span>
            </div>
        </div>

        <!-- Alert -->
        <div class="alert">
            <div class="alert-icon">⚠</div>
            <div class="alert-content">
                <div class="alert-title">Verify your account to post your first job ad</div>
                <div class="alert-text">
                    Please confirm your email address by clicking on the link sent to <strong>kalpamadusanka113@gmail.com</strong>.
                    <a href="#" class="alert-link">Can't find the email?</a>
                </div>
            </div>
        </div>

        <form action="" method="POST" enctype="multipart/form-data">
            @csrf

            <!-- STEP 1: CLASSIFY -->
            <div class="step-content active" id="content-classify">
                <!-- Job Title -->
                <div class="form-group">
                    <label class="form-label">
                        Job title
                        <span class="info-icon">?</span>
                    </label>
                    <div class="input-wrapper">
                        <span class="input-icon">💼</span>
                        <input type="text" name="job_title" class="form-control" placeholder="Enter a simple job title (e.g. Sales Assistant)" required>
                    </div>
                </div>

                <!-- Location -->
                <div class="form-group">
                    <label class="form-label">
                        Location
                        <span class="info-icon">?</span>
                    </label>
                    <div class="input-wrapper">
                        <span class="input-icon">📍</span>
                        <input type="text" name="location" class="form-control" placeholder="Enter a suburb, city or region (e.g. Unknown Location)" required>
                    </div>
                </div>

                <!-- Workplace Option -->
                <div class="form-group">
                    <label class="form-label">
                        Workplace option
                        <span class="badge">New</span>
                    </label>
                    <input type="text" name="workplace_option" class="form-control" value="On-site" style="padding-left: 16px;">
                </div>

                <!-- Work Type -->
                <div class="form-group">
                    <label class="form-label">Work type</label>
                    <div class="radio-group">
                        <div class="radio-option">
                            <input type="radio" id="fulltime" name="work_type" value="full-time" checked>
                            <label for="fulltime">Full-time</label>
                        </div>
                        <div class="radio-option">
                            <input type="radio" id="parttime" name="work_type" value="part-time">
                            <label for="parttime">Part-time</label>
                        </div>
                        <div class="radio-option">
                            <input type="radio" id="contract" name="work_type" value="contract">
                            <label for="contract">Contract</label>
                        </div>
                        <div class="radio-option">
                            <input type="radio" id="casual" name="work_type" value="casual">
                            <label for="casual">Casual</label>
                        </div>
                    </div>
                </div>

                <!-- Pay Type -->
                <div class="form-group">
                    <label class="form-label">Pay type</label>
                    <div class="radio-group">
                        <div class="radio-option">
                            <input type="radio" id="hourly" name="pay_type" value="hourly">
                            <label for="hourly">Hourly rate</label>
                        </div>
                        <div class="radio-option">
                            <input type="radio" id="monthly" name="pay_type" value="monthly">
                            <label for="monthly">Monthly salary</label>
                        </div>
                        <div class="radio-option">
                            <input type="radio" id="annual" name="pay_type" value="annual" checked>
                            <label for="annual">Annual salary</label>
                        </div>
                        <div class="radio-option">
                            <input type="radio" id="commission" name="pay_type" value="commission">
                            <label for="commission">Annual plus commission</label>
                        </div>
                    </div>
                </div>

                <!-- Pay Range -->
                <div class="form-group">
                    <label class="form-label">
                        Pay range
                        <span class="info-icon">?</span>
                    </label>
                    <div class="help-text">Enter a range to offer candidates. If pay is an exact amount, enter the same in both fields.</div>
                    <div class="pay-range-grid">
                        <div class="pay-label">Currency</div>
                        <div class="pay-label">From</div>
                        <div class="pay-label">To</div>

                        <select name="currency" class="form-control">
                            <option value="USD">USD</option>
                            <option value="EUR">EUR</option>
                            <option value="GBP">GBP</option>
                            <option value="LKR">LKR</option>
                        </select>
                        <input type="number" name="pay_from" class="form-control" placeholder="Enter minimum pay" style="padding-left: 16px;">
                        <input type="number" name="pay_to" class="form-control" placeholder="Enter maximum pay" style="padding-left: 16px;">
                    </div>
                </div>

                <!-- Pay Shown on Ad -->
                <div class="form-group">
                    <label class="form-label">Pay shown on ad <span style="font-weight: 400; color: #666;">(optional)</span></label>
                    <div class="radio-group">
                        <div class="radio-option">
                            <input type="radio" id="show_salary" name="show_salary" value="1" checked>
                            <label for="show_salary">Show salary on ad</label>
                        </div>
                        <div class="radio-option">
                            <input type="radio" id="hide_salary" name="show_salary" value="0">
                            <label for="hide_salary">Hide salary on ad</label>
                        </div>
                    </div>
                </div>

                <!-- Advertise Privately -->
                <div class="form-group">
                    <label class="form-label">Advertise privately <span style="font-weight: 400; color: #666;">(optional)</span></label>
                    <div class="checkbox-option">
                        <input type="checkbox" id="advertise_privately" name="advertise_privately" value="1">
                        <label for="advertise_privately">Hide company name, reviews, branding on job ads</label>
                    </div>
                </div>
            </div>

            <!-- STEP 2: AD TYPES -->
            <div class="step-content" id="content-adtypes">
                <div class="ad-types-grid">
                    <!-- Basic -->
                    <div class="ad-type-card">
                        <div class="ad-type-label">Basic</div>
                        <div class="ad-type-title">For non-urgent and easy-to-fill roles</div>
                        <div class="ad-type-icon">👤</div>
                        <div class="ad-type-price">$325</div>
                        <div class="ad-type-performance">
                            <span>👁</span>
                            <span>1x views</span>
                            <span class="info-icon">?</span>
                        </div>
                        <button type="button" class="ad-type-btn">Select</button>
                    </div>

                    <!-- Advanced -->
                    <div class="ad-type-card">
                        <div class="ad-type-label">Advanced</div>
                        <div class="ad-type-title">Enhanced targeting for more high-fit candidates</div>
                        <div class="ad-type-icon">👥</div>
                        <div class="ad-type-price">$465</div>
                        <div class="ad-type-performance">
                            <span>👁</span>
                            <span>1.5x views</span>
                            <span class="info-icon">?</span>
                        </div>
                        <button type="button" class="ad-type-btn">Select</button>
                    </div>

                    <!-- Premium -->
                    <div class="ad-type-card recommended">
                        <div class="recommended-badge">Recommended</div>
                        <div class="ad-type-label">Premium</div>
                        <div class="ad-type-title">Top performing ad, for critical & hard-to-fill roles</div>
                        <div class="ad-type-icon">⭐⭐</div>
                        <div class="ad-type-price">$875</div>
                        <div class="ad-type-performance">
                            <span>👁</span>
                            <span>2.5x views</span>
                            <span class="info-icon">?</span>
                        </div>
                        <button type="button" class="ad-type-btn">Select</button>
                    </div>

                    <!-- Concierge -->
                    <div class="ad-type-card">
                        <div class="ad-type-label">Concierge</div>
                        <div class="ad-type-title">We write your job ad</div>
                        <div class="ad-type-icon">✨👥</div>
                        <div class="ad-type-price">$1,495</div>
                        <div class="ad-type-performance">
                            <span>👁</span>
                            <span>2.5x views</span>
                            <span class="info-icon">?</span>
                        </div>
                        <button type="button" class="ad-type-btn">Contact us</button>
                    </div>
                </div>

                <!-- Comparison Table -->
                <div class="comparison-table">
                    <h2>Included in your 30 day ad</h2>
                    <table>
                        <thead>
                            <tr>
                                <th></th>
                                <th>Basic</th>
                                <th>Advanced</th>
                                <th>Premium</th>
                                <th>Concierge</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <strong>Competitive edge</strong><br>
                                    <small>More visibility to active candidates viewing similar ads</small>
                                </td>
                                <td>None</td>
                                <td>Your ad featured on similar ads</td>
                                <td>Your ad featured on similar ads<br>+<br>Other ads don't appear on yours</td>
                                <td>Your ad featured on similar ads<br>+<br>Other ads don't appear on yours</td>
                            </tr>
                            <tr>
                                <td>
                                    <strong>AI targeting</strong><br>
                                    <small>Intelligent matching to find the right candidates faster</small>
                                </td>
                                <td>Good</td>
                                <td>Great</td>
                                <td>Priority</td>
                                <td>Priority</td>
                            </tr>
                            <tr>
                                <td>
                                    <strong>Exclusive targeting</strong><br>
                                    <small>SEEK exclusively sends your ad to high-fit candidates</small>
                                </td>
                                <td>✗</td>
                                <td>✗</td>
                                <td>✓</td>
                                <td>✓</td>
                            </tr>
                            <tr>
                                <td>
                                    <strong>Candidate invitations</strong><br>
                                    <small>Personally invite high-fit candidates to apply</small>
                                </td>
                                <td>20</td>
                                <td>30</td>
                                <td>80</td>
                                <td>80</td>
                            </tr>
                            <tr>
                                <td>
                                    <strong>Branding</strong><br>
                                    <small>Promote your brand to attract the right candidates</small>
                                </td>
                                <td>Optional</td>
                                <td>Optional</td>
                                <td>Logo + cover image + key selling points</td>
                                <td>Logo + cover image + key selling points</td>
                            </tr>
                            <tr>
                                <td>
                                    <strong>Ad writing service</strong><br>
                                    <small>Professional assistance in crafting a compelling ad</small>
                                </td>
                                <td>✗</td>
                                <td>✗</td>
                                <td>✗</td>
                                <td>✓</td>
                            </tr>
                        </tbody>
                    </table>
                    <p style="margin-top: 16px; color: #666; font-size: 13px;">
                        Our pricing model incorporates a variety of data points to determine the price of each ad, including market dynamics, salary, competition for candidates, and likelihood to place (to name just a few).
                    </p>
                    <p style="color: #666; font-size: 13px;">
                        All estimates are based on our internal analysis of available SEEK data. The figures are estimates only and we do not guarantee that your ad will meet these performance levels. Please note that we reserve the right to change ad features from time to time.
                    </p>
                </div>
            </div>

            <!-- STEP 3: WRITE -->
            <div class="step-content" id="content-write">
                <div class="two-column">
                    <div>
                        <!-- Job Description -->
                        <div class="form-group">
                            <label class="form-label">Job description</label>
                            <div class="editor-toolbar">
                                <button type="button" class="editor-btn"><strong>T</strong></button>
                                <button type="button" class="editor-btn"><strong>B</strong></button>
                                <button type="button" class="editor-btn"><em>I</em></button>
                                <button type="button" class="editor-btn">☰</button>
                                <button type="button" class="editor-btn">≡</button>
                            </div>
                            <textarea name="job_description" class="form-control" style="border-radius: 0 0 6px 6px; padding-left: 16px;"></textarea>
                        </div>

                        <!-- Job Summary -->
                        <div class="form-group">
                            <label class="form-label">Job summary</label>
                            <div class="help-text">Write a compelling statement about your role to entice more candidates.</div>
                            <textarea name="job_summary" class="form-control" style="padding-left: 16px;"></textarea>
                        </div>

                        <!-- Key Selling Points -->
                        <div class="form-group">
                            <label class="form-label">Key selling points <span style="font-weight: 400; color: #666;">(optional)</span></label>
                            <div class="help-text">Enter 3 key selling points to attract candidates to view your role.</div>
                            <input type="text" name="selling_point_1" class="form-control" style="padding-left: 16px; margin-bottom: 12px;" placeholder="Selling point 1">
                            <input type="text" name="selling_point_2" class="form-control" style="padding-left: 16px; margin-bottom: 12px;" placeholder="Selling point 2">
                            <input type="text" name="selling_point_3" class="form-control" style="padding-left: 16px;" placeholder="Selling point 3">
                        </div>

                        <!-- Company Brand -->
                        <div class="form-group">
                            <label class="form-label">
                                Company brand
                                <span class="info-icon">?</span>
                                <span style="font-weight: 400; color: #666;">(optional)</span>
                            </label>
                            <div class="help-text">Create your first brand by uploading your company logo and cover image.</div>
                            <div class="upload-area">
                                <button type="button" class="upload-btn">🖼 Add cover image</button>
                            </div>
                            <button type="button" class="upload-btn">🖼 Add logo</button>
                        </div>

                        <!-- Video -->
                        <div class="form-group">
                            <label class="form-label">Video <span style="font-weight: 400; color: #666;">(optional)</span></label>
                            <div class="help-text">Add a video to your ad with a YouTube link. The video will appear at the bottom of your ad.</div>
                            <div class="input-wrapper">
                                <span class="input-icon">▶</span>
                                <input type="url" name="video_url" class="form-control" placeholder="e.g. https://www.youtube.com/watch?v=abc123">
                            </div>
                        </div>
                    </div>

                    <!-- Sidebar -->
                    <div>
                        <div class="suggestion-box">
                            <div class="suggestion-icon">✨</div>
                            <div class="suggestion-title">Suggestions to attract top candidates</div>
                            <div class="suggestion-text">Start entering your job description and we'll tell you what to include to get more relevant applications.</div>
                            <div class="suggestion-divider">OR</div>
                            <div class="suggestion-title">Need help writing your job ad?</div>
                            <div class="suggestion-text">Let seekAi create the first draft to get you started.</div>
                            <button type="button" class="ai-btn">Write with seekAi</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- STEP 4: MANAGE -->
            <div class="step-content" id="content-manage">
                <h2>Set up your verifications, screening questions and filters
                    <span class="info-icon">?</span>
                </h2>

                <!-- Verification Card -->
                <div class="verification-card">
                    <div class="verification-icon">✓</div>
                    <div class="verification-content">
                        <div class="free-badge">Free</div>
                        <h3>Accelerate shortlisting with verified applicants</h3>
                        <ol style="margin: 12px 0; padding-left: 20px; color: #666;">
                            <li>SEEK will automatically ask applicants to verify their identity</li>
                            <li>You can add additional key verifiable questions you want applicants to verify <span class="info-icon">?</span></li>
                            <li>We'll notify applicants to verify their credentials and identity instantly</li>
                        </ol>
                        <div class="checkbox-option">
                            <input type="checkbox" id="verify_applicants" name="verify_applicants" value="1">
                            <label for="verify_applicants">Ask applicants to verify their identity and credentials</label>
                        </div>
                    </div>
                </div>

                <!-- Progress Bar -->
                <div class="form-group">
                    <strong>1/8 questions selected</strong>
                    <div class="progress-bar">
                        <div class="progress-fill" style="width: 12.5%;"></div>
                    </div>
                </div>

                <!-- Questions Section -->
                <div class="questions-section">
                    <h3>Questions we recommend for your role</h3>
                    <p style="color: #666; margin-bottom: 20px;">We've pre-selected some questions based on what most employers select. These questions will <strong>create filters</strong> for your applications. You can also add more questions.</p>

                    <!-- Question 1 -->
                    <div class="question-card selected">
                        <div class="question-title">
                            <input type="checkbox" class="question-checkbox" checked>
                            <div>
                                <strong>Which of the following statements best describes your right to work in Australia?
                                    <span class="info-icon">?</span>
                                </strong>
                                <p style="color: #666; margin-top: 8px;">I will accept any of these answers:</p>
                            </div>
                        </div>
                        <div class="radio-group" style="margin-left: 32px;">
                            <div class="radio-option">
                                <input type="radio" name="work_right_q1" value="permanent">
                                <label>I have permanent work rights with no restrictions</label>
                            </div>
                            <div class="radio-option">
                                <input type="radio" name="work_right_q1" value="temporary_no_restrictions">
                                <label>I have temporary work rights with no restrictions</label>
                            </div>
                            <div class="radio-option">
                                <input type="radio" name="work_right_q1" value="temporary_restrictions">
                                <label>I have temporary work rights with restrictions</label>
                            </div>
                            <div class="radio-option">
                                <input type="radio" name="work_right_q1" value="sponsorship">
                                <label>I require sponsorship to work for a new employer</label>
                            </div>
                        </div>
                        <div style="margin: 16px 0 0 32px;">
                            <div class="checkbox-option">
                                <input type="checkbox" name="must_have_work_rights" value="1">
                                <label>This is a <strong>must-have</strong> requirement <span class="info-icon">?</span></label>
                            </div>
                        </div>
                        <div class="alert" style="margin: 16px 0 0 32px;">
                            <div class="alert-icon">⚠</div>
                            <div class="alert-content">
                                <div class="alert-text">To view only those applicants that meet your right to work requirements, set this as a <strong>must-have</strong>.</div>
                            </div>
                        </div>
                    </div>

                    <!-- More Questions -->
                    <div class="question-card">
                        <div class="question-title">
                            <input type="checkbox" class="question-checkbox">
                            <label><strong>Do you have customer service experience?</strong></label>
                        </div>
                    </div>

                    <div class="question-card">
                        <div class="question-title">
                            <input type="checkbox" class="question-checkbox">
                            <label><strong>What's your expected annual base salary?</strong></label>
                        </div>
                    </div>

                    <div class="question-card">
                        <div class="question-title">
                            <input type="checkbox" class="question-checkbox">
                            <label><strong>How much notice are you required to give your current employer?</strong></label>
                        </div>
                    </div>

                    <div class="question-card">
                        <div class="question-title">
                            <input type="checkbox" class="question-checkbox">
                            <label><strong>Do you have a current Police Check (National Police Certificate) for employment?
                                <span class="info-icon">?</span>
                            </strong></label>
                        </div>
                    </div>

                    <div class="question-card">
                        <div class="question-title">
                            <input type="checkbox" class="question-checkbox">
                            <label><strong>Are you willing to undergo a pre-employment medical check?</strong></label>
                        </div>
                    </div>

                    <div class="question-card">
                        <div class="question-title">
                            <input type="checkbox" class="question-checkbox">
                            <label><strong>Do you have a current Australian driver's licence?
                                <span class="info-icon">?</span>
                            </strong></label>
                        </div>
                    </div>

                    <div class="question-card">
                        <div class="question-title">
                            <input type="checkbox" class="question-checkbox">
                            <label><strong>Do you own or have regular access to a car?
                                <span class="info-icon">?</span>
                            </strong></label>
                        </div>
                    </div>

                    <div class="question-card">
                        <div class="question-title">
                            <input type="checkbox" class="question-checkbox">
                            <label><strong>Are you available to work public holidays?</strong></label>
                        </div>
                    </div>

                    <div class="question-card">
                        <div class="question-title">
                            <input type="checkbox" class="question-checkbox">
                            <label><strong>Are you willing to relocate for this role?</strong></label>
                        </div>
                    </div>
                </div>

                <!-- Search Box -->
                <div class="search-box">
                    <span class="search-icon">🔍</span>
                    <input type="text" class="search-input" placeholder="E.g. certifications, experience, skill">
                </div>

                <!-- Must-have Settings -->
                <div class="form-group">
                    <label class="form-label">
                        Must-have requirement settings
                        <span class="info-icon">?</span>
                        <span class="badge">New</span>
                    </label>
                    <div class="checkbox-option">
                        <input type="checkbox" name="auto_move_unsuitable" value="1">
                        <label>Automatically move candidates who don't meet your must-have requirements to the <strong>Not Suitable folder</strong></label>
                    </div>
                </div>

                <div class="alert alert-info">
                    <div class="alert-icon">ℹ</div>
                    <div class="alert-content">
                        <div class="alert-text">To keep the process fair for all applicants, questions, answers and any other settings can't be changed after you post your job ad.</div>
                    </div>
                </div>

                <!-- Internal Reference -->
                <div class="form-group" style="margin-top: 40px;">
                    <label class="form-label">
                        Internal job reference
                        <span class="info-icon">?</span>
                        <span style="font-weight: 400; color: #666;">(optional)</span>
                    </label>
                    <input type="text" name="internal_reference" class="form-control" style="padding-left: 16px;">
                </div>
            </div>

            <!-- Form Actions -->
            <div class="form-actions">
                <button type="button" class="btn btn-back" id="backBtn" style="display: none;">
                    <span>←</span>
                    Back
                </button>
                <div style="flex: 1;"></div>
                <button type="button" class="btn btn-secondary">Save draft</button>
                <button type="button" class="btn btn-secondary" id="previewBtn" style="display: none;">Preview</button>
                <button type="button" class="btn btn-primary" id="nextBtn">
                    Continue
                    <span>→</span>
                </button>
                <button type="submit" class="btn btn-primary" id="submitBtn" style="display: none;">
                    Continue
                    <span>→</span>
                </button>
            </div>
        </form>
    </div>

    <script>
        let currentStep = 1;
        const totalSteps = 4;

        const steps = {
            1: { id: 'classify', label: 'Classify' },
            2: { id: 'adtypes', label: 'Ad Types' },
            3: { id: 'write', label: 'Write' },
            4: { id: 'manage', label: 'Manage' }
        };

        function updateStepUI() {
            // Update progress indicators
            for (let i = 1; i <= totalSteps; i++) {
                const stepEl = document.getElementById(`step-${steps[i].id}`);
                const contentEl = document.getElementById(`content-${steps[i].id}`);

                stepEl.classList.remove('active', 'completed');
                contentEl.classList.remove('active');

                if (i < currentStep) {
                    stepEl.classList.add('completed');
                } else if (i === currentStep) {
                    stepEl.classList.add('active');
                    contentEl.classList.add('active');
                }
            }

            // Update buttons
            const backBtn = document.getElementById('backBtn');
            const nextBtn = document.getElementById('nextBtn');
            const previewBtn = document.getElementById('previewBtn');
            const submitBtn = document.getElementById('submitBtn');

            backBtn.style.display = currentStep > 1 ? 'flex' : 'none';

            if (currentStep === totalSteps) {
                nextBtn.style.display = 'none';
                previewBtn.style.display = 'block';
                submitBtn.style.display = 'flex';
            } else {
                nextBtn.style.display = 'flex';
                previewBtn.style.display = 'none';
                submitBtn.style.display = 'none';
            }

            // Scroll to top
            window.scrollTo({ top: 0, behavior: 'smooth' });
        }

        document.getElementById('nextBtn').addEventListener('click', function() {
            if (currentStep < totalSteps) {
                currentStep++;
                updateStepUI();
            }
        });

        document.getElementById('backBtn').addEventListener('click', function() {
            if (currentStep > 1) {
                currentStep--;
                updateStepUI();
            }
        });

        // Initialize
        updateStepUI();
    </script>
       <style>



        h1 {
            font-size: 28px;
            margin-bottom: 30px;
            color: #2d2d2d;
        }

        h2 {
            font-size: 20px;
            margin-bottom: 20px;
            color: #2d2d2d;
        }

        /* Progress Steps */
        .progress-steps {
            display: flex;
            justify-content: space-between;
            margin-bottom: 40px;
            position: relative;
        }

        .progress-steps::before {
            content: '';
            position: absolute;
            top: 15px;
            left: 0;
            right: 0;
            height: 2px;
            background: #e0e0e0;
            z-index: 0;
        }

        .step {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative;
            z-index: 1;
            flex: 1;
        }

        .step-circle {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background: #e0e0e0;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 8px;
            border: 3px solid white;
        }

        .step.active .step-circle {
            background: #0e636b;
        }

        .step.completed .step-circle {
            background: #0e636b;
        }

        .step.completed .step-circle::after {
            content: '✓';
            color: white;
            font-size: 14px;
            font-weight: bold;
        }

        .step.active .step-circle::after {
            content: '';
            width: 8px;
            height: 8px;
            background: white;
            border-radius: 50%;
        }

        .step-label {
            font-size: 14px;
            color: #666;
        }

        .step.active .step-label,
        .step.completed .step-label {
            color: #2d2d2d;
            font-weight: 500;
        }

        /* Step Content */
        .step-content {
            display: none;
        }

        .step-content.active {
            display: block;
        }

        /* Alert Box */
        .alert {
            background: #fff9e6;
            border: 1px solid #ffe4a3;
            border-radius: 6px;
            padding: 16px;
            margin-bottom: 30px;
            display: flex;
            gap: 12px;
        }

        .alert-icon {
            color: #f59e0b;
            font-size: 20px;
        }

        .alert-content {
            flex: 1;
        }

        .alert-title {
            font-weight: 600;
            margin-bottom: 4px;
            color: #2d2d2d;
        }

        .alert-text {
            font-size: 14px;
            color: #666;
        }

        .alert-link {
            color: #2557a7;
            text-decoration: underline;
            cursor: pointer;
        }

        /* Info Alert */
        .alert-info {
            background: #e3f2fd;
            border: 1px solid #90caf9;
        }

        .alert-info .alert-icon {
            color: #0e636b;
        }

        /* Form Styles */
        .form-group {
            margin-bottom: 24px;
        }

        .form-label {
            display: flex;
            align-items: center;
            gap: 6px;
            font-size: 15px;
            font-weight: 600;
            color: #2d2d2d;
            margin-bottom: 8px;
        }

        .info-icon {
            width: 16px;
            height: 16px;
            border: 1.5px solid #666;
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            color: #666;
            cursor: help;
        }

        .form-control {
            width: 100%;
            padding: 12px 16px;
            padding-left: 40px;
            border: 1px solid #d0d0d0;
            border-radius: 6px;
            font-size: 15px;
            transition: border-color 0.2s;
        }

        .form-control:focus {
            outline: none;
            border-color: #0e636b;
        }

        textarea.form-control {
            min-height: 150px;
            resize: vertical;
            padding-left: 16px;
        }

        .input-wrapper {
            position: relative;
        }

        .input-icon {
            position: absolute;
            left: 14px;
            top: 50%;
            transform: translateY(-50%);
            color: #666;
        }

        .badge {
            display: inline-block;
            background: #e8f5e9;
            color: #0e636b;
            font-size: 11px;
            font-weight: 600;
            padding: 2px 8px;
            border-radius: 4px;
            margin-left: 8px;
            text-transform: uppercase;
        }

        /* Radio Buttons */
        .radio-group {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .radio-option {
            display: flex;
            align-items: center;
            cursor: pointer;
        }

        .radio-option input[type="radio"] {
            width: 20px;
            height: 20px;
            margin-right: 10px;
            cursor: pointer;
            accent-color: #0e636b;
        }

        .radio-option label {
            cursor: pointer;
            color: #2d2d2d;
        }

        /* Checkbox */
        .checkbox-option {
            display: flex;
            align-items: flex-start;
            cursor: pointer;
            gap: 10px;
        }

        .checkbox-option input[type="checkbox"] {
            width: 20px;
            height: 20px;
            cursor: pointer;
            accent-color: #0e636b;
            margin-top: 2px;
        }

        .checkbox-option label {
            cursor: pointer;
            color: #2d2d2d;
            flex: 1;
        }

        /* Pay Range */
        .pay-range-grid {
            display: grid;
            grid-template-columns: 140px 1fr 1fr;
            gap: 12px;
            margin-top: 12px;
        }

        .pay-label {
            font-size: 13px;
            color: #666;
            font-weight: 500;
            margin-bottom: 4px;
        }

        select.form-control {
            padding-left: 16px;
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg width='12' height='8' viewBox='0 0 12 8' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M1 1.5L6 6.5L11 1.5' stroke='%23666' stroke-width='2' stroke-linecap='round'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 12px center;
            padding-right: 36px;
        }

        .help-text {
            font-size: 13px;
            color: #666;
            margin-top: 8px;
            margin-bottom: 12px;
        }

        /* Ad Type Cards */
        .ad-types-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 40px;
        }

        .ad-type-card {
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            padding: 24px;
            cursor: pointer;
            transition: all 0.2s;
            position: relative;
        }

        .ad-type-card:hover {
            border-color: #0e636b;
        }

        .ad-type-card.recommended {
            background: #0a2540;
            color: white;
            border-color: #0a2540;
        }

        .recommended-badge {
            position: absolute;
            top: 16px;
            right: 16px;
            background: #e91e63;
            color: white;
            padding: 4px 12px;
            border-radius: 4px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
        }

        .ad-type-label {
            font-size: 12px;
            text-transform: uppercase;
            margin-bottom: 8px;
            color: #666;
        }

        .ad-type-card.recommended .ad-type-label {
            color: #90caf9;
        }

        .ad-type-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 12px;
        }

        .ad-type-icon {
            margin: 20px 0;
            font-size: 24px;
        }

        .ad-type-price {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 16px;
        }

        .ad-type-performance {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
            margin-bottom: 16px;
        }

        .ad-type-btn {
            width: 100%;
            padding: 12px;
            border: 2px solid #0e636b;
            background: white;
            color: #0e636b;
            border-radius: 6px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
        }

        .ad-type-btn:hover {
            background: #0e636b;
            color: white;
        }

        .ad-type-card.recommended .ad-type-btn {
            background: white;
            border-color: white;
            color: #0a2540;
        }

        /* Comparison Table */
        .comparison-table {
            margin-top: 40px;
        }

        .comparison-table h2 {
            margin-bottom: 24px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            padding: 16px;
            text-align: left;
            border-bottom: 1px solid #e0e0e0;
        }

        th {
            font-weight: 600;
            color: #2d2d2d;
        }

        td {
            color: #666;
        }

        /* Rich Text Editor */
        .editor-toolbar {
            display: flex;
            gap: 4px;
            padding: 8px;
            border: 1px solid #d0d0d0;
            border-bottom: none;
            border-radius: 6px 6px 0 0;
            background: #f8f9fa;
        }

        .editor-btn {
            padding: 6px 10px;
            border: 1px solid transparent;
            background: transparent;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            color: #666;
        }

        .editor-btn:hover {
            background: white;
            border-color: #d0d0d0;
        }

        .editor-content {
            border: 1px solid #d0d0d0;
            border-radius: 0 0 6px 6px;
            min-height: 200px;
            padding: 16px;
        }

        /* Suggestion Box */
        .suggestion-box {
            border: 2px solid #e91e63;
            border-radius: 8px;
            padding: 24px;
            background: white;
        }

        .suggestion-icon {
            color: #e91e63;
            font-size: 32px;
            margin-bottom: 16px;
        }

        .suggestion-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 12px;
            color: #2d2d2d;
        }

        .suggestion-text {
            color: #666;
            margin-bottom: 20px;
        }

        .suggestion-divider {
            text-align: center;
            color: #999;
            margin: 20px 0;
        }

        .ai-btn {
            padding: 12px 24px;
            border: 2px solid #e91e63;
            background: white;
            color: #e91e63;
            border-radius: 6px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
        }

        .ai-btn:hover {
            background: #e91e63;
            color: white;
        }

        /* Image Upload */
        .upload-area {
            border: 2px dashed #d0d0d0;
            border-radius: 6px;
            padding: 40px;
            text-align: center;
            background: #fafafa;
            margin-bottom: 16px;
        }

        .upload-btn {
            padding: 12px 24px;
            background: #374151;
            color: white;
            border: none;
            border-radius: 6px;
            font-weight: 600;
            cursor: pointer;
        }

        /* Questions Section */
        .questions-section {
            margin-top: 40px;
        }

        .progress-bar {
            width: 100%;
            height: 8px;
            background: #e0e0e0;
            border-radius: 4px;
            margin: 12px 0 24px;
            overflow: hidden;
        }

        .progress-fill {
            height: 100%;
            background: #0e636b;
            border-radius: 4px;
            transition: width 0.3s;
        }

        .question-card {
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 16px;
        }

        .question-card.selected {
            border-color: #0e636b;
            background: #f0f7ff;
        }

        .question-title {
            display: flex;
            align-items: flex-start;
            gap: 12px;
            margin-bottom: 12px;
        }

        .question-checkbox {
            margin-top: 2px;
        }

        .search-box {
            position: relative;
            margin-bottom: 32px;
        }

        .search-icon {
            position: absolute;
            left: 14px;
            top: 50%;
            transform: translateY(-50%);
            color: #666;
        }

        .search-input {
            width: 100%;
            padding: 12px 16px 12px 44px;
            border: 1px solid #d0d0d0;
            border-radius: 6px;
            font-size: 15px;
        }

        /* Verification Card */
        .verification-card {
            background: #f8f9fa;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            padding: 24px;
            display: flex;
            gap: 20px;
            margin-bottom: 32px;
        }

        .verification-content {
            flex: 1;
        }

        .verification-icon {
            font-size: 64px;
        }

        .free-badge {
            display: inline-block;
            background: #e8f5e9;
            color: #2e7d32;
            padding: 4px 12px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 600;
            margin-bottom: 12px;
        }

        /* Buttons */
        .form-actions {
            display: flex;
            justify-content: space-between;
            gap: 12px;
            margin-top: 40px;
            padding-top: 24px;
            border-top: 1px solid #e0e0e0;
        }

        .btn {
            padding: 12px 24px;
            border-radius: 6px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            border: none;
            transition: all 0.2s;
        }

        .btn-secondary {
            background: white;
            color: #2d2d2d;
            border: 1px solid #d0d0d0;
        }

        .btn-secondary:hover {
            background: #f8f9fa;
        }

        .btn-primary {
            background: #0e636b;
            color: white;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary:hover {
            background: #1e4a8a;
        }

        .btn-back {
            background: transparent;
            color: #2d2d2d;
            border: none;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .two-column {
            display: grid;
            grid-template-columns: 1fr 400px;
            gap: 32px;
        }

        @media (max-width: 768px) {
            .two-column {
                grid-template-columns: 1fr;
            }
        }
    </style>

@endsection
