@extends('layouts.app')
@section('title', 'SKILLPOTS - Find Your Dream Job')
@section('content')
<!-- Hero Section -->

<livewire:web.index.modal.signinmodal/>
<livewire:web.index.modal.signupmodal/>
<section class="hero">
    <div class="hero-background"></div>
    <div class="container">
        <div class="hero-content">
            <h1 class="hero-title">
                The Place to Find<br>
                <span class="highlight">World Class</span> Talent
            </h1>
            <p class="hero-subtitle">
                Powered by AI - Find your next opportunity or hire the best talent in seconds.
            </p>

            <div class="search-container">
                <form class="search-form">
                    <div class="search-field">
                        <i class="fas fa-search search-icon"></i>
                        <input type="text" placeholder="Looking for?" class="search-input">
                    </div>
                    <div class="search-field">
                        <i class="fas fa-briefcase search-icon"></i>
                        <input type="text" placeholder="Category" class="search-input">
                    </div>
                    <div class="search-field">
                        <i class="fas fa-map-marker-alt search-icon"></i>
                        <input type="text" placeholder="Location" class="search-input">
                    </div>
                    <button type="button" class="apply-btn">Search Jobs</button>
                </form>
            </div>

            {{-- <div class="popular-categories">
                <div class="popular-label">Popular:</div>
                <div class="category-tags">
                    <span class="category-tag highlight-tag">Designer</span>
                    <span class="category-tag highlight-tag">Programming</span>
                    <span class="category-tag highlight-tag">Digital Marketing</span>
                    <span class="category-tag highlight-tag">Video</span>
                    <span class="category-tag highlight-tag">Animation</span>
                </div>
            </div> --}}
        </div>
    </div>
</section>
<!-- CTA Section -->
<section class="cta-section">
    <div class="container">
        <div class="cta-grid">
            <div class="cta-card job-seeker-card">
                <div class="cta-image">
                    <img src="{{ asset('images/01.JPG') }}"
                         loading="lazy"
                         alt="Job seeker working on laptop"
                         class="cta-img">
                </div>
                <div class="cta-content">
                    <h3 class="cta-title">Become a Job Seeker</h3>
                    <p class="cta-description">
                       Find your dream job at top companies in Pacific. Get matched with opportunities that perfectly fit your skills and aspirations.
                    </p>
                      <p class="cta-ai mb-4 d-flex align-items-center">
            <i class="fas fa-microchip text-primary me-2 fs-5"></i>
            <span>
                Our <strong>AI-powered tools</strong> craft compelling cover letters, optimize your self-assessments,
                and provide key market insights to help you stand out.
            </span>
        </p>
                    <button class="register-btn white-btn">
                        Register Now <i class="fas fa-arrow-right"></i>
                    </button>
                </div>
            </div>

            <div class="cta-card recruiter-card">
                <div class="cta-image">
                    <img src="{{ asset('images/02.JPG') }}"
                         loading="lazy"
                         alt="Recruiting team discussing candidates"
                         class="cta-img">
                </div>
                <div class="cta-content">
                    <h3 class="cta-title">Become a Recruiter</h3>
                    <p class="cta-description">
                       Access our pool of vetted professionals. Our AI matching system helps you find the perfect candidate in just <br>minutes.
                    </p>
                       <p class="cta-ai mb-4 d-flex align-items-center">
            <i class="fas fa-microchip text-primary me-2 fs-5"></i>
            <span>
                 Use our <strong>AI-powered matching</strong> to shortlist the best candidates instantly and save valuable time.
            </span>
        </p>
                    <div class="row">
                        <div class="col-md-6">
                         <button class="register-btn white-btn">
                        Register Now <i class="fas fa-arrow-right"></i>
                    </button>
                        </div>

                     <div class="col-md-6">
                         <button class="register-btn white-btn">
                        Watch video
                    </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Seekers Section -->
<section class="seekers-section">
    <div class="container">
        <div class="seekers-content">
            <h2 class="seekers-title">
                Job <span class="highlight">Seekers</span>
            </h2>

            <div class="features-workflow">
                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-user-edit"></i>
                    </div>
                    <h3 class="feature-title">Quick Profile Builder</h3>
                    <p class="feature-description">
                        AI-based cover letter builder as per the advertised job - based on your profile
                    </p>
                </div>

                <div class="workflow-connector">
                    <svg class="connector-line" viewBox="0 0 300 100">
                        <path d="M 0 50 Q 150 10 300 50" stroke="#1e40af" stroke-width="2" fill="none" stroke-dasharray="8,4"/>
                        <polygon points="290,45 300,50 290,55" fill="#1e40af"/>
                    </svg>
                </div>

                <div class="feature-item center-feature">
                    <div class="feature-icon">
                        <i class="fas fa-bell"></i>
                    </div>
                    <h3 class="feature-title">Personalized Job Alerts</h3>
                    <p class="feature-description">
                        Get notified about jobs that match your skills and preferences
                    </p>
                </div>

                <div class="workflow-connector">
                    <svg class="connector-line" viewBox="0 0 300 100">
                        <path d="M 0 50 Q 150 90 300 50" stroke="#1e40af" stroke-width="2" fill="none" stroke-dasharray="8,4"/>
                        <polygon points="290,45 300,50 290,55" fill="#1e40af"/>
                    </svg>
                </div>

                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-search"></i>
                    </div>
                    <h3 class="feature-title">Advanced Job Search</h3>
                    <p class="feature-description">
                        Find exactly what you're looking for with our powerful search filters
                    </p>
                </div>

                <div class="workflow-connector last">
                    <svg class="connector-line" viewBox="0 0 300 100">
                        <path d="M 0 50 Q 150 10 300 50" stroke="#1e40af" stroke-width="2" fill="none" stroke-dasharray="8,4"/>
                        <polygon points="290,45 300,50 290,55" fill="#1e40af"/>
                    </svg>
                </div>

                <div class="feature-item">
                    <div class="feature-icon">
                        <i class="fas fa-history"></i>
                    </div>
                    <h3 class="feature-title">History Overview</h3>
                    <p class="feature-description">
                        Track your application history and status updates in one place
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Recruiters Portal Section -->
<section class="recruiters-section">
    <div class="container">
        <h2 class="recruiters-title"><span class="highlight">Recruiters</span> Portal</h2>

        <div class="recruiters-content">
            <div class="recruiters-info">
                <div class="recruiters-cta">
                    <p>Start job Posting today – Sign up for free</p>
                </div>

                <ul class="recruiters-features">
                    <li>
                        <i class="fas fa-bolt"></i>
                        <span>Quick Job Posting Wizard</span>
                    </li>
                    <li>
                        <i class="fas fa-robot"></i>
                        <span>AI Candidate Matching</span>
                    </li>
                    <li>
                        <i class="fas fa-chart-line"></i>
                        <span>Performance Analytics</span>
                    </li>
                    <li>
                        <i class="fas fa-calendar-alt"></i>
                        <span>Interview Scheduling Tools</span>
                    </li>
                </ul>

                <button class="recruiters-signup-btn">Sign Up For Free</button>
            </div>

            <div class="recruiters-image">
    <video autoplay muted loop class="video-preview">
        <source src="{{ asset('vedio/jbseeker.mp4') }}" type="video/mp4">
        Your browser does not support HTML5 video.
    </video>
</div>

<style>
.recruiters-image {
    width: 350px;
    height: 400px;
    overflow: hidden;
    border-radius: 10px;
    position: relative;
}

.video-preview {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
</style>

        </div>
    </div>
</section>
<!-- Popular Categories Section -->
<section class="popular-categories-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">Popular Categories</h2>
            <button class="view-all-link">View All <i class="fas fa-arrow-right"></i></button>
        </div>

        <div class="categories-grid">
            <div class="category-card">
                <div class="category-icon">
                    <i class="fas fa-paint-brush"></i>
                </div>
                <h3 class="category-name">Graphics & Design</h3>
                <p class="job-count">357 open jobs</p>
            </div>

            <div class="category-card">
                <div class="category-icon">
                    <i class="fas fa-code"></i>
                </div>
                <h3 class="category-name">Code & Programming</h3>
                <p class="job-count">312 open jobs</p>
            </div>

            <div class="category-card">
                <div class="category-icon">
                    <i class="fas fa-bullhorn"></i>
                </div>
                <h3 class="category-name">Digital Marketing</h3>
                <p class="job-count">297 open jobs</p>
            </div>

            <div class="category-card">
                <div class="category-icon">
                    <i class="fas fa-video"></i>
                </div>
                <h3 class="category-name">Video & Animation</h3>
                <p class="job-count">247 open jobs</p>
            </div>

            <div class="category-card">
                <div class="category-icon">
                    <i class="fas fa-music"></i>
                </div>
                <h3 class="category-name">Music & Audio</h3>
                <p class="job-count">204 open jobs</p>
            </div>

            <div class="category-card">
                <div class="category-icon">
                    <i class="fas fa-calculator"></i>
                </div>
                <h3 class="category-name">Account & Finance</h3>
                <p class="job-count">167 open jobs</p>
            </div>

            <div class="category-card">
                <div class="category-icon">
                    <i class="fas fa-heartbeat"></i>
                </div>
                <h3 class="category-name">Health & Care</h3>
                <p class="job-count">125 open jobs</p>
            </div>

            <div class="category-card">
                <div class="category-icon">
                    <i class="fas fa-chart-bar"></i>
                </div>
                <h3 class="category-name">Data & Science</h3>
                <p class="job-count">57 open jobs</p>
            </div>
        </div>
    </div>
</section>
<!-- Testimonial Section -->
<section class="testimonial-section">
    <div class="container">
        <div class="testimonial-header">
            <h2 class="testimonial-title">Client Testimonials</h2>
        </div>

        <div class="testimonial-slider">
            <div class="testimonial-container">
                <div class="testimonial-card">
                    <div class="stars">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="testimonial-text">
                        "This platform completely transformed our hiring process. We found the perfect candidate within days of posting our job. The AI matching is incredibly accurate!"
                    </p>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                            <img src="{{ asset('images/01.JPG') }}" alt="Robert Fox">
                        </div>
                        <div class="author-info">
                            <h4 class="author-name">Robert Fox</h4>
                            <p class="author-title">UI/UX Designer</p>
                        </div>
                    </div>
                </div>

                <div class="testimonial-card">
                    <div class="stars">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="testimonial-text">
                        "As a creative director, I need top talent quickly. Skillpots delivered beyond my expectations. The quality of candidates is unmatched."
                    </p>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                           <img src="{{ asset('images/01.JPG') }}" alt="Bessie Cooper">
                        </div>
                        <div class="author-info">
                            <h4 class="author-name">Bessie Cooper</h4>
                            <p class="author-title">Creative Director</p>
                        </div>
                    </div>
                </div>

                <div class="testimonial-card">
                    <div class="stars">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                    <p class="testimonial-text">
                        "I found my dream job through Skillpots! The personalized job alerts were spot on, and the application process was seamless. Highly recommended!"
                    </p>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                            <img src="{{ asset('images/01.JPG') }}" alt="Jane Cooper">
                        </div>
                        <div class="author-info">
                            <h4 class="author-name">Jane Cooper</h4>
                            <p class="author-title">Photographer</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="testimonial-controls">
                <button class="testimonial-arrow prev-arrow" aria-label="Previous testimonial">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button class="testimonial-arrow next-arrow" aria-label="Next testimonial">
                    <i class="fas fa-chevron-right"></i>
                </button>
            </div>

            <div class="testimonial-dots">
                <button class="dot active" aria-label="Testimonial 1"></button>
                <button class="dot" aria-label="Testimonial 2"></button>
                <button class="dot" aria-label="Testimonial 3"></button>
            </div>
        </div>
    </div>
</section>
@endsection
@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Mobile menu toggle
        const mobileMenuBtn = document.querySelector('.mobile-menu-btn');
        const nav = document.querySelector('.nav');

        if (mobileMenuBtn && nav) {
            mobileMenuBtn.addEventListener('click', function() {
                nav.classList.toggle('active');
            });
        }

        // Testimonial slider functionality
        const testimonialContainer = document.querySelector('.testimonial-container');
        const prevButton = document.querySelector('.prev-arrow');
        const nextButton = document.querySelector('.next-arrow');
        const dots = document.querySelectorAll('.dot');

        if (testimonialContainer && prevButton && nextButton && dots.length > 0) {
            let currentIndex = 0;
            const testimonialCards = document.querySelectorAll('.testimonial-card');

            function showTestimonial(index) {
                testimonialContainer.style.transform = `translateX(-${index * 100}%)`;

                // Update dots
                dots.forEach((dot, i) => {
                    dot.classList.toggle('active', i === index);
                });
            }

            function nextTestimonial() {
                currentIndex = (currentIndex + 1) % testimonialCards.length;
                showTestimonial(currentIndex);
            }

            function prevTestimonial() {
                currentIndex = (currentIndex - 1 + testimonialCards.length) % testimonialCards.length;
                showTestimonial(currentIndex);
            }

            // Event listeners
            nextButton.addEventListener('click', nextTestimonial);
            prevButton.addEventListener('click', prevTestimonial);

            dots.forEach((dot, index) => {
                dot.addEventListener('click', () => {
                    currentIndex = index;
                    showTestimonial(currentIndex);
                });
            });

            // Auto-rotate testimonials
            setInterval(nextTestimonial, 5000);
        }
    });
</script>
@endpush
