<div>
    <div class="container-fluid mt-5">
        <div class="mb-5">
            <div class="row justify-content-center">
                <div class="col-auto">
                    <div class="d-flex align-items-center gap-3">
                        <button
                            wire:click="setRole('jobseeker')"
                            class="w-form-btn {{ $userRole === 'jobseeker' ? 'role-active' : '' }}"
                            type="button"
                        >
                            Jobseeker
                        </button>
                        <button
                            wire:click="setRole('recruiter')"
                            class="w-form-btn-outline {{ $userRole === 'recruiter' ? 'role-active' : '' }}"
                            type="button"
                        >
                            Recruiter
                        </button>
                    </div>
                </div>
            </div>
        </div>

        @if (session()->has('message'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('message') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="bg-white rounded-3 p-3 shadow-sm">
            <div class="row g-4">
                <div class="col-lg-6 p-3 p-lg-5">
                    <div class="mb-40">
                        <h2 class="section-title mb-2">Sign up as {{ $userRole === 'jobseeker' ? 'Jobseeker' : 'Recruiter' }}</h2>
                        <p class="section-desc">Welcome to Skillpots</p>
                    </div>

                    <form wire:submit.prevent="register">
                        <div class="form-container">
                            <div class="row gy-3">
                                <!-- Username -->
                                <div class="form-input col-lg-6">
                                    <label for="username" class="form-label">
                                        Username <span class="text-lime-300">*</span>
                                    </label>
                                    <input
                                        type="text"
                                        id="username"
                                        wire:model="username"
                                        class="form-control shadow-none @error('username') is-invalid @enderror"
                                        placeholder="Username"
                                    />
                                    @error('username')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Email -->
                                <div class="form-input col-lg-6">
                                    <label for="email" class="form-label">
                                        Email <span class="text-lime-300">*</span>
                                    </label>
                                    <input
                                        type="email"
                                        id="email"
                                        wire:model="email"
                                        class="form-control shadow-none @error('email') is-invalid @enderror"
                                        placeholder="demo@email.com"
                                    />
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Mobile Number -->
                                <div class="form-input col-lg-12">
                                    <label for="mobile_no" class="form-label">
                                        Mobile Number
                                    </label>
                                    <input
                                        type="text"
                                        id="mobile_no"
                                        wire:model="mobile_no"
                                        class="form-control shadow-none @error('mobile_no') is-invalid @enderror"
                                        placeholder="+1 234 567 8900"
                                    />
                                    @error('mobile_no')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Jobseeker Specific Fields -->
                                @if($userRole === 'jobseeker')
                                    <div class="form-input col-lg-12">
                                        <label for="profession" class="form-label">
                                            Profession <span class="text-lime-300">*</span>
                                        </label>
                                        <input
                                            type="text"
                                            id="profession"
                                            wire:model="profession"
                                            class="form-control shadow-none @error('profession') is-invalid @enderror"
                                            placeholder="e.g. Web Developer, Graphic Designer"
                                        />
                                        @error('profession')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>


                                @endif

                                <!-- Recruiter Specific Fields -->
                                @if($userRole === 'recruiter')
                                    <div class="form-input col-lg-12">
                                        <label for="company" class="form-label">
                                            Company Name <span class="text-lime-300">*</span>
                                        </label>
                                        <input
                                            type="text"
                                            id="company"
                                            wire:model="company"
                                            class="form-control shadow-none @error('company') is-invalid @enderror"
                                            placeholder="Your company name"
                                        />
                                        @error('company')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="form-input col-lg-12">
                                        <label for="position" class="form-label">
                                            Position <span class="text-lime-300">*</span>
                                        </label>
                                        <input
                                            type="text"
                                            id="position"
                                            wire:model="position"
                                            class="form-control shadow-none @error('position') is-invalid @enderror"
                                            placeholder="Your position in the company"
                                        />
                                        @error('position')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                @endif

                                <!-- Password -->
                                <div class="form-input col-lg-12">
                                    <label for="password" class="form-label">
                                        Password <span class="text-lime-300">*</span>
                                    </label>
                                    <input
                                        type="password"
                                        id="password"
                                        wire:model="password"
                                        class="form-control shadow-none @error('password') is-invalid @enderror"
                                        placeholder="********"
                                    />
                                    @error('password')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Confirm Password -->
                                <div class="form-input col-lg-12">
                                    <label for="password_confirmation" class="form-label">
                                        Confirm Password <span class="text-lime-300">*</span>
                                    </label>
                                    <input
                                        type="password"
                                        id="password_confirmation"
                                        wire:model="password_confirmation"
                                        class="form-control shadow-none"
                                        placeholder="********"
                                    />
                                </div>
                            </div>

                            <div class="d-grid mt-4">
                                <button type="submit" class="w-btn-secondary-lg" wire:loading.attr="disabled">
                                    <span wire:loading.remove>Create Account</span>
                                    <span wire:loading>
                                        <span class="spinner-border spinner-border-sm" role="status"></span>
                                        Processing...
                                    </span>
                                </button>
                            </div>
                        </div>
                    </form>

                    <div class="mt-3">
                        <p class="text-center form-text">
                            Already have an account? <a href="{{ route('skillpot.login.page') }}">Login</a>
                        </p>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="login-img">
                        <img
                            src="{{ asset('web/assets/img/others/1.png') }}"
                            class="img-fluid w-100 rounded"
                            alt="Registration Illustration"
                        />
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
