<div>
    @if (Auth::check())
	   @if (auth()->user()->role == 'jobseeker')
            <div class="profile-wrapper">
                        <div class="profile" id="profileToggle">
                            <div class="user">
                                <h4>{{ Auth::user()->name ?? 'N/A' }}</h4>

                            </div>
                            <div class="img-box">
                                <img src="https://i.postimg.cc/3Jstt1kF/images-7.png" alt="Katherine Cooper profile image">
                            </div>
                        </div>

                        <div class="menu" id="profileMenu">
                            <ul>
                                <li><a href="{{ route('my.profile.dashboard') }}"><i class="ph ph-user"></i>&nbsp;Profile</a></li>
                                <li><a href="#"><i class="ph ph-envelope-simple"></i>&nbsp;Inbox</a></li>
                                <li><a href="#"><i class="ph ph-gear-six"></i>&nbsp;Settings</a></li>
                                <li><a href="#"><i class="ph ph-question"></i>&nbsp;Help</a></li>
                                <li><a href="{{ route('sign.out') }}"><i class="ph ph-sign-out"></i>&nbsp;Sign Out</a></li>
                            </ul>
                        </div>
                    </div>
                @else
                    <div class="profile-wrapper">
                        <div class="profile" id="profileToggle">
                            <div class="user">
                                <h4>{{ Auth::user()->name ?? 'N/A' }}</h4>

                            </div>
                            <div class="img-box">
                              <img src="{{ asset('avatars/'.auth()->user()->profile_image) }}"
     alt="Katherine Cooper profile image"
     onerror="this.onerror=null; this.src='https://i.postimg.cc/3Jstt1kF/images-7.png';">


                            </div>
                        </div>

                        <div class="menu" id="profileMenu">
                            <ul>
                                <li><a href="{{ route('my.employer.dashboard') }}"><i class="ph ph-user"></i>&nbsp;Dashboard</a></li>
                                <li><a href="#"><i class="ph ph-envelope-simple"></i>&nbsp;Inbox</a></li>
                                <li><a href="#"><i class="ph ph-gear-six"></i>&nbsp;Settings</a></li>
                                <li><a href="#"><i class="ph ph-question"></i>&nbsp;Help</a></li>
                                <li><a href="{{ route('sign.out') }}"><i class="ph ph-sign-out"></i>&nbsp;Sign Out</a></li>
                            </ul>
                        </div>
                    </div>
       @endif

    @else
        <button class="signup-btn" wire:click="opensignmodal">
            <i class="fas fa-sign-in-alt"></i> Sign In
        </button>
    @endif

       <script>
        document.addEventListener("DOMContentLoaded", () => {
            const profileToggle = document.getElementById("profileToggle");
            const profileMenu = document.getElementById("profileMenu");
            const mobileBtn = document.getElementById("mobileMenuToggle");
            const nav = document.querySelector(".nav");
            const overlay = document.getElementById("overlay");

            // Toggle mobile menu
            function toggleMobileMenu() {
                nav.classList.toggle("active");
                overlay.classList.toggle("active");
                // Close profile menu when mobile menu opens
                if (nav.classList.contains("active")) {
                    profileMenu.classList.remove("active");
                }
            }

            // Profile dropdown toggle
            function toggleProfileMenu() {
                if (window.innerWidth > 992) {
                    // Desktop behavior
                    profileMenu.classList.toggle("active");
                } else {
                    // Mobile behavior
                    profileMenu.classList.toggle("active");
                }
            }

            // Close menus when clicking outside
            function closeMenus(e) {
                // Close profile menu if clicked outside
                if (profileToggle && !profileToggle.contains(e.target) && !profileMenu.contains(e.target)) {
                    profileMenu.classList.remove("active");
                }

                // Close mobile menu if clicked outside
                if (nav.classList.contains("active") && !nav.contains(e.target) &&
                    e.target !== mobileBtn && !mobileBtn.contains(e.target)) {
                    toggleMobileMenu();
                }
            }

            // Event listeners
            if (profileToggle) {
                profileToggle.addEventListener("click", toggleProfileMenu);
            }

            mobileBtn.addEventListener("click", toggleMobileMenu);

            overlay.addEventListener("click", () => {
                nav.classList.remove("active");
                overlay.classList.remove("active");
                profileMenu.classList.remove("active");
            });

            document.addEventListener("click", closeMenus);

            // Close menus when window is resized
            window.addEventListener("resize", () => {
                if (window.innerWidth > 992) {
                    nav.classList.remove("active");
                    overlay.classList.remove("active");
                }
            });
        });
    </script>

</div>
