<div>

    <div class="dashboard-container">
        <!-- Left Column -->
        <div class="left-column">
            <div class="card profile-card">
                <div class="profile-banner"></div>
                <div class="profile-info">
    <div class="profile-avatar-wrapper text-center">
        <!-- Avatar Preview -->
        <div class="profile-avatar mb-2"
            style="width:100px; height:100px; border-radius:50%; overflow:hidden; background:#f0f0f0; display:flex; align-items:center; justify-content:center; font-size:32px; cursor:pointer;">
            @if ($photo)
                <img src="{{ $photo->temporaryUrl() }}" alt="Avatar"
                    class="w-100 h-100 object-fit-cover">
            @elseif(auth()->user()->profile_image)
                <img src="{{ asset('avatars/' . auth()->user()->profile_image) }}" alt="Avatar"
                    class="w-100 h-100 object-fit-cover">
            @else
                {{ strtoupper(substr(auth()->user()->name, 0, 2)) }}
            @endif
        </div>

        <!-- Upload Button -->
        <input type="file" wire:model="photo" accept="image/*" id="avatarUpload" class="d-none">
        <button type="button" class="btn btn-sm btn-outline-primary"
            onclick="document.getElementById('avatarUpload').click()">Upload Avatar</button>

        @error('photo')
            <div class="text-danger mt-1">{{ $message }}</div>
        @enderror

        <!-- Save Button -->
        @if ($photo)
            <button type="button" class="btn btn-sm btn-success mt-2"
                wire:click="saveAvatar">Save</button>
        @endif
    </div>

    <h1 class="profile-name">{{ Auth::user()->name ?? 'N/A' }}</h1>
    <div class="align-items-center gap-2">
        @if (!$editMode)
            <button class="btn btn-link p-0" wire:click="edit" title="Edit title"
                aria-label="Edit title">
                <i class="fas fa-pencil-alt text-muted"></i>
            </button>
            <div class="profile-title m-0">{{ $profile_title }}</div>
        @else
            <div class="d-flex align-items-center gap-2">
                <button class="btn btn-link p-0" wire:click="save" title="Save" aria-label="Save">
                    <i class="fas fa-check"></i>
                </button>
                <input type="text" class="form-control form-control-sm w-auto"
                    wire:model.defer="profile_title" wire:keydown.enter="save"
                    wire:keydown.escape="cancel" autofocus />
                <button class="btn btn-sm btn-outline-secondary" wire:click="cancel">Cancel</button>
                @error('profile_title')
                    <small class="text-danger ms-2">{{ $message }}</small>
                @enderror
            </div>
        @endif
    </div>


    <div class="d-flex align-items-center gap-2">
        @if (!$editLocation)
            <!-- Pencil icon -->
            <button class="btn btn-link p-0 me-1" wire:click="editlocation" title="Edit location">
                <i class="fas fa-pencil-alt text-muted"></i>
            </button>
            <div class="profile-location">
                <i class="fas fa-location-dot"></i> {{ $profile_location }}
            </div>
        @else
            <!-- Save / Cancel buttons -->
            <button class="btn btn-link p-0 me-1" wire:click="saveLocation" title="Save">
                <i class="fas fa-check text-success"></i>
            </button>
            <input type="text" class="form-control form-control-sm w-auto"
                wire:model.defer="profile_location" wire:keydown.enter="saveLocation"
                wire:keydown.escape="cancelLocation" autofocus />
            <button class="btn btn-sm btn-outline-secondary ms-1"
                wire:click="cancelLocation">Cancel</button>
            @error('profile_location')
                <small class="text-danger ms-2">{{ $message }}</small>
            @enderror
        @endif
    </div>

    {{-- <div class="connections">
        <i class="fas fa-user"></i> 21 connections
    </div> --}}

    <!-- Become Employer Section -->
    <div class="employer-section mt-4 p-3 border rounded bg-light">
        <h6 class="mb-2"><i class="fas fa-briefcase me-2"></i>Employer Account</h6>
        <p class="text-muted small mb-2">Upgrade to post jobs and hire talent</p>

        @if($is_employer)
            <div class="d-flex align-items-center justify-content-between">
                <span class="badge bg-success">Employer Account</span>
                <button class="btn btn-sm btn-outline-secondary" wire:click="toggleEmployerMode">
                    Employer Dashboard
                </button>
            </div>
        @else
            <button class="btn btn-primary btn-sm w-100" wire:click="toggleEmployerMode">
                <i class="fas fa-building me-1"></i> Become Employer
            </button>
        @endif
    </div>
</div>

            </div>

            <div class="card">
                <div class="card-header">
                    <span>Profile Analytics</span>
                    <i class="fas fa-chart-line"></i>
                </div>
                <div class="card-body">
                    <div class="analytics-grid">
                        <div class="analytics-item">
                            <div>Profile views</div>
                            <div class="analytics-number">21</div>
                        </div>
                        <div class="analytics-item">
                            <div>Post impressions</div>
                            <div class="analytics-number">48</div>
                        </div>
                        <div class="analytics-item">
                            <div>Search appearances</div>
                            <div class="analytics-number">12</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <span>Resources</span>
                    <i class="fas fa-toolbox"></i>
                </div>
                <div class="card-body">
                    <div class="ai-enhancement">
                        <div class="ai-header">
                            <div class="icon-circle">
                                <i class="fas fa-wand-magic-sparkles"></i>
                            </div>
                            Enhance your profile with AI
                        </div>
                        <p>Stand out for almost 2x as many opportunities with a stronger profile.</p>
                        <button class="btn btn-primary">Enhance Now</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Middle Column -->
        <div class="middle-column">
            <div class="card">
                <div class="card-header">
                    <span>Add profile section</span>
                    <i class="fas fa-plus-circle" wire:click="add_modal_view"></i>
                </div>
                <div class="card-body">
                    <p>Show recruiters what you're about by adding more sections to your profile.</p>
                    <button class="btn btn-outline" wire:click="add_modal_view">Add section</button>
                </div>
            </div>
            <livewire:web.index.profile.modal.addsectionmodal />
            <livewire:web.index.profile.modal.addedumodal />
            <livewire:web.index.profile.modal.addexpereincemodal />
            <livewire:web.index.profile.modal.addprojectmodal />
            <livewire:web.index.profile.modal.addcoursemodal />
            <livewire:web.index.profile.modal.addskillmodal />
            <livewire:web.index.profile.modal.addlanguagemodal />
            <livewire:web.index.profile.modal.addachievementmodal />
              <livewire:web.index.profile.modal.summary.personalsummarymodal />


         <div class="card shadow-lg border-0 rounded-4 p-4 mb-4">
    <div class="d-flex align-items-center justify-content-between mb-3">
        <!-- Left side -->
        <div class="d-flex align-items-center">
            <div class="bg-gradient-primary text-white d-flex align-items-center justify-content-center me-3"
                 style="width:50px; height:50px; border-radius:12px; background: linear-gradient(135deg, #4e73df, #224abe);">
                <i class="fas fa-user-circle fa-lg"></i>
            </div>
            <h5 class="mb-0 fw-bold">Personal Summary</h5>
        </div>
        <!-- Right side (edit icon) -->
        <button class="btn btn-link p-0" title="Edit summary" wire:click="editpersonalsummary">
            <i class="fas fa-pencil-alt text-muted"></i>
        </button>
    </div>

    <p class="text-muted mb-0">
     {{ $personalsummary->summary ?? 'Add a personal summary to your profile' }}
    </p>
</div>


            <div class="card">
                <div class="card-header">
                    <span>Job Recommendations</span>
                    <i class="fas fa-bullseye"></i>
                </div>
                <div class="card-body">
                    <p>Discover job opportunities that match your skills and interests.</p>
                    <button class="btn btn-outline">Explore jobs</button>
                </div>
            </div>
        </div>

        <!-- Right Column -->
        <div class="right-column">
            <div class="card premium-card" hidden>
                <div class="card-header premium-header">
                    <span>Try Premium for free</span>
                    <i class="fas fa-crown"></i>
                </div>
                <div class="card-body">
                    <p>1-month free with 24/7 support. Cancel anytime. We'll remind you 7 days before your trial ends.
                    </p>
                    <button class="premium-btn">Try Premium for LKRO</button>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <span>Profile Language</span>
                    <i class="fas fa-language"></i>
                </div>
                <div class="card-body">
                    @if ($lang)
                      @foreach ($lang as $l)
                             <div class="analytics-item">
                        <div>{{ $l->language }}</div>
                        <div class="analytics-number">{{ $l->level }}</div>
                    </div>
                      @endforeach

                    @endif

                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <span>Public profile & URL</span>
                    <i class="fas fa-link"></i>
                </div>
                <div class="card-body">
                    <div class="url-box">
                        <span>www.skillpots.com/{{ $profile_url }}</span>
                        <i class="far fa-copy copy-icon" id="copyUrl"></i>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <span>People you may know</span>
                    <i class="fas fa-user-plus"></i>
                </div>
                <div class="card-body">
                    <div class="suggestion-item">
                        <div class="suggestion-info">
                            <div class="suggestion-avatar">GM</div>
                            <div class="suggestion-text">
                                <div class="suggestion-name">Ghulam Mustafa</div>
                                <div class="suggestion-title">Student at University of Engineering and Technology...
                                </div>
                            </div>
                        </div>
                        <div class="connect-btn">Connect</div>
                    </div>
                    <div class="suggestion-item">
                        <div class="suggestion-info">
                            <div class="suggestion-avatar">SB</div>
                            <div class="suggestion-text">
                                <div class="suggestion-name">Someone at George Bernard</div>
                                <div class="suggestion-title">HR Manager</div>
                            </div>
                        </div>
                        <div class="connect-btn">View</div>
                    </div>
                    <div class="suggestion-item">
                        <div class="suggestion-info">
                            <div class="suggestion-avatar">UP</div>
                            <div class="suggestion-text">
                                <div class="suggestion-name">Someone at University of the Punjab...</div>
                                <div class="suggestion-title">Professor</div>
                            </div>
                        </div>
                        <div class="connect-btn">View</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Copy URL functionality
        document.getElementById('copyUrl').addEventListener('click', function() {
            const url = document.querySelector('.url-box span').textContent;
            navigator.clipboard.writeText(url).then(() => {
                const originalIcon = this.classList.contains('fa-copy');
                if (originalIcon) {
                    this.classList.remove('fa-copy');
                    this.classList.add('fa-check', 'copied');
                    setTimeout(() => {
                        this.classList.remove('fa-check', 'copied');
                        this.classList.add('fa-copy');
                    }, 2000);
                }
            });
        });

        // Add hover effects to cards
        document.querySelectorAll('.card').forEach(card => {
            card.addEventListener('mouseenter', () => {
                card.style.transform = 'translateY(-5px)';
            });

            card.addEventListener('mouseleave', () => {
                card.style.transform = 'translateY(0)';
            });
        });
    </script>
    <style>
        :root {
            --primary: #4361ee;

            --secondary: #6c63ff;
            --accent: #ff6584;
            --success: #4cc9f0;
            --warning: #f9c74f;
            --danger: #f94144;

            --bg-primary: #f8fafc;
            --bg-secondary: #ffffff;
            --bg-tertiary: #f1f5f9;

            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --text-tertiary: #94a3b8;

            --border-light: #e2e8f0;
            --border-medium: #cbd5e1;

            --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
            --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);

            --radius-sm: 0.375rem;
            --radius-md: 0.5rem;
            --radius-lg: 0.75rem;
            --radius-xl: 1rem;

            --transition: all 0.3s ease;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
        }



        .dashboard-container {
            max-width: 1440px;

            margin: 0 auto;
            display: grid;
            grid-template-columns: 320px 1fr 320px;
            gap: 24px;
            padding: 124px 60px 0px 50px;
        }

        /* Card Styles */
        .card {
            background-color: var(--bg-secondary);
            border-radius: var(--radius-lg);
            box-shadow: var(--shadow-md);
            margin-bottom: 24px;
            overflow: hidden;
            transition: var(--transition);
        }

        .card:hover {
            box-shadow: var(--shadow-lg);
        }

        .card-header {
            padding: 20px 24px;
            border-bottom: 1px solid var(--border-light);
            font-weight: 600;
            display: flex;
            justify-content: space-between;
            align-items: center;
            color: var(--text-primary);
            font-size: 16px;
        }

        .card-body {
            padding: 24px;
        }

        /* Profile Section */
        .profile-card {
            position: relative;
        }

        .profile-banner {
            height: 120px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border-radius: var(--radius-lg) var(--radius-lg) 0 0;
        }

        .profile-info {
            text-align: center;
            padding: 0 24px 24px;
            margin-top: -60px;
        }

        .profile-avatar {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            border: 4px solid var(--bg-secondary);
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            margin: 0 auto;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 36px;
            color: white;
            font-weight: bold;
            box-shadow: var(--shadow-md);
        }

        .profile-name {
            font-size: 20px;
            font-weight: 700;
            margin: 16px 0 8px;
            color: var(--text-primary);
        }

        .profile-title {
            color: var(--text-secondary);
            font-size: 14px;
            font-weight: 500;
        }

        .profile-location {
            color: var(--text-secondary);
            font-size: 14px;
            margin: 12px 0;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .connections {
            color: var(--text-secondary);
            font-size: 14px;
            margin: 12px 0;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .open-to-work {
            background: linear-gradient(to right, #e6f7ff, #f0f9ff);
            border-left: 4px solid var(--primary);
            border-radius: var(--radius-md);
            padding: 16px;
            margin: 16px 0;
            text-align: left;
        }

        .open-to-work-header {
            display: flex;
            align-items: center;
            gap: 8px;
            color: var(--primary);
            font-weight: 600;
            margin-bottom: 8px;
            font-size: 15px;
        }

        .show-details {
            color: var(--primary);
            font-weight: 500;
            font-size: 14px;
            cursor: pointer;
            margin-top: 8px;
        }

        /* Analytics */
        .analytics-grid {
            display: grid;
            grid-template-columns: 1fr;
            gap: 16px;
        }

        .analytics-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px 0;
        }

        .analytics-item:not(:last-child) {
            border-bottom: 1px solid var(--border-light);
        }

        .analytics-number {
            font-weight: 700;
            color: var(--primary);
            font-size: 18px;
        }

        /* Resources */
        .ai-enhancement {
            background: linear-gradient(135deg, #f0f9ff, #e6f7ff);
            border-radius: var(--radius-md);
            padding: 20px;
            margin: 16px 0;
            text-align: center;
        }

        .ai-header {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            font-weight: 600;
            margin-bottom: 12px;
            color: var(--primary);
            font-size: 16px;
        }

        /* Buttons */
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 10px 20px;
            border-radius: var(--radius-md);
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
            border: none;
            font-size: 14px;
            gap: 8px;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, var(--primary-dark), var(--secondary));
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
        }

        .btn-outline {
            background: transparent;
            color: var(--primary);
            border: 1px solid var(--primary);
        }

        .btn-outline:hover {
            background: rgba(67, 97, 238, 0.05);
        }

        /* Hiring Card */
        .hiring-card {
            background: linear-gradient(135deg, #f0f9ff, #e6f7ff);
            border-radius: var(--radius-lg);
            padding: 24px;
            margin: 24px 0;
            border-left: 4px solid var(--primary);
        }

        .hiring-header {
            display: flex;
            align-items: center;
            gap: 12px;
            font-weight: 600;
            margin-bottom: 12px;
            color: var(--primary);
            font-size: 16px;
        }

        /* Premium Card */
        .premium-card {
            background: linear-gradient(135deg, #fff9ed, #fff3e0);
            border: 1px solid #ffd8b1;
        }

        .premium-header {
            color: #f97316;
            font-weight: 700;
        }

        .premium-btn {
            background: linear-gradient(135deg, #f97316, #fb923c);
            color: white;
            border: none;
            border-radius: var(--radius-md);
            padding: 12px 20px;
            font-weight: 600;
            cursor: pointer;
            margin-top: 16px;
            width: 100%;
            transition: var(--transition);
        }

        .premium-btn:hover {
            background: linear-gradient(135deg, #ea580c, #f97316);
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
        }

        /* URL Box */
        .url-box {
            display: flex;
            align-items: center;
            justify-content: space-between;
            background-color: var(--bg-tertiary);
            border: 1px solid var(--border-light);
            border-radius: var(--radius-md);
            padding: 12px 16px;
            font-size: 14px;
            color: var(--text-secondary);
        }

        .copy-icon {
            color: var(--primary);
            cursor: pointer;
            transition: var(--transition);
        }

        .copy-icon:hover {
            color: var(--primary-dark);
        }

        /* Suggestions */
        .suggestion-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 16px;
            padding: 12px;
            border-radius: var(--radius-md);
            transition: var(--transition);
        }

        .suggestion-item:hover {
            background-color: var(--bg-tertiary);
        }

        .suggestion-info {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .suggestion-avatar {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            font-size: 16px;
        }

        .suggestion-text {
            font-size: 14px;
        }

        .suggestion-name {
            font-weight: 600;
            color: var(--text-primary);
        }

        .suggestion-title {
            color: var(--text-secondary);
            font-size: 13px;
        }

        .connect-btn {
            color: var(--primary);
            font-weight: 600;
            font-size: 13px;
            cursor: pointer;
            padding: 6px 12px;
            border-radius: var(--radius-md);
            transition: var(--transition);
        }

        .connect-btn:hover {
            background-color: rgba(67, 97, 238, 0.1);
        }

        /* Responsive Design */
        @media (max-width: 1200px) {
            .dashboard-container {
                grid-template-columns: 280px 1fr;
            }

            .right-column {
                display: none;
            }
        }

        @media (max-width: 900px) {
            .dashboard-container {
                grid-template-columns: 1fr;
                gap: 16px;
            }

            .left-column,
            .middle-column,
            .right-column {
                width: 100%;
            }
        }

        /* Animation for copy icon */
        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        .copied {
            animation: fadeIn 0.3s ease;
        }

        /* Divider */
        .divider {
            height: 1px;
            background-color: var(--border-light);
            margin: 16px 0;
        }

        /* Icons */
        .icon-circle {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: rgba(67, 97, 238, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary);
        }
    </style>
</div>
