<div>
    @if ($personalsummarymodal)
        <div class="modal fade show" style="display: block; background-color: rgba(0,0,0,0.5);" tabindex="-1"
            aria-modal="true" role="dialog" wire:ignore.self>
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content rounded-3 shadow-sm border-0">

                    <!-- Header -->
                    <div class="modal-header border-0 pb-0">
                        <h5 class="modal-title fw-semibold">Personal Summary</h5>
                        <button type="button" class="btn-close" wire:click="closeModal"></button>
                    </div>

                    <!-- Body -->
                    <div class="modal-body">
                        <form wire:submit.prevent="savePersonalSummary">
                            <div class="mb-3">
                                <label for="personalSummary" class="form-label fw-semibold">Your Summary</label>

                                <textarea id="personalSummary"
                                          wire:model.defer="personal_summary"
                                          class="form-control form-control-lg rounded-3 shadow-sm"
                                          rows="6"
                                          placeholder="Write a brief summary about yourself..."></textarea>

                                @error('personal_summary')
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror

                                <div class="mt-2">
                                   <button type="button" class="btn btn-outline-primary btn-sm" wire:click="generateSummary">
    <i class="fas fa-robot me-1"></i>
    Generate Summary

    <!-- Spinner shows only while loading -->
    <span wire:loading wire:target="generateSummary" class="spinner-border spinner-border-sm ms-1" role="status"></span>
</button>

                                </div>
                            </div>

                            <!-- Footer -->
                            <div class="modal-footer border-0">

                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    @endif
</div>
