<div>
    @if ($addskillmodal)
    <div class="modal fade show" style="display: block; background-color: rgba(0,0,0,0.5);" tabindex="-1" aria-modal="true" role="dialog" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content rounded-3 shadow-sm border-0">

                <!-- Header -->
                <div class="modal-header border-0 pb-0">
                    <h5 class="modal-title fw-semibold">Add skill</h5>
                    <button type="button" class="btn-close" wire:click="closeModal"></button>
                </div>

                <!-- Body -->
                <div class="modal-body">
                    <form wire:submit.prevent="saveSkill">

                        <!-- Skill Input -->
                        <div class="mb-3">
                            <label for="skill" class="form-label fw-semibold">
                                Skill<span class="text-danger">*</span>
                            </label>
                            <input type="text" id="skill" class="form-control"
                                   placeholder="Skill (ex: Project Management)"
                                   wire:model.live="skill">
                        </div>

                        <!-- Suggested Skills -->
                       <div class="mt-3">
    <p class="fw-semibold small mb-2">Suggested based on your profile</p>
    <div class="d-flex flex-wrap gap-2">
      @if ($suggestions)
            @foreach ($suggestions as $suggested)
            <span class="badge rounded-pill text-dark border border-secondary px-3 py-2"
                  style="cursor:pointer"
                  wire:click="setSkill('{{ $suggested }}')">
                  {{ $suggested }}
            </span>
        @endforeach
      @endif
    </div>
</div>


                    </form>
                </div>

                <!-- Footer -->
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-light" wire:click="closeModal">Cancel</button>
                    <button type="button" class="btn btn-primary" wire:click="saveSkill">Save</button>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
