<div>
    @if ($addlanguagemodal)
    <div class="modal fade show" style="display: block; background-color: rgba(0,0,0,0.5);" tabindex="-1" aria-modal="true" role="dialog" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content rounded-3 shadow-sm border-0">

                <!-- Header -->
                <div class="modal-header border-0 pb-0">
                    <h5 class="modal-title fw-semibold">Add Language</h5>
                    <button type="button" class="btn-close" wire:click="closeModal"></button>
                </div>

                <!-- Body -->
                <div class="modal-body">
                    <form wire:submit.prevent="saveLang">
                        <!-- Language Input -->
                        <div class="mb-3 position-relative">
                            <label for="language" class="form-label fw-semibold">Language</label>
                            <input type="text" id="language" class="form-control" placeholder="Enter language" wire:model.live="language">
                            @error('language') <span class="text-danger">{{ $message }}</span> @enderror

                            <!-- Suggestions dropdown -->
                            @if(!empty($suggestions))
                                <ul class="list-group position-absolute w-100 shadow mt-1" style="z-index: 1000;">
                                    @foreach($suggestions as $sugg)
                                        <li class="list-group-item list-group-item-action"
                                            wire:click="setLanguage('{{ $sugg }}')">
                                            {{ $sugg }}
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>

                        <!-- Proficiency Level -->
                        <div class="mb-3">
                            <label for="level" class="form-label fw-semibold">Proficiency Level</label>
                            <select id="level" class="form-select" wire:model="level">
                                <option value="">-- Select level --</option>
                                <option value="Beginner">Beginner</option>
                                <option value="Intermediate">Intermediate</option>
                                <option value="Advanced">Advanced</option>
                                <option value="Fluent">Fluent</option>
                                <option value="Native">Native</option>
                            </select>
                            @error('level') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                    </form>
                </div>

                <!-- Footer -->
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-light" wire:click="closeModal">Cancel</button>
                    <button type="button" class="btn btn-primary" wire:click="saveLang">Save</button>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
