<div>
@if ($addcoursemodal)
<div class="modal fade show" style="display: block; background-color: rgba(0,0,0,0.5);" tabindex="-1" aria-modal="true" role="dialog" wire:ignore.self>
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content rounded-3 shadow">
            <div class="modal-header border-0">
                <h5 class="modal-title">Add Course to Profile</h5>
                <button type="button" class="btn-close btn-close-white" wire:click="closeModal"></button>
            </div>
            <div class="modal-body p-4">
                <form wire:submit.prevent="saveCourse">
                    <!-- Course Name Field -->
                    <div class="mb-3">
                        <label for="courseName" class="form-label fw-bold">Course Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="courseName" wire:model="courseName"
                               placeholder="Enter course name" required>
                        @error('courseName') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <!-- Status Field -->
                    <div class="mb-3">
                        <label for="courseStatus" class="form-label fw-bold">Status <span class="text-danger">*</span></label>
                        <select class="form-select" id="courseStatus" wire:model="status" required>
                            <option value="" selected disabled>Select status</option>
                            <option value="completed">Completed</option>
                            <option value="following">Following</option>
                        </select>
                        @error('status') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <!-- Description Field -->
                    <div class="mb-3">
                        <label for="courseDescription" class="form-label fw-bold">Description</label>
                        <textarea class="form-control" id="courseDescription" wire:model="description"
                                  rows="4" placeholder="Enter course description"></textarea>
                        @error('description') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                </form>
            </div>
            <div class="modal-footer border-0">
                <button type="button" class="btn btn-secondary" wire:click="closeModal">Cancel</button>
                <button type="button" class="btn btn-primary" wire:click="saveCourse">Save Course</button>
            </div>
        </div>
    </div>
</div>
@endif
</div>
