<div>
    @if ($addachievementmodal)
        <div class="modal fade show" style="display: block; background-color: rgba(0,0,0,0.5);" tabindex="-1"
            aria-modal="true" role="dialog" wire:ignore.self>
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content rounded-3 shadow-sm border-0">

                    <!-- Header -->
                    <div class="modal-header border-0 pb-0">
                        <h5 class="modal-title fw-semibold">Add Achievement</h5>
                        <button type="button" class="btn-close" wire:click="closeModal"></button>
                    </div>

                    <!-- Body -->
                    <div class="modal-body">
                        <form wire:submit.prevent="saveAchievement">

                            <!-- Achievement Title -->
                            <div class="mb-3">
                                <label for="title" class="form-label">Achievement Title</label>
                                <input type="text" id="title" class="form-control"
                                       wire:model.defer="achievement_title"
                                       placeholder="e.g. Best Developer Award" />
                                @error('achievement_title') <small class="text-danger">{{ $message }}</small> @enderror
                            </div>

                            <!-- Issuer / Organization -->
                            <div class="mb-3">
                                <label for="issuer" class="form-label">Issuer / Organization</label>
                                <input type="text" id="issuer" class="form-control"
                                       wire:model.defer="achievement_issuer"
                                       placeholder="e.g. Tech Conference 2025" />
                                @error('achievement_issuer') <small class="text-danger">{{ $message }}</small> @enderror
                            </div>

                            <!-- Date -->
                            <div class="mb-3">
                                <label for="date" class="form-label">Date</label>
                                <input type="date" id="date" class="form-control"
                                       wire:model.defer="achievement_date" />
                                @error('achievement_date') <small class="text-danger">{{ $message }}</small> @enderror
                            </div>

                            <!-- Description -->
                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea id="description" rows="3" class="form-control"
                                          wire:model.defer="achievement_description"
                                          placeholder="Briefly describe your achievement..."></textarea>
                                @error('achievement_description') <small class="text-danger">{{ $message }}</small> @enderror
                            </div>

                            <!-- Optional Link -->
                            <div class="mb-3">
                                <label for="link" class="form-label">Link (optional)</label>
                                <input type="url" id="link" class="form-control"
                                       wire:model.defer="achievement_link"
                                       placeholder="https://example.com/certificate" />
                                @error('achievement_link') <small class="text-danger">{{ $message }}</small> @enderror
                            </div>

                            <!-- Footer -->
                            <div class="modal-footer border-0">
                                <button type="button" class="btn btn-light" wire:click="closeModal">Cancel</button>
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    @endif
</div>
