<div>
    @if ($opensignupmodal)
        <div class="modal-overlay">
            <div class="modal-container">
                <div class="modal-header">
                    <div class="modal-close" wire:click="closeModal">
                        <i class="fas fa-times"></i>
                    </div>
                    <p class="modal-title">Sign up to your account to continue</p>
                </div>

                <div class="modal-body">
                    <form wire:submit.prevent="submit">
                        @if (session()->has('success'))
                            <div class="alert alert-success">{{ session('success') }}</div>
                        @endif

                        <div class="form-group">
                            <label for="username" class="form-label">Username</label>
                            <div class="input-with-icon">
                                <i class="input-icon fas fa-user"></i>
                                <input type="text" id="username" wire:model="username" class="form-control"
                                    placeholder="Enter your username">
                            </div>
                            @error('username')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="email" class="form-label">Email</label>
                            <div class="input-with-icon">
                                <i class="input-icon fas fa-envelope"></i>
                                <input type="email" id="email" wire:model="email" class="form-control"
                                    placeholder="Enter your email">
                            </div>
                            @error('email')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label class="form-label d-block mb-2">Role</label>
                            <div class="d-flex gap-2">
                                <label class="small-role">
                                    <input type="radio" wire:model="role" value="jobseeker" />
                                    <span class="role-text">Jobseeker</span>
                                </label>

                                <label class="small-role">
                                    <input type="radio" wire:model="role" value="employer" />
                                    <span class="role-text">Employer</span>
                                </label>
                            </div>
                            @error('role')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>






                        <div class="form-group">
                            <label for="password" class="form-label">Password</label>
                            <div class="input-with-icon">
                                <i class="input-icon fas fa-lock"></i>
                                <input type="{{ $showPassword ? 'text' : 'password' }}" wire:model.live="password"
                                    id="password" class="form-control" placeholder="Enter your password">
                                <i class="password-toggle fas {{ $showPassword ? 'fa-eye-slash' : 'fa-eye' }}"
                                    wire:click="$toggle('showPassword')" style="cursor: pointer"></i>
                            </div>
                            <small> Strength: <span @class([
                                'text-danger' => $passwordStrength === 'Weak',
                                'text-warning' => $passwordStrength === 'Medium',
                                'text-success' => $passwordStrength === 'Strong',
                            ])> {{ $passwordStrength }} </span>
                            </small>
                            @error('password')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="confirm_password" class="form-label">Confirm Password</label>
                            <div class="input-with-icon">
                                <i class="input-icon fas fa-lock"></i>
                                <input type="{{ $showconfirmPassword ? 'text' : 'password' }}"
                                    wire:model="confirm_password" id="confirm_password" class="form-control"
                                    placeholder="Confirm your password">
                                <i class="password-toggle fas {{ $showconfirmPassword ? 'fa-eye-slash' : 'fa-eye' }}"
                                    wire:click="$toggle('showconfirmPassword')" style="cursor: pointer"></i>
                            </div>
                            @error('confirm_password')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <button type="submit" class="btn btn-primary" wire:loading.attr="disabled"
                            wire:target="submit">
                            <span wire:loading.remove wire:target="submit">Register</span>
                            <span wire:loading wire:target="submit">
                                <i class="fas fa-spinner fa-spin"></i> Registering...
                            </span>
                        </button>



                         <div class="signup-link">
                            Already have an account? <a href="#" wire:click="signinmodal">Sign in</a>
                        </div>

                    </form>

                </div>
            </div>
        </div>

        <script>
            document.addEventListener('livewire:navigate', function() {
                // Password toggle functionality
                const passwordToggle = document.querySelector('.password-toggle');
                const passwordInput = document.getElementById('password');

                passwordToggle.addEventListener('click', function() {
                    if (passwordInput.type === 'password') {
                        passwordInput.type = 'text';
                        passwordToggle.classList.remove('fa-eye');
                        passwordToggle.classList.add('fa-eye-slash');
                    } else {
                        passwordInput.type = 'password';
                        passwordToggle.classList.remove('fa-eye-slash');
                        passwordToggle.classList.add('fa-eye');
                    }
                });

                // Close modal functionality
                const closeButton = document.querySelector('.modal-close');
                const modalOverlay = document.querySelector('.modal-overlay');

                closeButton.addEventListener('click', function() {
                    modalOverlay.style.animation = 'fadeOut 0.3s ease-out';
                    setTimeout(function() {
                        modalOverlay.style.display = 'none';
                    }, 300);
                });
            });
        </script>
        <style>
            /* Hide default radio */
            .small-role input[type="radio"] {
                display: none;
            }

            /* Label styling */
            .small-role {
                position: relative;
                cursor: pointer;
                padding: 0.25rem 0.8rem;
                border: 1px solid #ccc;
                border-radius: 50px;
                font-size: 0.9rem;
                transition: all 0.3s ease;
                display: inline-flex;
                align-items: center;
            }

            /* Role text */
            .role-text {
                margin-left: 0.3rem;
            }

            /* Checked state */
            .small-role input[type="radio"]:checked+.role-text {
                background-color: #0d6efd;
                color: #fff;
                padding: 0.25rem 0.8rem;
                border-radius: 50px;
            }

            /* Hover effect */
            .small-role:hover {
                border-color: #0d6efd;
            }

            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
                font-family: 'Inter', sans-serif;
            }



            .modal-overlay {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.6);
                backdrop-filter: blur(5px);
                display: flex;
                justify-content: center;
                align-items: center;
                z-index: 1000;
                padding: 20px;
                  overflow: auto;
                animation: fadeIn 0.3s ease-out;
            }

            .modal-container {
                background: white;
                border-radius: 16px;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
                width: 100%;
                max-width: 440px;
                animation: slideUp 0.4s ease-out;
            }

            .modal-header {
                padding: 28px 32px 10px;
                text-align: center;
                position: relative;
            }

            .modal-close {
                position: absolute;
                top: 20px;
                right: 20px;
                background: #f1f3f5;
                width: 36px;
                height: 36px;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                cursor: pointer;
                transition: all 0.2s ease;
            }

            .modal-close:hover {
                background: #e9ecef;
                transform: rotate(90deg);
            }

            .modal-title {
                font-size: 24px;
                font-weight: 700;
                color: #212529;
                margin-bottom: 8px;
            }

            .modal-subtitle {
                color: #6c757d;
                font-size: 14px;
                font-weight: 400;
                margin-bottom: 24px;
            }

            .modal-body {
                padding: 10px 32px 32px;
            }

            .form-group {
                margin-bottom: 20px;
                position: relative;
            }

            .form-label {
                display: block;
                margin-bottom: 8px;
                font-size: 14px;
                font-weight: 500;
                color: #495057;
            }

            .input-with-icon {
                position: relative;
            }

            .input-icon {
                position: absolute;
                left: 14px;
                top: 50%;
                transform: translateY(-50%);
                color: #6c757d;
            }

            .form-control {
                width: 100%;
                padding: 14px 14px 14px 42px;
                border: 1px solid #e0e0e0;
                border-radius: 10px;
                font-size: 15px;
                transition: all 0.3s ease;
                background: #fafafa;
            }

            .form-control:focus {
                outline: none;
                border-color: #4361ee;
                box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.15);
                background: white;
            }

            .password-toggle {
                position: absolute;
                right: 14px;
                top: 50%;
                transform: translateY(-50%);
                color: #6c757d;
                cursor: pointer;
            }

            .forgot-password {
                display: block;
                text-align: right;
                margin-top: 4px;
                font-size: 13px;
                color: #4361ee;
                text-decoration: none;
            }

            .forgot-password:hover {
                text-decoration: underline;
            }

            .btn-primary {
                width: 100%;
                padding: 14px;
                background: #4361ee;
                color: white;
                border: none;
                border-radius: 10px;
                font-size: 15px;
                font-weight: 600;
                cursor: pointer;
                transition: all 0.3s ease;
                margin-top: 10px;
            }

            .btn-primary:hover {
                background: #3a56d4;
                transform: translateY(-2px);
                box-shadow: 0 4px 12px rgba(67, 97, 238, 0.25);
            }

            .divider {
                display: flex;
                align-items: center;
                margin: 24px 0;
                color: #6c757d;
                font-size: 13px;
            }

            .divider::before,
            .divider::after {
                content: "";
                flex: 1;
                height: 1px;
                background: #e9ecef;
            }

            .divider span {
                padding: 0 12px;
            }

            .social-login {
                display: flex;
                justify-content: center;
                gap: 12px;
                margin-bottom: 24px;
            }

            .social-btn {
                width: 46px;
                height: 46px;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                background: white;
                border: 1px solid #e9ecef;
                cursor: pointer;
                transition: all 0.3s ease;
            }

            .social-btn:hover {
                transform: translateY(-2px);
                box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            }

            .social-btn.google {
                color: #db4437;
            }

            .social-btn.facebook {
                color: #4267B2;
            }

            .social-btn.apple {
                color: #000;
            }

            .signup-link {
                text-align: center;
                font-size: 14px;
                color: #6c757d;
                margin-top: 24px;
            }

            .signup-link a {
                color: #4361ee;
                text-decoration: none;
                font-weight: 500;
            }

            .signup-link a:hover {
                text-decoration: underline;
            }

            @keyframes fadeIn {
                from {
                    opacity: 0;
                }

                to {
                    opacity: 1;
                }
            }

            @keyframes slideUp {
                from {
                    opacity: 0;
                    transform: translateY(20px);
                }

                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }

            @media (max-width: 576px) {
                .modal-container {
                    max-width: 100%;
                }

                .modal-header,
                .modal-body {
                    padding: 20px;
                }
            }
        </style>
    @endif
</div>
