<div>
    <div class="row mb-40 justify-content-between align-items-end">
        <div class="col-auto">
            <h2 class="fw-bold section-title">Job Categories</h2>
            <p class="section-desc">Get some Inspirations from 86K+ Jobs</p>
        </div>
        <div class="col-auto mt-30 mt-md-0">
            <div class="d-flex align-items-center gap-3">
                <!-- Sort Dropdown -->
                <div class="sort-dropdown">
                    <label for="sortSelect" class="form-label mb-0 me-2 text-muted">Sort:</label>
                    <select wire:model.live="sortBy" id="sortSelect" class="form-select form-select-sm">
                        <option value="name_asc">A to Z</option>
                        <option value="name_desc">Z to A</option>
                        <option value="created_desc">Newest First</option>
                        <option value="created_asc">Oldest First</option>
                    </select>
                </div>

                <!-- Slider Controls -->
                <div class="slider-controls">
                    <div class="slider-btn prev disabled">
                        <i class="fas fa-chevron-left"></i>
                    </div>
                    <div class="slider-btn next">
                        <i class="fas fa-chevron-right"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid my-5">
        <div class="categories-section">
            <div class="category-slider" id="categorySlider">
                @if ($categories && $categories->count() > 0)
                    @foreach ($categories as $cat)
                        <article class="category-card">
                            @if ($cat->image)
                                <div class="category-icon">
                                    <img src="{{ $cat->image_url }}" alt="{{ $cat->name }}" />
                                </div>
                            @endif
                            <div class="category-content">
                                <h3 class="category-title">
                                    <a href="" class="stretched-link">
                                        {{ $cat->name ?? 'N/A' }}
                                    </a>
                                </h3>
                                <p class="category-job-count">{{ rand(100, 2000) }} Jobs Available</p>
                            </div>
                            <div class="category-hover-effect"></div>
                        </article>
                    @endforeach
                @else
                    <div class="col-12 text-center py-5">
                        <div class="empty-state">
                            <i class="fas fa-folder-open fa-3x text-muted mb-3"></i>
                            <h4 class="text-muted">No Categories Found</h4>
                            <p class="text-muted">Job categories will appear here once added.</p>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const slider = document.getElementById('categorySlider');
            const prevBtn = document.querySelector('.slider-btn.prev');
            const nextBtn = document.querySelector('.slider-btn.next');

            // Calculate how many cards to scroll at once
            function getScrollAmount() {
                const cardWidth = document.querySelector('.category-card')?.offsetWidth || 220;
                const gap = 16; // 1rem gap
                const containerWidth = slider.parentElement.offsetWidth;

                // Calculate how many cards fit in the container
                const cardsPerView = Math.floor(containerWidth / (cardWidth + gap));

                // Scroll by the width of visible cards
                return (cardWidth + gap) * cardsPerView;
            }

            // Update navigation buttons state
            function updateNavButtons() {
                if (!slider) return;

                prevBtn.classList.toggle('disabled', slider.scrollLeft <= 0);
                nextBtn.classList.toggle('disabled',
                    slider.scrollLeft + slider.clientWidth >= slider.scrollWidth - 10);
            }

            // Scroll to the left
            prevBtn.addEventListener('click', function() {
                if (!this.classList.contains('disabled')) {
                    slider.scrollBy({
                        left: -getScrollAmount(),
                        behavior: 'smooth'
                    });
                }
            });

            // Scroll to the right
            nextBtn.addEventListener('click', function() {
                if (!this.classList.contains('disabled')) {
                    slider.scrollBy({
                        left: getScrollAmount(),
                        behavior: 'smooth'
                    });
                }
            });

            // Update button states on scroll
            if (slider) {
                slider.addEventListener('scroll', updateNavButtons);
            }

            // Initial button state
            updateNavButtons();

            // Update on window resize
            window.addEventListener('resize', updateNavButtons);
        });
    </script>

    <style>
        .categories-section {
            position: relative;
            padding: 0 0px;
        }

        .categories-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
        }

        .sort-dropdown {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .form-select-sm {
            padding: 0.375rem 2.25rem 0.375rem 0.75rem;
            font-size: 0.875rem;
            border-radius: 0.375rem;
            border: 1px solid #e9ecef;
            background-color: #fff;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .form-select-sm:focus {
            border-color: #0e636b;
            box-shadow: 0 0 0 0.2rem rgba(14, 99, 107, 0.25);
        }

        .slider-controls {
            display: flex;
            gap: 10px;
        }

        .slider-btn {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #fff;
            border: 1px solid #e9ecef;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        .slider-btn:hover {
            background: #0e636b;
            color: white;
            border-color: #0e636b;
        }

        .slider-btn.disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }

        .slider-btn.disabled:hover {
            background: #fff;
            color: inherit;
            border-color: #e9ecef;
        }

        .category-slider {
            display: flex;
            overflow-x: auto;
            scroll-behavior: smooth;
            gap: 1rem;
            padding: 1rem 0;
            scrollbar-width: none;
            /* Firefox */
        }

        .category-slider::-webkit-scrollbar {
            display: none;
            /* Chrome, Safari, Edge */
        }

        .category-card {
            background: linear-gradient(135deg, #fff 0%, #f8f9fa 100%);
            border: 1px solid #e9ecef;
            border-radius: 16px;
            padding: 1.5rem;
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            min-width: 220px;
            flex-shrink: 0;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }

        .category-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            border-color: #0e636b;
        }

        .category-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #0e636b 0%, #0e636b 100%);
            border-radius: 20px;
            padding: 1rem;
        }

        .category-icon img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            filter: brightness(0) invert(1);
        }

        .category-content {
            position: relative;
            z-index: 2;
        }

        .category-title {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
            color: #1f2937;
        }

        .category-title a {
            color: inherit;
            text-decoration: none;
        }

        .category-title a:hover {
            color: #0e636b;
        }

        .category-job-count {
            color: #6b7280;
            font-size: 0.875rem;
            margin: 0;
        }

        .category-hover-effect {
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(59, 130, 246, 0.1), transparent);
            transition: left 0.5s ease;
        }

        .category-card:hover .category-hover-effect {
            left: 100%;
        }

        .stretched-link::after {
            position: absolute;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            z-index: 1;
            content: "";
        }

        .empty-state {
            padding: 3rem 1rem;
        }

        .empty-state i {
            margin-bottom: 1rem;
        }

        @media (max-width: 768px) {
            .categories-section {
                padding: 0 20px;
            }

            .categories-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }

            .category-card {
                min-width: 200px;
            }

            .col-auto.mt-30.mt-md-0 .d-flex {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
                width: 100%;
            }

            .sort-dropdown {
                width: 100%;
                justify-content: space-between;
            }

            .form-select-sm {
                width: auto;
                min-width: 150px;
            }
        }
    </style>
</div>
