<div>
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <div class="hero-text">
                    <h1>Find Your Dream Job with Skillpots</h1>
                    <p>Discover thousands of job opportunities from top companies around the world. Start your career
                        journey today.</p>
                    <div class="search-box">
                        <input type="text" class="search-input" placeholder="Job title, keywords, or company">
                        <input type="text" class="search-input" placeholder="Location">
                        <button class="search-btn">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                    <div class="hero-stats">
                        <div class="stat-item">
                            <div class="stat-icon">
                                <i class="fas fa-briefcase"></i>
                            </div>
                            <div class="stat-content">
                                <h3>10K+</h3>
                                <p>Jobs Posted</p>
                            </div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-icon">
                                <i class="fas fa-building"></i>
                            </div>
                            <div class="stat-content">
                                <h3>2K+</h3>
                                <p>Companies</p>
                            </div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-icon">
                                <i class="fas fa-users"></i>
                            </div>
                            <div class="stat-content">
                                <h3>8M+</h3>
                                <p>Candidates</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="hero-image">
                    <img src="https://images.unsplash.com/photo-1506784983877-45594efa4cbe?ixlib=rb-1.2.1&auto=format&fit=crop&w=500&q=80"
                        alt="CareerConnect">
                </div>
            </div>
        </div>
    </section>

    <div class="container my-5">
        <div class="row">
            <!-- Main Content -->
            <div class="col-lg-8">
                <!-- Recommended Section with Filters -->
                <div class="recommended-section">
                    <div class="recommended-header">
                        <h4 class="mb-0">Recommended for you</h4>
                        <div class="recommended-filters">
                            <button class="recommended-filter-btn active">
                                <i class="fas fa-filter"></i> All
                            </button>
                            <button class="recommended-filter-btn">
                                <i class="fas fa-bolt"></i> Recent
                            </button>
                            <button class="recommended-filter-btn">
                                <i class="fas fa-map-marker-alt"></i> Local
                            </button>
                            <button class="recommended-filter-btn">
                                <i class="fas fa-dollar-sign"></i> High Salary
                            </button>
                        </div>
                    </div>

                    <!-- Mobile Filter Button (visible only on small screens) -->
                    <div class="d-block d-lg-none mb-4">
                        <button class="btn btn-outline-primary w-100" type="button" id="mobileFilterButton">
                            <i class="fas fa-filter me-2"></i> Show Filters
                        </button>
                    </div>

                    <!-- Mobile Filters Container (fixed position for mobile) -->
                    <div class="mobile-filter-container" id="mobileFilters">
                        <div class="mobile-filter-header">
                            <h5 class="fw-bold mb-0"><i class="fas fa-filter me-2"></i>Filters</h5>
                            <button class="mobile-filter-close" id="closeMobileFilters">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>

                        <div class="filter-content">
                            <!-- Job Type -->
                            <div class="filter-group">
                                <div class="filter-title">JOB TYPE</div>
                                <div class="filter-options">
                                    <div class="filter-chip active" data-value="all">All</div>
                                    <div class="filter-chip" data-value="full-time">Full Time</div>
                                    <div class="filter-chip" data-value="part-time">Part Time</div>
                                    <div class="filter-chip" data-value="contract">Contract</div>
                                    <div class="filter-chip" data-value="remote">Remote</div>
                                </div>
                                <input type="hidden" id="jobTypeFilterMobile" value="all">
                            </div>

                            <!-- Location -->
                            <div class="filter-group">
                                <div class="filter-title">LOCATION</div>
                                <div class="filter-options">
                                    <div class="filter-chip active" data-value="all">All Locations</div>
                                    <div class="filter-chip" data-value="remote">Remote</div>
                                    <div class="filter-chip" data-value="sydney">Sydney</div>
                                    <div class="filter-chip" data-value="melbourne">Melbourne</div>
                                    <div class="filter-chip" data-value="brisbane">Brisbane</div>
                                </div>
                                <input type="hidden" id="locationFilterMobile" value="all">
                            </div>

                            <!-- Salary -->
                            <div class="filter-group">
                                <div class="filter-title">SALARY RANGE</div>
                                <input type="range" class="form-range compact-range" min="30000" max="200000"
                                    step="5000" id="salaryRangeMobile">
                                <div class="salary-display" id="salaryDisplayMobile">$30,000 - $200,000+</div>
                                <input type="hidden" id="minSalaryMobile">
                                <input type="hidden" id="maxSalaryMobile">
                            </div>

                            <!-- Experience Level -->
                            <div class="filter-group">
                                <div class="filter-title">EXPERIENCE LEVEL</div>
                                <div class="filter-options">
                                    <div class="filter-chip active" data-value="all">All Levels</div>
                                    <div class="filter-chip" data-value="internship">Internship</div>
                                    <div class="filter-chip" data-value="entry">Entry Level</div>
                                    <div class="filter-chip" data-value="mid">Mid Level</div>
                                    <div class="filter-chip" data-value="senior">Senior Level</div>
                                </div>
                                <input type="hidden" id="experienceFilterMobile" value="all">
                            </div>
                        </div>

                        <div class="mobile-filter-footer">
                            <button class="btn btn-outline-secondary w-100 mb-2" id="clearMobileFilters">
                                <i class="fas fa-times me-2"></i>Clear All
                            </button>
                            <button class="btn btn-primary w-100" id="applyMobileFilters">
                                <i class="fas fa-check me-2"></i>Apply Filters
                            </button>
                        </div>
                    </div>

                    @if ($jobs)
                        @foreach ($jobs as $job)
                            <div class="card job-card mb-3" >
                                <div class="card-body" wire:click="viewJobData({{ $job->id }})">
                                    <div class="d-flex justify-content-between">
                                        <div class="d-flex align-items-center">

                                            @if ($job->userData->profile_image)
                                                <img src="{{ asset('avatars/' . $job->userData->profile_image) }}"
                                                    alt="{{ $job->businessname }}" class="company-logo-circle me-3">
                                            @else
                                                <!-- Fallback if no logo -->
                                                <div class="company-logo-circle me-3">
                                                    {{ strtoupper(substr($job->company_name, 0, 2)) }}
                                                </div>
                                            @endif
                                            <div>
                                                <h5 class="fw-bold mb-0">{{ $job->job_title ?? 'N/A' }}</h5>
                                                <p class="mb-0 text-muted">
                                                    {{ $job->businessDetails->businessname ?? 'N/A' }}</p>
                                            </div>
                                        </div>
                                        <div>
                                            <button class="btn btn-outline-primary btn-sm"><i
                                                    class="far fa-bookmark"></i></button>
                                        </div>
                                    </div>
                                    <div class="mt-3">
                                        <span class="badge bg-light text-dark me-2"><i
                                                class="fas fa-map-marker-alt me-1 text-muted"></i>
                                            {{ $job->location ?? 'N/A' }}</span>

                                        @if ($job->salary_type == 'range')
                                            <span class="badge bg-light text-dark me-2"><i
                                                    class="fas fa-dollar-sign me-1 text-muted"></i>
                                                ${{ $job->min_salary ?? 0 }} - ${{ $job->max_salary ?? 0 }}</span>
                                        @else
                                            <span class="badge bg-light text-dark me-2"><i
                                                    class="fas fa-dollar-sign me-1 text-muted"></i> Fixed Price </span>
                                        @endif
                                        @if ($job->skills)
                                            @foreach (explode("\n", $job->skills) as $skill)
                                                <!-- Split by new line -->
                                                <span class="badge skill-badge">{{ trim($skill) }}</span>
                                            @endforeach
                                        @else
                                            <span class="badge skill-badge">No skills required</span>
                                        @endif
                                        <span class="badge bg-light text-dark"><i
                                                class="fas fa-clock me-1 text-muted"></i> {{ $job->created_at->diffForHumans() }}</span>
                                    </div>
                                    <div class="mt-3">
                                        <span class="new-badge">NEW TO YOU</span>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif



                </div>

                <!-- Featured Jobs Section -->
                <section class="my-5">
                    <div class="section-title mb-5">
                        <h2>Featured Jobs</h2>
                        <p>Browse through our most recent job openings</p>
                    </div>

                    <div class="row g-4">
                        <!-- Job Cards -->
                        <div class="col-12">
                            <div class="row g-4">
                                <!-- Sample Job Cards (replaced the PHP loop with static content for this example) -->
                                <div class="col-md-6 col-lg-6">
                                    <div class="card job-card h-100" data-job-id="3">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center mb-3">
                                                <div class="company-logo-circle me-3">
                                                    TC
                                                </div>
                                                <div>
                                                    <h6 class="text-uppercase text-muted mb-1 small">TechCorp</h6>
                                                    <h5 class="fw-bold mb-0">Frontend Developer</h5>
                                                </div>
                                            </div>
                                            <ul class="list-unstyled small mb-3">
                                                <li><i class="fas fa-map-marker-alt me-2 text-muted"></i> Sydney NSW
                                                    (Hybrid)</li>
                                                <li><i class="fas fa-dollar-sign me-2 text-muted"></i> $80,000 -
                                                    $100,000</li>
                                                <li><i class="fas fa-clock me-2 text-muted"></i> Full Time</li>
                                            </ul>
                                            <div class="mb-4">
                                                <span class="badge skill-badge">React</span>
                                                <span class="badge skill-badge">JavaScript</span>
                                                <span class="badge skill-badge">CSS</span>
                                            </div>
                                            <a href="#" class="btn btn-primary w-100">Quick view</a>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-lg-6">
                                    <div class="card job-card h-100" data-job-id="4">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center mb-3">
                                                <div class="company-logo-circle me-3 bg-info">
                                                    DS
                                                </div>
                                                <div>
                                                    <h6 class="text-uppercase text-muted mb-1 small">DataSoft</h6>
                                                    <h5 class="fw-bold mb-0">Data Analyst</h5>
                                                </div>
                                            </div>
                                            <ul class="list-unstyled small mb-3">
                                                <li><i class="fas fa-map-marker-alt me-2 text-muted"></i> Melbourne VIC
                                                    (Remote)</li>
                                                <li><i class="fas fa-dollar-sign me-2 text-muted"></i> $75,000 -
                                                    $95,000</li>
                                                <li><i class="fas fa-clock me-2 text-muted"></i> Full Time</li>
                                            </ul>
                                            <div class="mb-4">
                                                <span class="badge skill-badge">SQL</span>
                                                <span class="badge skill-badge">Python</span>
                                                <span class="badge skill-badge">Tableau</span>
                                            </div>
                                            <a href="#" class="btn btn-primary w-100">Quick view</a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Pagination -->
                            <nav aria-label="Page navigation" class="mt-5">
                                <ul class="pagination justify-content-center">
                                    <li class="page-item disabled">
                                        <a class="page-link" href="#" tabindex="-1">Previous</a>
                                    </li>
                                    <li class="page-item active"><a class="page-link" href="#">1</a></li>
                                    <li class="page-item"><a class="page-link" href="#">2</a></li>
                                    <li class="page-item"><a class="page-link" href="#">3</a></li>
                                    <li class="page-item">
                                        <a class="page-link" href="#">Next</a>
                                    </li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                </section>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4 d-none d-lg-block">
                <!-- Filters Card -->
                <div class="filter-section sticky-filter">
                    <div class="filter-header">
                        <h5 class="fw-bold mb-0"><i class="fas fa-filter me-2"></i>Filters</h5>
                        <a href="#" class="text-muted small" id="clearAllFilters">Clear all</a>
                    </div>

                    <!-- Job Type -->
                    <div class="filter-group">
                        <div class="filter-title">JOB TYPE</div>
                        <div class="filter-options">
                            <div class="filter-chip active" data-value="all">All</div>
                            <div class="filter-chip" data-value="full-time">Full Time</div>
                            <div class="filter-chip" data-value="part-time">Part Time</div>
                            <div class="filter-chip" data-value="contract">Contract</div>
                            <div class="filter-chip" data-value="remote">Remote</div>
                        </div>
                        <input type="hidden" id="jobTypeFilter" value="all">
                    </div>

                    <!-- Location -->
                    <div class="filter-group">
                        <div class="filter-title">LOCATION</div>
                        <div class="filter-options">
                            <div class="filter-chip active" data-value="all">All Locations</div>
                            <div class="filter-chip" data-value="remote">Remote</div>
                            <div class="filter-chip" data-value="sydney">Sydney</div>
                            <div class="filter-chip" data-value="melbourne">Melbourne</div>
                            <div class="filter-chip" data-value="brisbane">Brisbane</div>
                        </div>
                        <input type="hidden" id="locationFilter" value="all">
                    </div>

                    <!-- Salary -->
                    <div class="filter-group">
                        <div class="filter-title">SALARY RANGE</div>
                        <input type="range" class="form-range compact-range" min="30000" max="200000"
                            step="5000" id="salaryRange">
                        <div class="salary-display" id="salaryDisplay">$30,000 - $200,000+</div>
                        <input type="hidden" id="minSalary">
                        <input type="hidden" id="maxSalary">
                    </div>

                    <!-- Experience Level -->
                    <div class="filter-group">
                        <div class="filter-title">EXPERIENCE LEVEL</div>
                        <div class="filter-options">
                            <div class="filter-chip active" data-value="all">All Levels</div>
                            <div class="filter-chip" data-value="internship">Internship</div>
                            <div class="filter-chip" data-value="entry">Entry Level</div>
                            <div class="filter-chip" data-value="mid">Mid Level</div>
                            <div class="filter-chip" data-value="senior">Senior Level</div>
                        </div>
                        <input type="hidden" id="experienceFilter" value="all">
                    </div>

                    <!-- Skills -->
                    <div class="filter-group">
                        <div class="filter-title">SKILLS</div>
                        <div class="filter-options">
                            <div class="filter-chip" data-value="react">React</div>
                            <div class="filter-chip" data-value="javascript">JavaScript</div>
                            <div class="filter-chip" data-value="python">Python</div>
                            <div class="filter-chip" data-value="laravel">Laravel</div>
                            <div class="filter-chip" data-value="vue">Vue.js</div>
                            <div class="filter-chip" data-value="angular">Angular</div>
                            <div class="filter-chip" data-value="node">Node.js</div>
                            <div class="filter-chip" data-value="php">PHP</div>
                        </div>
                        <input type="hidden" id="skillsFilter" value="">
                    </div>

                    <!-- Company -->
                    <div class="filter-group">
                        <div class="filter-title">COMPANY</div>
                        <input type="text" class="form-control form-control-sm" placeholder="Search companies">
                    </div>

                    <!-- Date Posted -->
                    <div class="filter-group">
                        <div class="filter-title">DATE POSTED</div>
                        <div class="filter-options">
                            <div class="filter-chip active" data-value="all">Any Time</div>
                            <div class="filter-chip" data-value="24">Past 24 Hours</div>
                            <div class="filter-chip" data-value="7">Past Week</div>
                            <div class="filter-chip" data-value="30">Past Month</div>
                        </div>
                        <input type="hidden" id="datePostedFilter" value="all">
                    </div>

                    <!-- Apply Filters Button -->
                    <button class="btn btn-primary w-100 mt-3" id="applyFilters">
                        <i class="fas fa-check me-2"></i>Apply Filters
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Job Details View -->
   <livewire:web.index.findjob.details.quickjobdetails/>


    <!-- Bootstrap & Popper.js -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Salary range display update for desktop
            const salaryRange = document.getElementById('salaryRange');
            const salaryDisplay = document.getElementById('salaryDisplay');

            if (salaryRange && salaryDisplay) {
                salaryRange.addEventListener('input', function() {
                    const value = this.value;
                    salaryDisplay.textContent = `$${Number(value).toLocaleString()} - $200,000+`;
                });
            }

            // Salary range display update for mobile
            const salaryRangeMobile = document.getElementById('salaryRangeMobile');
            const salaryDisplayMobile = document.getElementById('salaryDisplayMobile');

            if (salaryRangeMobile && salaryDisplayMobile) {
                salaryRangeMobile.addEventListener('input', function() {
                    const value = this.value;
                    salaryDisplayMobile.textContent = `$${Number(value).toLocaleString()} - $200,000+`;
                });
            }

            // Filter chip functionality for desktop
            const filterChips = document.querySelectorAll('.filter-chip');
            filterChips.forEach(chip => {
                chip.addEventListener('click', function() {
                    const parent = this.closest('.filter-group');
                    const chips = parent.querySelectorAll('.filter-chip');
                    chips.forEach(c => c.classList.remove('active'));
                    this.classList.add('active');

                    // Update the corresponding hidden input
                    const inputId = parent.querySelector('input[type="hidden"]').id;
                    document.getElementById(inputId).value = this.dataset.value;
                });
            });

            // Mobile filter functionality
            const mobileFilterButton = document.getElementById('mobileFilterButton');
            const mobileFilters = document.getElementById('mobileFilters');
            const closeMobileFilters = document.getElementById('closeMobileFilters');
            const applyMobileFilters = document.getElementById('applyMobileFilters');
            const clearMobileFilters = document.getElementById('clearMobileFilters');

            if (mobileFilterButton && mobileFilters) {
                mobileFilterButton.addEventListener('click', function() {
                    mobileFilters.style.display = 'block';
                    document.body.style.overflow = 'hidden'; // Prevent scrolling
                });

                closeMobileFilters.addEventListener('click', function() {
                    mobileFilters.style.display = 'none';
                    document.body.style.overflow = ''; // Enable scrolling
                });

                applyMobileFilters.addEventListener('click', function() {
                    mobileFilters.style.display = 'none';
                    document.body.style.overflow = ''; // Enable scrolling
                    alert('Filters applied!'); // Replace with actual filter logic
                });

                clearMobileFilters.addEventListener('click', function() {
                    // Reset all mobile filter chips to default
                    const mobileChips = mobileFilters.querySelectorAll('.filter-chip');
                    mobileChips.forEach(chip => {
                        chip.classList.remove('active');
                        if (chip.dataset.value === 'all') {
                            chip.classList.add('active');
                        }
                    });

                    // Reset salary range
                    if (salaryRangeMobile) {
                        salaryRangeMobile.value = 30000;
                        salaryDisplayMobile.textContent = '$30,000 - $200,000+';
                    }
                });
            }

            // Clear all filters functionality
            const clearAllFilters = document.getElementById('clearAllFilters');
            if (clearAllFilters) {
                clearAllFilters.addEventListener('click', function(e) {
                    e.preventDefault();

                    // Reset all filter chips to default
                    const allChips = document.querySelectorAll('.filter-chip');
                    allChips.forEach(chip => {
                        chip.classList.remove('active');
                        if (chip.dataset.value === 'all') {
                            chip.classList.add('active');
                        }
                    });

                    // Reset salary range
                    if (salaryRange) {
                        salaryRange.value = 30000;
                        salaryDisplay.textContent = '$30,000 - $200,000+';
                    }

                    // Reset company search
                    const companySearch = document.querySelector('input[placeholder="Search companies"]');
                    if (companySearch) {
                        companySearch.value = '';
                    }
                });
            }

            // Apply filters functionality
            const applyFilters = document.getElementById('applyFilters');
            if (applyFilters) {
                applyFilters.addEventListener('click', function() {
                    alert('Filters applied!'); // Replace with actual filter logic
                });
            }

            // Job details functionality

        });
    </script>
    <style>
        :root {
            --primary-color: #2557a7;
            --secondary-color: #f8f9fa;
            --accent-color: #ff6b35;
            --text-dark: #333;
            --text-light: #6c757d;
            --border-color: #dee2e6;
            --card-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            --filter-bg: #ffffff;
        }



        body {
            background-color: #f9fafb;
            font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: var(--text-dark);
        }

        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }

        /* Hero Section */
        .hero {
            background: linear-gradient(135deg, rgba(37, 87, 167, 0.9) 0%, rgba(58, 12, 163, 0.85) 100%);
            color: white;
            padding: 3rem 0;
        }

        .hero-content {
            display: flex;
            align-items: center;
            min-height: 500px;
        }

        .hero-text h1 {
            font-size: 2.8rem;
            font-weight: 700;
            margin-bottom: 1.5rem;
        }

        .hero-text p {
            font-size: 1.2rem;
            margin-bottom: 2rem;
            opacity: 0.9;
        }

        .search-box {
            display: flex;
            background: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            margin-bottom: 2rem;
        }

        .search-input {
            flex: 1;
            border: none;
            padding: 15px 20px;
            font-size: 1rem;
        }

        .search-input:focus {
            outline: none;
        }

        .search-btn {
            background: var(--accent-color);
            color: white;
            border: none;
            padding: 0 25px;
            cursor: pointer;
        }

        .hero-stats {
            display: flex;
            gap: 2rem;
        }

        .stat-item {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .stat-icon {
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .stat-content h3 {
            margin: 0;
            font-size: 1.5rem;
            font-weight: 700;
        }

        .stat-content p {
            margin: 0;
            opacity: 0.8;
            font-size: 0.9rem;
        }

        .hero-image img {
            width: 100%;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }

        /* Job Cards */
        .job-card {
            border: none;
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            transition: all 0.3s ease;
            overflow: hidden;
            background: white;
            height: 100%;
            cursor: pointer;
        }

        .job-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 28px rgba(0, 0, 0, 0.1);
        }

        .company-logo-circle {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            background: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            color: white;
            font-size: 14px;
        }

        .bg-info {
            background: linear-gradient(135deg, #4cc9f0 0%, #4895ef 100%) !important;
        }

        .skill-badge {
            background-color: #f0f5ff;
            color: var(--primary-color);
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            margin-bottom: 5px;
            display: inline-block;
            border: 1px solid #e6eeff;
        }

        .new-badge {
            background-color: var(--accent-color);
            color: white;
            font-size: 0.7rem;
            padding: 4px 10px;
            border-radius: 10px;
            font-weight: 600;
        }

        /* Job Details View */
        .job-details-container {

            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: white;
            z-index: 1100;
            overflow-y: auto;
            padding: 20px;
        }

        .job-details-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid var(--border-color);
        }

        .job-details-close {
            background: none;
            border: none;
            font-size: 1.5rem;
            color: var(--text-light);
        }

        .job-title-section {
            margin-bottom: 20px;
        }

        .job-meta-info {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            margin-bottom: 20px;
        }

        .job-meta-item {
            display: flex;
            align-items: center;
            gap: 8px;
            color: var(--text-light);
        }

        .application-info {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 0.9rem;
        }

        .action-buttons {
            display: flex;
            gap: 10px;
            margin-bottom: 25px;
        }

        .match-section {
            background-color: #e8f4ff;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 25px;
        }

        .match-title {
            font-weight: 600;
            margin-bottom: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .skills-match {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
        }

        .skill-match-item {
            background-color: white;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 0.85rem;
            border: 1px solid #cce5ff;
        }

        .job-description {
            margin-bottom: 30px;
            line-height: 1.6;
        }

        /* Filters */
        .filter-section {
            background: var(--filter-bg);
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: var(--card-shadow);
        }

        .filter-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid var(--border-color);
        }

        .filter-group {
            margin-bottom: 20px;
        }

        .filter-title {
            font-weight: 600;
            margin-bottom: 12px;
            color: var(--text-dark);
            font-size: 0.95rem;
        }

        .filter-options {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
        }

        .filter-chip {
            background-color: var(--secondary-color);
            border: 1px solid var(--border-color);
            border-radius: 20px;
            padding: 6px 14px;
            font-size: 0.85rem;
            cursor: pointer;
            transition: all 0.2s;
        }

        .filter-chip:hover,
        .filter-chip.active {
            background-color: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }

        .salary-display {
            font-size: 0.9rem;
            text-align: center;
            margin-top: 8px;
            color: var(--primary-color);
            font-weight: 500;
        }

        .compact-range {
            height: 6px;
            border-radius: 3px;
        }

        .compact-range::-webkit-slider-thumb {
            background: var(--primary-color);
        }

        .section-title h2 {
            color: var(--text-dark);
            font-weight: 700;
            position: relative;
            padding-bottom: 15px;
            margin-bottom: 25px;
        }

        .section-title h2:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 50px;
            height: 4px;
            background: linear-gradient(to right, var(--primary-color), var(--accent-color));
            border-radius: 2px;
        }

        .recommended-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            flex-wrap: wrap;
            gap: 15px;
        }

        .recommended-filters {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }

        .recommended-filter-btn {
            background: white;
            border: 1px solid var(--border-color);
            border-radius: 20px;
            padding: 6px 16px;
            font-size: 0.9rem;
            color: var(--text-light);
            transition: all 0.2s;
            display: flex;
            align-items: center;
        }

        .recommended-filter-btn:hover,
        .recommended-filter-btn.active {
            background: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }

        .recommended-filter-btn i {
            margin-right: 5px;
            font-size: 0.8rem;
        }

        .sticky-filter {
            position: sticky;
            top: 90px;
            z-index: 99;
        }

        .pagination .page-link {
            color: var(--primary-color);
            border-radius: 8px;
            margin: 0 5px;
            border: 1px solid var(--border-color);
        }

        .pagination .page-item.active .page-link {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            color: white;
        }

        /* Mobile Responsiveness */
        @media (max-width: 992px) {
            .hero-content {
                flex-direction: column;
                text-align: center;
            }

            .hero-text h1 {
                font-size: 2.2rem;
            }

            .hero-stats {
                justify-content: center;
                flex-wrap: wrap;
            }

            .search-box {
                flex-direction: column;
                background: transparent;
                box-shadow: none;
            }

            .search-input {
                margin-bottom: 10px;
                border-radius: 8px;
                padding: 12px 15px;
            }

            .search-btn {
                border-radius: 8px;
                padding: 12px;
            }

            .recommended-header {
                flex-direction: column;
                align-items: flex-start;
            }

            .sticky-filter {
                position: static;
                margin-bottom: 20px;
            }

            .filter-options {
                gap: 6px;
            }

            .filter-chip {
                padding: 5px 12px;
                font-size: 0.8rem;
            }

            .action-buttons {
                flex-direction: column;
            }

            .job-details-header {
                flex-direction: column;
                gap: 15px;
            }
        }

        @media (max-width: 768px) {
            .hero-text h1 {
                font-size: 1.8rem;
            }

            .hero-text p {
                font-size: 1rem;
            }

            .stat-item {
                flex: 0 0 50%;
                justify-content: center;
                margin-bottom: 15px;
            }

            .hero-stats {
                gap: 1rem;
            }

            .recommended-filters {
                width: 100%;
                overflow-x: auto;
                padding-bottom: 10px;
            }

            .recommended-filter-btn {
                white-space: nowrap;
            }

            .company-logo-circle {
                width: 40px;
                height: 40px;
                font-size: 12px;
            }

            .job-meta-info {
                flex-direction: column;
                gap: 10px;
            }
        }

        @media (max-width: 576px) {
            .hero {
                padding: 2rem 0;
            }

            .hero-content {
                min-height: auto;
            }

            .stat-item {
                flex: 0 0 100%;
            }

            .filter-group {
                margin-bottom: 15px;
            }

            .card-body {
                padding: 15px;
            }
        }

        /* Mobile filter improvements */
        .mobile-filter-container {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: white;
            z-index: 1050;
            overflow-y: auto;
            padding: 20px;
            display: none;
        }

        .mobile-filter-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid var(--border-color);
        }

        .mobile-filter-close {
            background: none;
            border: none;
            font-size: 1.5rem;
            color: var(--text-light);
        }

        .mobile-filter-footer {
            position: sticky;
            bottom: 0;
            background: white;
            padding: 15px 0;
            border-top: 1px solid var(--border-color);
        }
    </style>
</div>
