<div>
    @if ($viewjobdata)
        <div class="job-details-container" id="jobDetailsContainer">
            <div class="container">
                <div class="job-details-header">
                    <div>
                        <h2 id="jobDetailsTitle">{{ $jobDetails->job_title }}</h2>
                        <p class="text-muted mb-0" id="jobDetailsCompany">{{ $jobDetails->businessDetails->businessname }}
                        </p>
                    </div>
                    <button class="job-details-close" id="closeJobDetails" wire:click="closePreview">
                        <i class="fas fa-times"></i>
                    </button>
                </div>

                <div class="job-title-section">
                    @if ($jobDetails->userData->profile_image)
                        <img src="{{ asset('avatars/' . $jobDetails->userData->profile_image) }}"
                            alt="{{ $jobDetails->businessDetails->businessname }}" class="company-logo-circle me-3">
                    @else
                        <!-- Fallback if no logo -->
                        <div class="company-logo-circle me-3">
                            {{ strtoupper(substr($job->company_name, 0, 2)) }}
                        </div>
                    @endif
                    <div class="d-flex align-items-center mb-2">
                        <a href="#" class="text-muted me-3"><i class="fas fa-building me-1"></i> View all jobs</a>
                        <a href="#" class="text-muted"><i class="fas fa-share-alt me-1"></i> Share</a>
                    </div>
                </div>

                <div class="job-meta-info">
                    <div class="job-meta-item">
                        <i class="fas fa-map-marker-alt"></i>
                        <span id="jobDetailsLocation">{{ $jobDetails->location }}</span>
                    </div>
                    <div class="job-meta-item">
                        <i class="fas fa-briefcase"></i>
                        <span id="jobDetailsCategory">{{ $jobDetails->category }}</span>
                    </div>
                    <div class="job-meta-item">
                        <i class="fas fa-clock"></i>
                        @if ($jobDetails->job_type == 'full-time')
                            <span id="jobDetailsType">Full time</span>
                        @elseif ($jobDetails->job_type == 'part-time')
                             <span id="jobDetailsType">Part time</span>
                        @elseif ($jobDetails->job_type == 'contract')
                             <span id="jobDetailsType">Contract</span>
                        @elseif ($jobDetails->job_type == 'temporary')
                             <span id="jobDetailsType">Contract</span>
                        @else
                             <span id="jobDetailsType">Internship</span>
                        @endif
                    </div>
                    <div class="job-meta-item">
                        <i class="fas fa-dollar-sign"></i>
                          @if ($jobDetails->salary_type == 'range')
                         <span id="jobDetailsSalary"> ${{ $jobDetails->min_salary ?? 0 }} - ${{ $jobDetails->max_salary ?? 0 }}</span>
                         @elseif ($jobDetails->salary_type == 'fixed')
                         <span id="jobDetailsSalary">Fixed Price</span>
                         @else
                         <span id="jobDetailsSalary">Negotiable</span>
                         @endif

                    </div>
                </div>

                <div class="application-info">
            <p class="mb-0">
    <i class="fas fa-clock me-1"></i>
    Posted <span id="jobDetailsPosted">{{ $jobDetails->created_at->diffForHumans() }}</span>
</p>

                        • <span id="jobDetailsApplicationVolume">Medium application volume</span></p>
                </div>

                <div class="action-buttons">
                    <button class="btn btn-primary btn-lg flex-grow-1">
                        <i class="fas fa-bolt me-2"></i>Quick apply
                    </button>
                    <button class="btn btn-outline-primary btn-lg">
                        <i class="far fa-bookmark me-2"></i>Save
                    </button>
                </div>

                <div class="match-section">
                    <div class="match-title">
                        <span>How you match</span>
                        <a href="#" class="text-primary small">Edit your profile</a>
                    </div>
                    <p class="small mb-3">Skills and credentials from the job description</p>
                    <div class="skills-match" id="jobDetailsSkills">
                        <span class="skill-match-item">Compliance Management</span>
                        <span class="skill-match-item">Microsoft Windows</span>
                        <span class="skill-match-item">Customer Service</span>
                        <span class="skill-match-item">Drivers Licence</span>
                        <span class="skill-match-item">+1 more</span>
                    </div>
                </div>

                <div class="job-description">
                    <h5 class="mb-3">Job Description</h5>
                    <p id="jobDetailsDescription">
                        We are seeking a skilled Smoke Alarm and General Compliance Technician to join our team.
                        In this role, you will be responsible for installing, testing, and maintaining smoke alarms
                        and other safety equipment in residential and commercial properties. You will also ensure
                        compliance with all relevant regulations and standards.
                    </p>
                    <h6 class="mt-4 mb-3">Responsibilities:</h6>
                    <ul>
                        <li>Install and test smoke alarms and safety equipment</li>
                        <li>Conduct routine maintenance and inspections</li>
                        <li>Ensure compliance with safety regulations</li>
                        <li>Provide excellent customer service</li>
                        <li>Maintain accurate records of work performed</li>
                    </ul>
                    <h6 class="mt-4 mb-3">Requirements:</h6>
                    <ul>
                        <li>Previous experience in a similar role preferred</li>
                        <li>Knowledge of safety regulations and standards</li>
                        <li>Strong attention to detail</li>
                        <li>Excellent communication skills</li>
                        <li>Valid driver's license</li>
                    </ul>
                </div>

                <div class="action-buttons sticky-bottom bg-white pt-3 pb-4 border-top">
                    <a href="{{ route('skillpot.apply.job', 'test-job') }}" class="btn btn-primary btn-lg flex-grow-1">
                        <i class="fas fa-bolt me-2"></i>Quick apply
                    </a>

                    <button class="btn btn-outline-primary btn-lg">
                        <i class="far fa-bookmark me-2"></i>Save
                    </button>
                </div>
            </div>
        </div>
        <style>
            .action-buttons .btn:hover,
            .action-buttons .btn:focus {
                background-color: inherit !important;
                color: inherit !important;
                border-color: inherit !important;
                box-shadow: none !important;

            }

            #jobDetailsCategory::first-letter {
                text-transform: uppercase;
            }

            #jobDetailsLocation::first-letter {
                text-transform: uppercase;
            }
        </style>
    @endif

</div>
