<div>
   <div class="application-container" id="applicationContainer">
        <div class="application-header">
            <div class="company-logo-container">
                <img src="https://logo.clearbit.com/airmaster.com.au" alt="Airmaster Australia" class="company-logo" onerror="this.src='https://via.placeholder.com/50/2557a7/ffffff?text=AA'">
            </div>
            <div class="job-info">
                <h1 class="job-title">Fire Alarm Technician</h1>
                <div class="company-name">Airmaster Australia</div>
                <a href="#" class="view-job-link">
                    View job description <i class="fas fa-arrow-right"></i>
                </a>
            </div>
            {{-- <button class="application-close" id="closeApplication">
                <i class="fas fa-times"></i>
            </button> --}}
        </div>

        <div class="application-progress">
            <div class="progress-steps">
                <div class="progress-step">
                    <div class="step-number active">1</div>
                    <div class="step-label active">Choose documents</div>
                </div>
                <div class="progress-step">
                    <div class="step-number">2</div>
                    <div class="step-label">Answer questions</div>
                </div>
                <div class="progress-step">
                    <div class="step-number">3</div>
                    <div class="step-label">Update profile</div>
                </div>
                <div class="progress-step">
                    <div class="step-number">4</div>
                    <div class="step-label">Review & submit</div>
                </div>
                <div class="progress-bar-container">
                    <div class="progress-bar" style="width: 25%;"></div>
                </div>
            </div>
        </div>

        <div class="application-content">
            <div class="application-section">
                <div class="section-header">
                    <div class="section-title">
                        <i class="fas fa-user-circle"></i> Your contact information
                    </div>
                    <a href="#" class="edit-link">
                        Edit <i class="fas fa-pencil-alt"></i>
                    </a>
                </div>

                <div class="contact-info">
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="contact-details">
                            <div class="contact-label">Full Name</div>
                            <div class="contact-value">dgdfgd_dmm</div>
                        </div>
                    </div>
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="contact-details">
                            <div class="contact-label">Location</div>
                            <div class="contact-value">Sydney, Sydney NSW</div>
                        </div>
                    </div>
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <div class="contact-details">
                            <div class="contact-label">Phone Number</div>
                            <div class="contact-value">+03 712333453</div>
                        </div>
                    </div>
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="contact-details">
                            <div class="contact-label">Email Address</div>
                            <div class="contact-value">mudwandala@sd5@gmail.com</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="application-section">
                <div class="section-header">
                    <div class="section-title">
                        <i class="fas fa-file-alt"></i> Resumé
                    </div>
                </div>

                <div class="document-options">
                    <div class="option-card selected">
                        <div class="option-icon">
                            <i class="fas fa-upload"></i>
                        </div>
                        <div class="option-content">
                            <div class="option-title">Upload a resume</div>
                            <div class="option-description">Upload a new resume file from your device</div>
                        </div>
                    </div>

                    <div class="option-card">
                        <div class="option-icon">
                            <i class="fas fa-file"></i>
                        </div>
                        <div class="option-content">
                            <div class="option-title">Select a resume</div>
                            <div class="option-description">Choose from your previously uploaded resumes</div>
                        </div>
                    </div>

                    <div class="option-card">
                        <div class="option-icon">
                            <i class="fas fa-times"></i>
                        </div>
                        <div class="option-content">
                            <div class="option-title">Don't include a resume</div>
                            <div class="option-description">Apply without attaching a resume</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="application-section">
                <div class="section-header">
                    <div class="section-title">
                        <i class="fas fa-envelope-open-text"></i> Cover letter
                    </div>
                </div>

                <div class="document-options">
                    <div class="option-card">
                        <div class="option-icon">
                            <i class="fas fa-upload"></i>
                        </div>
                        <div class="option-content">
                            <div class="option-title">Upload a cover letter</div>
                            <div class="option-description">Upload a cover letter file from your device</div>
                        </div>
                    </div>

                    <div class="option-card">
                        <div class="option-icon">
                            <i class="fas fa-pen"></i>
                        </div>
                        <div class="option-content">
                            <div class="option-title">Write a cover letter</div>
                            <div class="option-description">Compose a custom cover letter for this application</div>
                        </div>
                    </div>

                    <div class="option-card selected">
                        <div class="option-icon">
                            <i class="fas fa-times"></i>
                        </div>
                        <div class="option-content">
                            <div class="option-title">Don't include a cover letter</div>
                            <div class="option-description">Apply without a cover letter</div>
                        </div>
                    </div>
                </div>

                <div class="privacy-notice">
                    <i class="fas fa-shield-alt"></i>Stay safe. Don't include sensitive information in your documents.
                    <a href="#" class="text-primary">More about privacy and data use</a>
                </div>
            </div>
        </div>

        <div class="application-footer">
            <button class="btn btn-primary continue-btn">
                Continue <i class="fas fa-arrow-right"></i>
            </button>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const applicationContainer = document.getElementById('applicationContainer');
            const closeApplication = document.getElementById('closeApplication');

            // Close application form
            if (closeApplication && applicationContainer) {
                closeApplication.addEventListener('click', function() {
                    applicationContainer.style.display = 'none';
                    document.body.style.overflow = ''; // Enable scrolling
                });
            }

            // Document option selection
            const optionCards = document.querySelectorAll('.option-card');
            optionCards.forEach(card => {
                card.addEventListener('click', function() {
                    const parentSection = this.closest('.application-section');
                    const options = parentSection.querySelectorAll('.option-card');

                    options.forEach(option => {
                        option.classList.remove('selected');
                    });

                    this.classList.add('selected');
                });
            });
        });
    </script>
    <style>
        :root {
            --primary-color: #2557a7;
            --primary-light: #e8f1ff;
            --secondary-color: #f8f9fa;
            --accent-color: #ff6b35;
            --text-dark: #2d3748;
            --text-light: #718096;
            --border-color: #e2e8f0;
            --card-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            --filter-bg: #ffffff;
            --success-color: #48bb78;
        }

        body {
            background-color: #f9fafb;
            font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: var(--text-dark);
            line-height: 1.6;
            padding: 0;
            margin: 0;
        }

        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            font-weight: 600;
            padding: 12px 24px;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            background-color: #1a4a8c;
            border-color: #1a4a8c;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(37, 87, 167, 0.3);
        }

        /* Application Form */
        .application-container {
            position: relative;

            background: white;

            border-radius: 16px;
            overflow: hidden;
            box-shadow: var(--card-shadow);
            margin: 0 auto;
            max-width: 100%;
            margin-top: 10%;
        }

        .application-header {
            display: flex;
            align-items: flex-start;
            padding: 20px;
            border-bottom: 1px solid var(--border-color);
            background: linear-gradient(to right, var(--primary-light), white);
        }

        .company-logo-container {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            background: white;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            margin-right: 15px;
            flex-shrink: 0;
            border: 1px solid var(--border-color);
        }

        .company-logo {
            width: 40px;
            height: 40px;
            object-fit: contain;
        }

        .job-info {
            flex: 1;
        }

        .job-title {
            font-size: 1.3rem;
            font-weight: 700;
            color: var(--text-dark);
            margin-bottom: 5px;
            line-height: 1.3;
        }

        .company-name {
            font-size: 1rem;
            color: var(--primary-color);
            font-weight: 600;
            margin-bottom: 8px;
        }

        .view-job-link {
            color: var(--primary-color);
            font-weight: 500;
            text-decoration: none;
            font-size: 0.9rem;
            display: inline-flex;
            align-items: center;
        }

        .view-job-link i {
            margin-left: 5px;
            transition: transform 0.3s ease;
        }

        .view-job-link:hover {
            text-decoration: underline;
        }

        .view-job-link:hover i {
            transform: translateX(3px);
        }

        .application-close {
            background: none;
            border: none;
            font-size: 1.5rem;
            color: var(--text-light);
            cursor: pointer;
            padding: 5px;
            border-radius: 50%;
            transition: all 0.3s ease;
            flex-shrink: 0;
            margin-left: 10px;
        }

        .application-close:hover {
            color: var(--text-dark);
            background-color: #f1f5f9;
        }

        .application-progress {
            padding: 20px 20px 15px;
            background-color: white;
        }

        .progress-steps {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            position: relative;
        }

        .progress-step {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative;
            z-index: 2;
            flex: 1;
        }

        .step-number {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background-color: #e9ecef;
            color: var(--text-light);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            margin-bottom: 8px;
            transition: all 0.3s ease;
            border: 2px solid #e9ecef;
            font-size: 0.9rem;
        }

        .step-number.active {
            background-color: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 4px var(--primary-light);
        }

        .step-label {
            font-size: 0.75rem;
            color: var(--text-light);
            text-align: center;
            font-weight: 500;
            transition: all 0.3s ease;
            line-height: 1.3;
        }

        .step-label.active {
            color: var(--primary-color);
            font-weight: 600;
        }

        .progress-bar-container {
            position: absolute;
            top: 16px;
            left: 0;
            right: 0;
            height: 3px;
            background-color: #e9ecef;
            z-index: 1;
        }

        .progress-bar {
            height: 100%;
            background-color: var(--primary-color);
            width: 25%;
            transition: width 0.3s ease;
            border-radius: 3px;
        }

        .application-content {
            padding: 0 20px 20px;
        }

        .application-section {
            margin-bottom: 20px;
            padding: 20px;
            border-radius: 12px;
            background-color: white;
            box-shadow: var(--card-shadow);
            border: 1px solid var(--border-color);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .application-section:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
        }

        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .section-title {
            font-weight: 600;
            font-size: 1rem;
            color: var(--text-dark);
            display: flex;
            align-items: center;
        }

        .section-title i {
            margin-right: 8px;
            color: var(--primary-color);
            font-size: 1.1rem;
        }

        .edit-link {
            color: var(--primary-color);
            font-weight: 500;
            text-decoration: none;
            font-size: 0.85rem;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
        }

        .edit-link i {
            margin-left: 5px;
            font-size: 0.8rem;
        }

        .edit-link:hover {
            text-decoration: underline;
        }

        .contact-info {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        .contact-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
            border-radius: 8px;
            background-color: #f8fafc;
            transition: all 0.3s ease;
        }

        .contact-item:hover {
            background-color: #f1f5f9;
        }

        .contact-icon {
            width: 20px;
            text-align: center;
            color: var(--primary-color);
            font-size: 1rem;
            flex-shrink: 0;
        }

        .contact-details {
            flex: 1;
            overflow: hidden;
        }

        .contact-label {
            font-size: 0.8rem;
            color: var(--text-light);
            margin-bottom: 3px;
        }

        .contact-value {
            font-weight: 500;
            color: var(--text-dark);
            font-size: 0.9rem;
            word-break: break-word;
        }

        .document-options {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .option-card {
            padding: 16px;
            border: 2px solid var(--border-color);
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: flex-start;
        }

        .option-card:hover {
            border-color: var(--primary-color);
            background-color: #f8fafc;
        }

        .option-card.selected {
            border-color: var(--primary-color);
            background-color: var(--primary-light);
            box-shadow: 0 5px 15px rgba(37, 87, 167, 0.1);
        }

        .option-icon {
            width: 20px;
            text-align: center;
            color: var(--primary-color);
            font-size: 1.1rem;
            margin-right: 12px;
            flex-shrink: 0;
            margin-top: 2px;
        }

        .option-content {
            flex: 1;
        }

        .option-title {
            font-weight: 600;
            margin-bottom: 4px;
            color: var(--text-dark);
            font-size: 0.95rem;
        }

        .option-description {
            font-size: 0.85rem;
            color: var(--text-light);
            line-height: 1.4;
        }

        .privacy-notice {
            background-color: #f8fafc;
            padding: 16px;
            border-radius: 8px;
            font-size: 0.8rem;
            color: var(--text-light);
            margin-top: 20px;
            border-left: 4px solid var(--primary-color);
            line-height: 1.5;
        }

        .privacy-notice i {
            color: var(--primary-color);
            margin-right: 8px;
        }

        .application-footer {
            padding: 20px;
            background-color: white;
            border-top: 1px solid var(--border-color);
            display: flex;
            justify-content: flex-end;
        }

        .continue-btn {
            padding: 12px 24px;
            font-weight: 600;
            border-radius: 8px;
            display: inline-flex;
            align-items: center;
            box-shadow: 0 4px 12px rgba(37, 87, 167, 0.25);
            font-size: 0.95rem;
        }

        .continue-btn i {
            margin-left: 8px;
            transition: transform 0.3s ease;
            font-size: 0.9rem;
        }

        .continue-btn:hover i {
            transform: translateX(5px);
        }

        /* Mobile Responsiveness */
        @media (max-width: 576px) {
            .application-container {
                border-radius: 0;
                margin: 0;
                min-height: 100vh;
            }

            .application-header {
                flex-direction: column;
                padding: 15px;
                text-align: center;
            }

            .company-logo-container {
                margin: 0 auto 10px;
                width: 70px;
                height: 70px;
            }

            .company-logo {
                width: 45px;
                height: 45px;
            }

            .job-info {
                width: 100%;
            }

            .job-title {
                font-size: 1.4rem;
            }

            .application-close {
                position: absolute;
                top: 10px;
                right: 10px;
                margin-left: 0;
            }

            .application-progress {
                padding: 15px 15px 10px;
            }

            .progress-step {
                min-width: 60px;
            }

            .step-number {
                width: 28px;
                height: 28px;
                font-size: 0.8rem;
            }

            .step-label {
                font-size: 0.7rem;
            }

            .progress-bar-container {
                top: 14px;
            }

            .application-content {
                padding: 0 15px 15px;
            }

            .application-section {
                padding: 16px;
                margin-bottom: 16px;
            }

            .section-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 8px;
            }

            .edit-link {
                align-self: flex-end;
            }

            .contact-item {
                padding: 10px;
            }

            .option-card {
                padding: 14px;
            }

            .application-footer {
                padding: 15px;
                position: sticky;
                bottom: 0;
                z-index: 10;
            }

            .continue-btn {
                width: 100%;
                justify-content: center;
            }
        }

        @media (max-width: 400px) {
            .progress-steps {
                flex-wrap: wrap;
                gap: 10px;
            }

            .progress-step {
                flex: 0 0 calc(50% - 5px);
            }

            .progress-bar-container {
                display: none;
            }

            .contact-item {
                flex-direction: column;
                align-items: flex-start;
                gap: 8px;
            }

            .contact-icon {
                align-self: flex-start;
            }
        }
    </style>
</div>
