<div>
    <div>
        <main class="container" style="padding-top:10%;padding-left:6%;padding-right:6%;">
            <div class="progress-container">
                <div class="progress-steps">
                    <div class="step completed">
                        <div class="step-number">
                            <i class="fas fa-check"></i>
                        </div>
                        <span>Account</span>
                    </div>
                    <div
                        class="step {{ in_array($currentTab, ['job-details', 'salary-benefits', 'company-info', 'requirements', 'preview']) ? 'active' : '' }}">
                        <div class="step-number">2</div>
                        <span>Details</span>
                    </div>
                    <div class="step {{ $currentTab == 'preview' ? 'active' : '' }}">
                        <div class="step-number">3</div>
                        <span>Preview</span>
                    </div>
                    <div class="step">
                        <div class="step-number">4</div>
                        <span>Publish</span>
                    </div>
                </div>
                <a href="#" class="help-link">
                    <i class="fas fa-question-circle"></i>
                    Help Center
                </a>
            </div>

            <div class="content-area">
                <div class="sidebar">
                    <a href="#" class="nav-item {{ $currentTab == 'job-details' ? 'active' : '' }}"
                        wire:click.prevent="navigateTo('job-details')">
                        <i class="fas fa-layer-group"></i>
                        <span>Job Details</span>
                    </a>
                    <a href="#" class="nav-item {{ $currentTab == 'salary-benefits' ? 'active' : '' }}"
                        wire:click.prevent="navigateTo('salary-benefits')">
                        <i class="fas fa-money-bill-wave"></i>
                        <span>Salary & Benefits</span>
                    </a>
                    <a href="#" class="nav-item {{ $currentTab == 'company-info' ? 'active' : '' }}"
                        wire:click.prevent="navigateTo('company-info')">
                        <i class="fas fa-users"></i>
                        <span>Company Info</span>
                    </a>
                    <a href="#" class="nav-item {{ $currentTab == 'requirements' ? 'active' : '' }}"
                        wire:click.prevent="navigateTo('requirements')">
                        <i class="fas fa-clipboard-list"></i>
                        <span>Requirements</span>
                    </a>
                    <a href="#" class="nav-item {{ $currentTab == 'questions' ? 'active' : '' }}"
                        wire:click.prevent="navigateTo('questions')">
                        <i class="fas fa-question-circle"></i>
                        <span>Questions</span>
                    </a>
                    <a href="#" class="nav-item {{ $currentTab == 'preview' ? 'active' : '' }}"
                        wire:click.prevent="navigateTo('preview')">
                        <i class="fas fa-eye"></i>
                        <span>Preview</span>
                    </a>
                </div>

                <div class="main-content">
                    <div class="section-title">
                        <i class="fas fa-pencil-alt"></i>
                        Create Job Post
                    </div>

                    @if (session('message'))
                        <div class="alert alert-success">
                            {{ session('message') }}
                        </div>
                    @endif

                    @if (session('job_created'))
                        <div class="verification-card success">
                            <div class="verification-icon">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div class="verification-content">
                                <h3>Job Post Created Successfully!</h3>
                                <p>Your job post has been saved and is ready to be published.</p>
                            </div>
                        </div>
                    @else
                        @if (auth()->user()->email_verified_at)
                        @else
                            <div class="verification-card">
                                <div class="verification-icon">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div class="verification-content">
                                    <h3>Verify your account to post your first job ad</h3>
                                    <p>Please confirm your email address by clicking on the link sent to
                                        madusankakalpa65@gmail.com.</p>
                                    <div class="email-check">
                                        <i class="fas fa-check-circle"></i>
                                        <span>Can't find the email? Resend verification</span>
                                    </div>
                                </div>
                            </div>
                        @endif

                    @endif

                    <!-- Job Details Tab -->
                    <div class="tab-content {{ $currentTab == 'job-details' ? 'active' : '' }}" id="job-details-tab">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="jobTitle" class="form-label">
                                    <i class="fas fa-tag"></i>
                                    Job Title
                                </label>
                                <div class="input-with-icon">
                                    <i class="input-icon fas fa-briefcase"></i>
                                    <input type="text" id="jobTitle" class="input-field"
                                        placeholder="e.g. Sales Assistant" wire:model.live="jobDetails.jobTitle">

                                </div>
                                @error('jobDetails.jobTitle')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="location" class="form-label">
                                    <i class="fas fa-map-marker-alt"></i>
                                    Location
                                </label>
                                <div class="input-with-icon">
                                    <i class="input-icon fas fa-location-arrow"></i>
                                    <input type="text" id="location" class="input-field"
                                        placeholder="e.g. New York City" wire:model="jobDetails.location">

                                </div>
                                @error('jobDetails.location')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group full-width">
                                <label class="form-label">
                                    <i class="fas fa-laptop-house"></i>
                                    Workplace Option
                                </label>
                                <div class="options-grid">
                                    @foreach ($workplaceOptions as $key => $option)
                                        <div class="option-card {{ $jobDetails['workplaceOption'] == $key ? 'selected' : '' }}"
                                            wire:click="selectWorkplaceOption('{{ $key }}')">
                                            <div class="option-icon">
                                                <i class="fas fa-{{ $option['icon'] }}"></i>
                                            </div>
                                            <div class="option-name">{{ $option['name'] }}</div>
                                            <div class="option-desc">{{ $option['desc'] }}</div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="form-group">
                                <label for="jobType" class="form-label">
                                    <i class="fas fa-clock"></i>
                                    Job Type
                                </label>
                                <div class="input-with-icon">
                                    <i class="input-icon fas fa-calendar"></i>
                                    <select id="jobType" class="select-field" wire:model="jobDetails.jobType">
                                        <option value="">Select job type</option>
                                        <option value="full-time">Full Time</option>
                                        <option value="part-time">Part Time</option>
                                        <option value="contract">Contract</option>
                                        <option value="temporary">Temporary</option>
                                        <option value="internship">Internship</option>
                                    </select>

                                </div>
                                @error('jobDetails.jobType')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="category" class="form-label">
                                    <i class="fas fa-folder"></i>
                                    Category
                                </label>
                                <div class="input-with-icon">
                                    <i class="input-icon fas fa-tag"></i>
                                    <select id="category" class="select-field" wire:model="jobDetails.category">
                                        <option value="">Select category</option>
                                        <option value="sales">Sales</option>
                                        <option value="technology">Technology</option>
                                        <option value="marketing">Marketing</option>
                                        <option value="design">Design</option>
                                        <option value="finance">Finance</option>
                                        <option value="hr">Human Resources</option>
                                    </select>

                                </div>
                                @error('jobDetails.category')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group full-width">
                                <label for="description" class="form-label">
                                    <i class="fas fa-file-alt"></i>
                                    Job Description
                                </label>

                                <textarea id="description" class="textarea-field"
                                    placeholder="Describe the responsibilities, tasks, and objectives of the job"
                                    wire:model.live="jobDetails.description"></textarea>

                                @error('jobDetails.description')
                                    <span class="error">{{ $message }}</span>
                                @enderror

                                <!-- Generate Button -->
                                <button type="button" class="btn btn-primary mt-2 d-flex align-items-center"
                                    wire:click="generateDescription">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="18"
                                        height="18" fill="currentColor" aria-hidden="true" class="me-2">
                                        <path
                                            d="M256 32c-16 176-112 272-288 288 176 16 272 112 288 288 16-176 112-272 288-288-176-16-272-112-288-288z" />
                                        <path
                                            d="M432 96c-5 51-32 78-83 83 51 5 78 32 83 83 5-51 32-78 83-83-51-5-78-32-83-83z" />
                                        <path
                                            d="M80 320c-5 51-32 78-83 83 51 5 78 32 83 83 5-51 32-78 83-83-51-5-78-32-83-83z" />
                                    </svg>
                                    Generate
                                </button>

                            </div>

                        </div>
                    </div>

                    <!-- Salary & Benefits Tab -->
                    <!-- Salary & Benefits Tab -->
                    <div class="tab-content {{ $currentTab == 'salary-benefits' ? 'active' : '' }}"
                        id="salary-benefits-tab">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="salaryType" class="form-label">
                                    <i class="fas fa-money-bill"></i>
                                    Salary Type
                                </label>
                                <div class="input-with-icon">
                                    <i class="input-icon fas fa-money-check"></i>
                                    <select id="salaryType" class="select-field"
                                        wire:model.live="salaryBenefits.salaryType"
                                        wire:change="$dispatch('salaryTypeChanged', salaryBenefits.salaryType)">
                                        <option value="">Select salary type</option>
                                        <option value="fixed">Fixed Salary</option>
                                        <option value="range">Salary Range</option>
                                        <option value="negotiable">Negotiable</option>
                                    </select>

                                </div>
                                @error('salaryBenefits.salaryType')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="currency" class="form-label">
                                    <i class="fas fa-dollar-sign"></i>
                                    Currency
                                </label>
                                <div class="input-with-icon">
                                    <i class="input-icon fas fa-coins"></i>
                                    <select id="currency" class="select-field" wire:model="salaryBenefits.currency">
                                        <option value="USD">USD ($)</option>
                                        <option value="EUR">EUR (€)</option>
                                        <option value="GBP">GBP (£)</option>
                                        <option value="JPY">JPY (¥)</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Salary Range Container (initially hidden) -->
                            <div class="form-group full-width salary-range-container" id="salaryRangeContainer"
                                style="{{ $salaryBenefits['salaryType'] === 'range' ? 'display: block;' : 'display: none;' }}">
                                <label class="form-label">Salary Range</label>
                                <div class="salary-range">
                                    <div class="input-with-icon salary-input">
                                        <i class="input-icon fas fa-minus"></i>
                                        <input type="number" id="minSalary" class="input-field"
                                            placeholder="Minimum" wire:model="salaryBenefits.minSalary">

                                    </div>
                                    @error('salaryBenefits.minSalary')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                    <div class="input-with-icon salary-input">
                                        <i class="input-icon fas fa-plus"></i>
                                        <input type="number" id="maxSalary" class="input-field"
                                            placeholder="Maximum" wire:model="salaryBenefits.maxSalary">

                                    </div>
                                    @error('salaryBenefits.maxSalary')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                    <div class="input-with-icon salary-input">
                                        <i class="input-icon fas fa-history"></i>
                                        <select id="salaryPeriod" class="select-field"
                                            wire:model="salaryBenefits.salaryPeriod">
                                            <option value="hour">Per Hour</option>
                                            <option value="week">Per Week</option>
                                            <option value="month" selected>Per Month</option>
                                            <option value="year">Per Year</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group full-width">
                                <label class="form-label">
                                    <i class="fas fa-gift"></i>
                                    Benefits
                                </label>
                                <div class="benefits-grid">
                                    @foreach ($benefitsList as $key => $benefit)
                                        <div class="benefit-item {{ in_array($key, $salaryBenefits['benefits']) ? 'selected' : '' }}"
                                            wire:click="toggleBenefit('{{ $key }}')">
                                            <i class="fas fa-{{ $benefit['icon'] }}"></i>
                                            <span>{{ $benefit['name'] }}</span>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Company Info Tab -->
                    <div class="tab-content {{ $currentTab == 'company-info' ? 'active' : '' }}"
                        id="company-info-tab">
                        <div class="form-grid">
                            {{-- <div class="form-group" hidden>
                                <label for="companyName" class="form-label">
                                    <i class="fas fa-building"></i>
                                    Company Name
                                </label>
                                <div class="input-with-icon">
                                    <i class="input-icon fas fa-landmark"></i>
                                    <input type="text" id="companyName" class="input-field"
                                        placeholder="Your company name" wire:model="companyInfo.companyName">

                                </div>
                                @error('companyInfo.companyName')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div> --}}

                            <div class="form-group">
                                <label for="companyWebsite" class="form-label">
                                    <i class="fas fa-globe"></i>
                                    Website
                                </label>
                                <div class="input-with-icon">
                                    <i class="input-icon fas fa-link"></i>
                                    <input type="url" id="companyWebsite" class="input-field"
                                        placeholder="https://example.com" wire:model="companyInfo.companyWebsite">

                                </div>
                                @error('companyInfo.companyWebsite')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            {{-- <div class="form-group full-width" hidden>
                                <label for="companyDescription" class="form-label">
                                    <i class="fas fa-file-alt"></i>
                                    Company Description
                                </label>
                                <textarea id="companyDescription" class="textarea-field" placeholder="Brief description of your company"
                                    wire:model="companyInfo.companyDescription"></textarea>
                            </div> --}}

                            <div class="form-group">
                                <label for="companySize" class="form-label">
                                    <i class="fas fa-users"></i>
                                    Company Size
                                </label>
                                <div class="input-with-icon">
                                    <i class="input-icon fas fa-user-friends"></i>
                                    <select id="companySize" class="select-field"
                                        wire:model="companyInfo.companySize">
                                        <option value="">Select size</option>
                                        <option value="1-10">1-10 employees</option>
                                        <option value="11-50">11-50 employees</option>
                                        <option value="51-200">51-200 employees</option>
                                        <option value="201-500">201-500 employees</option>
                                        <option value="501-1000">501-1000 employees</option>
                                        <option value="1000+">1000+ employees</option>
                                    </select>

                                </div>
                                @error('companyInfo.companySize')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="industry" class="form-label">
                                    <i class="fas fa-industry"></i>
                                    Industry
                                </label>
                                <div class="input-with-icon">
                                    <i class="input-icon fas fa-cog"></i>
                                    <select id="industry" class="select-field" wire:model="companyInfo.industry">
                                        <option value="">Select industry</option>
                                        <option value="technology">Technology</option>
                                        <option value="finance">Finance</option>
                                        <option value="healthcare">Healthcare</option>
                                        <option value="education">Education</option>
                                        <option value="retail">Retail</option>
                                        <option value="manufacturing">Manufacturing</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Requirements Tab -->
                    <div class="tab-content {{ $currentTab == 'requirements' ? 'active' : '' }}"
                        id="requirements-tab">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="experienceLevel" class="form-label">
                                    <i class="fas fa-chart-line"></i>
                                    Experience Level
                                </label>
                                <div class="input-with-icon">
                                    <i class="input-icon fas fa-user-tie"></i>
                                    <select id="experienceLevel" class="select-field"
                                        wire:model="requirements.experienceLevel">
                                        <option value="">Select experience level</option>
                                        <option value="intern">Intern</option>
                                        <option value="entry">Entry Level</option>
                                        <option value="mid">Mid Level</option>
                                        <option value="senior">Senior Level</option>
                                        <option value="director">Director</option>
                                        <option value="executive">Executive</option>
                                    </select>
                                </div>
                                @error('requirements.experienceLevel')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="educationLevel" class="form-label">
                                    <i class="fas fa-graduation-cap"></i>
                                    Education Level
                                </label>
                                <div class="input-with-icon">
                                    <i class="input-icon fas fa-book"></i>
                                    <select id="educationLevel" class="select-field"
                                        wire:model="requirements.educationLevel">
                                        <option value="">Select education level</option>
                                        <option value="high-school">High School</option>
                                        <option value="associate">Associate Degree</option>
                                        <option value="bachelor">Bachelor's Degree</option>
                                        <option value="master">Master's Degree</option>
                                        <option value="phd">PhD</option>
                                        <option value="none">No Degree</option>
                                    </select>
                                </div>
                                @error('requirements.educationLevel')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group full-width">
                                <label for="skills" class="form-label">
                                    <i class="fas fa-tools"></i>
                                    Required Skills
                                </label>
                                <textarea id="skills" class="textarea-field"
                                    placeholder="List the required skills for this position (one per line)" wire:model="requirements.skills"></textarea>

                                <button type="button" class="btn btn-primary mt-2 d-flex align-items-center"
                                    wire:click="generateskill">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="18"
                                        height="18" fill="currentColor" aria-hidden="true" class="me-2">
                                        <path
                                            d="M256 32c-16 176-112 272-288 288 176 16 272 112 288 288 16-176 112-272 288-288-176-16-272-112-288-288z" />
                                        <path
                                            d="M432 96c-5 51-32 78-83 83 51 5 78 32 83 83 5-51 32-78 83-83-51-5-78-32-83-83z" />
                                        <path
                                            d="M80 320c-5 51-32 78-83 83 51 5 78 32 83 83 5-51 32-78 83-83-51-5-78-32-83-83z" />
                                    </svg>
                                    Generate
                                </button>
                            </div>


                            <div class="form-group full-width">
                                <label class="form-label">
                                    <i class="fas fa-tasks"></i>
                                    Additional Requirements
                                </label>
                                <div class="checkbox-group">
                                    <input type="checkbox" id="coverLetter" wire:model="requirements.coverLetter">
                                    <label for="coverLetter">Require cover letter</label>
                                </div>
                                <div class="checkbox-group">
                                    <input type="checkbox" id="portfolio" wire:model="requirements.portfolio">
                                    <label for="portfolio">Require portfolio</label>
                                </div>
                                <div class="checkbox-group">
                                    <input type="checkbox" id="references" wire:model="requirements.references">
                                    <label for="references">Require references</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="tab-content {{ $currentTab == 'questions' ? 'active' : '' }}" id="questions-tab">
                        <div class="form-group full-width">
                            <label class="form-label">
                                <i class="fas fa-question"></i>
                                Application Questions
                            </label>
                            <p class="text-muted mb-3">Add custom questions for applicants to answer when applying for
                                this position.</p>

                            @foreach ($questionsTab['questions'] as $qIndex => $question)
                                @if (!isset($question['deleted']) || !$question['deleted'])
                                    <div class="question-card mb-4 p-4 border rounded">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <h5 class="mb-0">Question #{{ $qIndex + 1 }}</h5>
                                            <button type="button" class="btn btn-sm btn-outline-danger"
                                                wire:click="removeQuestion({{ $qIndex }})">
                                                <i class="fas fa-trash"></i> Remove
                                            </button>
                                        </div>

                                        <div class="form-group mb-3">
                                            <label class="form-label">Question</label>
                                            <input type="text" class="form-control"
                                                wire:model="questionsTab.questions.{{ $qIndex }}.question"
                                                placeholder="Enter your question">
                                            @error('questionsTab.questions.' . $qIndex . '.question')
                                                <span class="error">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group mb-3">
                                            <label class="form-label">Question Type</label>
                                            <select class="form-select"
                                                wire:model="questionsTab.questions.{{ $qIndex }}.type">
                                                @foreach ($questionTypes as $key => $type)
                                                    <option value="{{ $key }}">{{ $type }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="checkbox"
                                                id="required-{{ $qIndex }}"
                                                wire:model="questionsTab.questions.{{ $qIndex }}.is_required">
                                            <label class="form-check-label" for="required-{{ $qIndex }}">
                                                Required question
                                            </label>
                                        </div>

                                        @if (in_array($question['type'], ['multiple_choice', 'checkbox', 'dropdown']))
                                            <div class="answers-section">
                                                <label class="form-label">Answer Options</label>
                                                @foreach ($question['answers'] as $aIndex => $answer)
                                                    @if (!isset($answer['deleted']) || !$answer['deleted'])
                                                        <div class="answer-input d-flex align-items-center mb-2">
                                                            <input type="text" class="form-control me-2"
                                                                wire:model="questionsTab.questions.{{ $qIndex }}.answers.{{ $aIndex }}"
                                                                placeholder="Answer option">
                                                            <button type="button"
                                                                class="btn btn-sm btn-outline-danger"
                                                                wire:click="removeAnswer({{ $qIndex }}, {{ $aIndex }})">
                                                                <i class="fas fa-times"></i>
                                                            </button>
                                                        </div>
                                                    @endif
                                                @endforeach

                                                <button type="button" class="btn btn-sm btn-outline-primary mt-2"
                                                    wire:click="addAnswer({{ $qIndex }})">
                                                    <i class="fas fa-plus"></i> Add Answer
                                                </button>
                                            </div>
                                        @endif
                                    </div>
                                @endif
                            @endforeach

                            <button type="button" class="btn btn-primary" wire:click="addQuestion">
                                <i class="fas fa-plus"></i> Add Question
                            </button>
                        </div>
                    </div>

                    <!-- Preview Tab -->
                    <div class="tab-content {{ $currentTab == 'preview' ? 'active' : '' }}" id="preview-tab">
                        <div class="preview-card">
                            <div class="preview-header">
                                <div>
                                    <h2 class="preview-title">{{ $jobDetails['jobTitle'] ?: 'Job Title' }}</h2>
                                    <div class="preview-company">{{ $businessname ?? 'N/A' }}
                                    </div>
                                    <div class="preview-location">
                                        <i class="fas fa-map-marker-alt"></i>
                                        <span>{{ $jobDetails['location'] ?: 'Location' }}</span>
                                    </div>
                                </div>
                                <div class="preview-tags">
                                    <span class="preview-tag">{{ $jobDetails['jobType'] ?: 'Job Type' }}</span>
                                    <span
                                        class="preview-tag">{{ $workplaceOptions[$jobDetails['workplaceOption']]['name'] }}</span>
                                </div>
                            </div>

                            <div class="preview-section">
                                <h3 class="preview-section-title">Job Description</h3>
                                <div class="preview-section-content">
                                    <p>{{ $jobDetails['description'] ?: 'Job description will appear here' }}</p>
                                </div>
                            </div>

                            <div class="preview-section">
                                <h3 class="preview-section-title">Salary & Benefits</h3>
                                <div class="preview-section-content">
                                    @if ($salaryBenefits['salaryType'] === 'range')
                                        <p><strong>Salary:</strong>
                                            {{ $salaryBenefits['minSalary'] }} - {{ $salaryBenefits['maxSalary'] }}
                                            {{ $salaryBenefits['currency'] }}
                                            per {{ $salaryBenefits['salaryPeriod'] }}
                                        </p>
                                    @elseif($salaryBenefits['salaryType'])
                                        <p><strong>Salary:</strong> {{ ucfirst($salaryBenefits['salaryType']) }}</p>
                                    @endif

                                    @if (count($salaryBenefits['benefits']) > 0)
                                        <div class="preview-benefits">
                                            @foreach ($salaryBenefits['benefits'] as $benefitKey)
                                                @if (isset($benefitsList[$benefitKey]))
                                                    <div class="preview-benefit">
                                                        <i class="fas fa-check-circle"></i>
                                                        <span>{{ $benefitsList[$benefitKey]['name'] }}</span>
                                                    </div>
                                                @endif
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <div class="preview-section">
                                <h3 class="preview-section-title">Requirements</h3>
                                <div class="preview-section-content">
                                    @if ($requirements['experienceLevel'])
                                        <p><strong>Experience:</strong> {{ ucfirst($requirements['experienceLevel']) }}
                                        </p>
                                    @endif

                                    @if ($requirements['educationLevel'])
                                        <p><strong>Education:</strong> {{ ucfirst($requirements['educationLevel']) }}
                                        </p>
                                    @endif

                                    @if ($requirements['skills'])
                                        <p><strong>Skills:</strong></p>
                                        <ul>
                                            @foreach (explode("\n", $requirements['skills']) as $skill)
                                                @if (trim($skill))
                                                    <li>{{ $skill }}</li>
                                                @endif
                                            @endforeach
                                        </ul>
                                    @endif
                                </div>
                            </div>

                            <div class="tab-content {{ $currentTab == 'preview' ? 'active' : '' }}" id="preview-tab">
                                <!-- ... existing preview content ... -->

                                <div class="preview-section">
                                    <h3 class="preview-section-title">Application Questions</h3>
                                    <div class="preview-section-content">
                                        @if (count($questionsTab['questions']) > 0)
                                            <ol>
                                                @foreach ($questionsTab['questions'] as $question)
                                                    @if (!isset($question['deleted']) || !$question['deleted'])
                                                        <li class="mb-3">
                                                            <strong>{{ $question['question'] }}</strong>
                                                            @if ($question['is_required'])
                                                                <span class="text-danger">*</span>
                                                            @endif
                                                            <br>
                                                            <small class="text-muted">Type:
                                                                {{ $questionTypes[$question['type']] }}</small>

                                                            @if (in_array($question['type'], ['multiple_choice', 'checkbox', 'dropdown']) &&
                                                                    isset($question['answers']) &&
                                                                    count($question['answers']) > 0)
                                                                <ul class="mt-2">
                                                                    @foreach ($question['answers'] as $answer)
                                                                        @if (!isset($answer['deleted']) || !$answer['deleted'])
                                                                            <li>{{ $answer }}</li>
                                                                        @endif
                                                                    @endforeach
                                                                </ul>
                                                            @endif
                                                        </li>
                                                    @endif
                                                @endforeach
                                            </ol>
                                        @else
                                            <p>No custom questions added.</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="form-group full-width">
                                <label for="finalNotes" class="form-label">
                                    <i class="fas fa-sticky-note"></i>
                                    Final Notes
                                </label>
                                <textarea id="finalNotes" class="textarea-field" placeholder="Any additional information for the hiring team"
                                    wire:model="previewNotes"></textarea>
                            </div>
                        </div>


                    </div>
                    <div class="form-actions">
                            @if ($currentTab != 'job-details')
                                <button type="button" class="btn btn-outline" wire:click="goBack">
                                    <i class="fas fa-arrow-left"></i>
                                    Back
                                </button>
                            @endif

                            <button type="button" class="btn btn-outline" wire:click="saveDraft">
                                <i class="fas fa-save"></i>
                                Save Draft
                            </button>

                              <button type="button" id="savebtn" class="btn btn-primary" wire:click="saveAndContinue"
                            wire:loading.attr="disabled">
                            <span>{{ $currentTab == 'preview' ? 'Publish Job' : 'Continue' }}</span>
                            <i class="fas fa-arrow-right"></i>
                        </button>
                        </div>
                </div>
        </main>

        <div class="loading-overlay" id="loadingOverlay">
            <div class="loading-card">
                <div class="spinner"></div>
                <h3 class="loading-title">Saving Your Job Post</h3>
                <p class="loading-text">Please wait while we save your job post details. This will only take a moment.
                </p>
            </div>
        </div>
    </div>

    <style>
        /* Add error styling */
        .error {
            color: #e53e3e;
            font-size: 14px;
            margin-top: 5px;
            display: block;
        }

        .alert-success {
            background-color: #f0fff4;
            color: #2d8f41;
            padding: 12px 16px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #38a169;
        }

        .verification-card.success {
            border-left-color: #38a169;
        }

        .verification-card.success .verification-icon {
            color: #38a169;
        }
    </style>

    <script>
        // Tab navigation
        const navItems = document.querySelectorAll('.nav-item');
        const tabContents = document.querySelectorAll('.tab-content');

        navItems.forEach(item => {
            item.addEventListener('click', function(e) {
                e.preventDefault();

                // Remove active class from all items and contents
                navItems.forEach(nav => nav.classList.remove('active'));
                tabContents.forEach(tab => tab.classList.remove('active'));

                // Add active class to clicked item
                this.classList.add('active');

                // Show corresponding tab content
                const tabId = this.getAttribute('data-tab') + '-tab';
                document.getElementById(tabId).classList.add('active');
            });
        });

        // Workplace option selection
        const options = document.querySelectorAll('.option-card');
        options.forEach(option => {
            option.addEventListener('click', () => {
                options.forEach(opt => opt.classList.remove('selected'));
                option.classList.add('selected');
            });
        });

        // Benefit selection
        const benefits = document.querySelectorAll('.benefit-item');
        benefits.forEach(benefit => {
            benefit.addEventListener('click', () => {
                benefit.classList.toggle('selected');
            });
        });

        // Form submission with loading indicator
        document.getElementById('savebtn').addEventListener('click', function(e) {
            e.preventDefault();

            // Get form elements
            const jobTitle = document.getElementById('jobTitle').value;
            const location = document.getElementById('location').value;

            // Validate form
            if (!jobTitle || !location) {

                return;
            }

            // Show loading overlay
            const loadingOverlay = document.getElementById('loadingOverlay');
            const saveButton = document.getElementById('saveButton');

            loadingOverlay.classList.add('active');
            saveButton.disabled = true;

            // Simulate form submission (replace with actual form submission)
            setTimeout(() => {
                // Hide loading overlay after 2 seconds (simulated save)
                loadingOverlay.classList.remove('active');
                saveButton.disabled = false;

                // Show success message

            }, 2000);
        });

        // Salary type change handler
        document.getElementById('salaryType').addEventListener('change', function() {
            const salaryRangeContainer = document.getElementById('salaryRangeContainer');
            if (this.value === 'range') {
                salaryRangeContainer.style.display = 'block';
            } else {
                salaryRangeContainer.style.display = 'none';
            }
        });
    </script>
    <style>
        body {
            background-color: #f8f9fa;
            color: #333;
            line-height: 1.6;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 20px;
        }

        .progress-container {
            background: white;
            padding: 15px 30px;
            border-bottom: 1px solid #eaeaea;
            display: flex;
            align-items: center;
            justify-content: space-between;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .progress-steps {
            display: flex;
            gap: 30px;
        }

        .step {
            display: flex;
            align-items: center;
            gap: 10px;
            font-weight: 500;
            color: #a0aec0;
            position: relative;
        }

        .step.active {
            color: #3498db;
        }

        .step.completed {
            color: #27ae60;
        }

        .step-number {
            width: 28px;
            height: 28px;
            border-radius: 50%;
            background: #f8f9fa;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 14px;
            border: 1px solid #eaeaea;
        }

        .active .step-number {
            background: #4a6cf7;
            color: white;
            border-color: #4a6cf7;
        }

        .completed .step-number {
            background: #27ae60;
            color: white;
            border-color: #27ae60;
        }

        .step::after {
            content: "";
            position: absolute;
            top: 50%;
            left: calc(100% + 5px);
            width: 20px;
            height: 1px;
            background: #eaeaea;
        }

        .step:last-child::after {
            display: none;
        }

        .help-link {
            color: #4a6cf7;
            text-decoration: none;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .content-area {
            display: flex;
            min-height: 600px;
            margin-top: 20px;
        }

        .sidebar {
            width: 240px;
            background: white;
            padding: 25px 0;
            border-right: 1px solid #eaeaea;
            border-radius: 10px 0 0 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .nav-item {
            padding: 14px 25px;
            display: flex;
            align-items: center;
            gap: 12px;
            color: #4a5568;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s ease;
            border-left: 4px solid transparent;
        }

        .nav-item:hover {
            background: rgba(52, 152, 219, 0.05);
            color: #2c3e50;
        }

        .nav-item.active {
            background: rgba(52, 152, 219, 0.1);
            color: #4a6cf7;
            border-left-color: #4a6cf7;
        }

        .nav-item i {
            width: 20px;
            text-align: center;
        }

        .main-content {
            flex: 1;
            padding: 30px;
            background: white;
            border-radius: 0 10px 10px 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .section-title {
            font-size: 22px;
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .section-title::after {
            content: "";
            flex: 1;
            height: 1px;
            background: #eaeaea;
            margin-left: 10px;
        }

        .question-card {
            background: #f8f9fa;
            border-radius: 8px;
        }

        .answer-input {
            transition: all 0.3s ease;
        }

        .answer-input:hover {
            background: #f1f3f5;
        }

        .verification-card {
            background: linear-gradient(to right, #e8f4fc, #f0f8ff);
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 30px;
            border-left: 4px solid #4a6cf7;
            display: flex;
            gap: 15px;
        }

        .verification-icon {
            color: #4a6cf7;
            font-size: 24px;
        }

        .verification-content h3 {
            color: #2c3e50;
            margin-bottom: 8px;
            font-weight: 600;
        }

        .verification-content p {
            margin-bottom: 12px;
            color: #4a5568;
            line-height: 1.5;
        }

        .email-check {
            display: flex;
            align-items: center;
            gap: 8px;
            color: #27ae60;
            font-weight: 500;
            cursor: pointer;
        }

        .form-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 25px;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group.full-width {
            grid-column: 1 / -1;
        }

        .form-label {
            display: block;
            margin-bottom: 10px;
            font-weight: 600;
            color: #2c3e50;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .input-field,
        .textarea-field,
        .select-field {
            width: 100%;
            padding: 16px 18px;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: white;
            box-sizing: border-box;
        }

        .textarea-field {
            min-height: 120px;
            resize: vertical;
        }

        .input-field:focus,
        .textarea-field:focus,
        .select-field:focus {
            outline: none;
            border-color: #4a6cf7;
            box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.15);
        }

        .input-field::placeholder,
        .textarea-field::placeholder {
            color: #a0aec0;
        }

        .input-with-icon {
            position: relative;
        }

        .input-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #a0aec0;
        }

        .input-with-icon .input-field,
        .input-with-icon .select-field {
            padding-left: 45px;
        }

        .options-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            margin-top: 10px;
        }

        .option-card {
            border: 2px solid #e2e8f0;
            padding: 20px 15px;
            border-radius: 12px;
            cursor: pointer;
            text-align: center;
            transition: all 0.3s ease;
            background: white;
        }

        .option-card:hover {
            border-color: #3498db;
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }

        .option-card.selected {
            border-color: #4a6cf7;
            background: #f0f8ff;
        }

        .option-icon {
            font-size: 24px;
            color: #4a6cf7;
            margin-bottom: 12px;
        }

        .option-name {
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 5px;
        }

        .option-desc {
            font-size: 13px;
            color: #718096;
        }

        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 15px;
        }

        .checkbox-group input {
            width: 18px;
            height: 18px;
        }

        .salary-range {
            display: flex;
            gap: 15px;
            margin-top: 10px;
        }

        .salary-input {
            flex: 1;
        }

        .benefits-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            margin-top: 10px;
        }

        .benefit-item {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .benefit-item:hover {
            border-color: #3498db;
            background: #f8f9fa;
        }

        .benefit-item.selected {
            border-color: #4a6cf7;
            background: #f0f8ff;
        }

        .benefit-item i {
            color: #4a6cf7;
        }

        .form-actions {
            display: flex;
            justify-content: space-between;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eaeaea;
        }

        .btn {
            padding: 15px 30px;
            border-radius: 10px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 16px;
            display: flex;
            align-items: center;
            gap: 8px;
            border: none;
        }

        .btn-outline {
            background: transparent;
            border: 1px solid #e2e8f0;
            color: #4a5568;
        }

        .btn-outline:hover {
            background: #f8f9fa;
            border-color: #cbd5e0;
        }

        .btn-primary {
            background: linear-gradient(120deg, #4a6cf7 0%, #4a6cf7 100%);
            color: white;
            box-shadow: 0 4px 12px rgba(52, 152, 219, 0.2);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(52, 152, 219, 0.3);
        }

        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.95);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .loading-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .loading-card {
            background: white;
            padding: 40px;
            border-radius: 16px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
            max-width: 400px;
            width: 90%;
        }

        .spinner {
            width: 60px;
            height: 60px;
            border: 4px solid #f3f3f3;
            border-top: 4px solid #3498db;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .loading-title {
            font-size: 22px;
            color: #2c3e50;
            margin-bottom: 10px;
            font-weight: 600;
        }

        .loading-text {
            color: #718096;
            line-height: 1.5;
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        .preview-card {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 20px;
            border: 1px solid #eaeaea;
        }

        .preview-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
        }

        .preview-title {
            font-size: 24px;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 5px;
        }

        .preview-company {
            font-size: 18px;
            color: #4a6cf7;
            margin-bottom: 10px;
        }

        .preview-location {
            display: flex;
            align-items: center;
            gap: 8px;
            color: #718096;
            margin-bottom: 15px;
        }

        .preview-tags {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }

        .preview-tag {
            background: #e8f4fc;
            color: #4a6cf7;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 500;
        }

        .preview-section {
            margin-bottom: 25px;
        }

        .preview-section-title {
            font-size: 18px;
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 12px;
            padding-bottom: 8px;
            border-bottom: 1px solid #eaeaea;
        }

        .preview-section-content {
            color: #4a5568;
            line-height: 1.6;
        }

        .preview-benefits {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }

        .preview-benefit {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .preview-benefit i {
            color: #27ae60;
            font-size: 18px;
        }

        @media (max-width: 900px) {
            .form-grid {
                grid-template-columns: 1fr;
            }

            .content-area {
                flex-direction: column;
            }

            .sidebar {
                width: 100%;
                border-right: none;
                border-bottom: 1px solid #eaeaea;
                padding: 15px 0;
                border-radius: 10px 10px 0 0;
            }

            .nav-items {
                display: flex;
                overflow-x: auto;
                padding: 0 15px;
            }

            .nav-item {
                padding: 10px 15px;
                white-space: nowrap;
                border-left: none;
                border-bottom: 3px solid transparent;
            }

            .nav-item.active {
                border-left-color: transparent;
                border-bottom-color: #3498db;
            }

            .options-grid,
            .benefits-grid {
                grid-template-columns: 1fr;
            }

            .progress-steps {
                gap: 15px;
                overflow-x: auto;
                padding-bottom: 10px;
            }

            .step::after {
                display: none;
            }

            .main-content {
                border-radius: 0 0 10px 10px;
            }

            .preview-benefits {
                grid-template-columns: 1fr;
            }
        }
    </style>
    <style>
        .salary-range-container {
            display: none;
            transition: all 0.3s ease;
        }

        .salary-range-container.visible {
            display: grid;
        }

        .salary-range {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 15px;
            margin-top: 10px;
        }

        @media (max-width: 768px) {
            .salary-range {
                grid-template-columns: 1fr;
            }
        }
    </style>

    <script>
        document.addEventListener('livewire:init', () => {
            Livewire.on('salaryTypeChanged', (salaryType) => {
                const container = document.getElementById('salaryRangeContainer');
                if (salaryType === 'range') {
                    container.classList.add('visible');
                } else {
                    container.classList.remove('visible');
                }
            });
        });
        document.getElementById('jobForm').addEventListener('submit', function(e) {
            e.preventDefault();

            // Get form elements
            const jobTitle = document.getElementById('jobTitle').value;
            const location = document.getElementById('location').value;

            // Validate
            if (!jobTitle || !location) {
                alert('Please fill in all required fields');
                return;
            }

            // Show spinner
            const loadingOverlay = document.getElementById('loadingOverlay');
            const saveButton = document.getElementById('saveButton');
            loadingOverlay.classList.add('active');
            saveButton.disabled = true;

            // Trigger Livewire save
            Livewire.dispatch('savingjob');
        });

        window.addEventListener('jobSaved', function() {
            const loadingOverlay = document.getElementById('loadingOverlay');
            const saveButton = document.getElementById('saveButton');
            loadingOverlay.classList.remove('active');
            saveButton.disabled = false;

        });
    </script>
</div>
