<div>
    <main class="container" style="padding-top:7%;padding-left:6%;padding-right:6%;">
        <!-- Welcome Banner -->
        <div class="welcome-banner">
            <div class="welcome-content">
                <h1>Welcome back, John!</h1>
                <p>You have 12 new applications this week. Stay on top of your hiring process with our easy-to-use
                    tools.</p>
            </div>
            <button class="welcome-cta" wire:click="postnewjob">Post a New Job</button>
        </div>

      @if ($showBusinessForm)
    <div class="timeline-form-wrapper" wire:loading.class="opacity-50" wire:target="saveBusinessprofile">

        <h2 class="form-title">Complete Your Business Profile</h2>
        <div class="form-container">
            <!-- Timeline Steps -->
            <div class="form-steps">
                <div class="step">
                    <span class="icon"><i class="fa fa-building"></i></span> Business Info
                </div>
                <div class="step">
                    <span class="icon"><i class="fa fa-envelope"></i></span> Contact Info
                </div>
                <div class="step">
                    <span class="icon"><i class="fa fa-map-marker-alt"></i></span> Address
                </div>

                <div class="progress-line"></div>
            </div>

            <!-- Form Fields -->
            <div class="form-fields">
                <form wire:submit.prevent="saveBusinessprofile" enctype="multipart/form-data">
                    <div class="form-group">
                        <label>Business Name</label>
                        <input type="text" wire:model="businessname" placeholder="Ex: Tech Innovators Pvt Ltd">
                        @error('businessname')
                            <span class="error-msg">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" wire:model="email" placeholder="business@email.com">
                        @error('email')
                            <span class="error-msg">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label>Phone</label>
                        <input type="text" wire:model="phone" placeholder="+61 2 9456 7890">
                        @error('phone')
                            <span class="error-msg">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label>Address</label>
                        <textarea wire:model="address" placeholder="Enter your office address"></textarea>
                        @error('address')
                            <span class="error-msg">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- Company Logo Upload -->
                  <div class="form-group mb-4">
    <label class="form-label fw-bold">Company Logo</label>
    <div class="logo-upload-wrapper position-relative" style="max-width: 200px;">
        <!-- Preview -->
        @if ($logo)
            <div class="logo-preview border rounded-circle overflow-hidden position-relative"
                 style="width: 150px; height: 150px;">
                <img src="{{ $logo->temporaryUrl() }}" alt="Logo Preview" class="w-100 h-100 object-fit-cover">
                <div class="overlay position-absolute top-0 start-0 w-100 h-100 d-flex justify-content-center align-items-center"
                     style="background: rgba(0,0,0,0.4); color: #fff; opacity:0; transition: opacity 0.3s; cursor:pointer;"
                     onclick="document.getElementById('logoInput').click()">
                    Change
                </div>
            </div>
        @else
            <div class="logo-placeholder border rounded-circle d-flex justify-content-center align-items-center"
                 style="width: 150px; height: 150px; cursor:pointer; background-color:#f0f0f0;"
                 onclick="document.getElementById('logoInput').click()">
                <i class="fa fa-camera fa-2x text-secondary"></i>
            </div>
        @endif

        <!-- File Input (hidden) -->
        <input type="file" id="logoInput" wire:model="logo" accept="image/*" class="d-none">

        @error('logo')
            <span class="error-msg text-danger d-block mt-2">{{ $message }}</span>
        @enderror
    </div>
</div>

<!-- Optional: Add hover effect via CSS -->
<style>
    .logo-preview:hover .overlay {
        opacity: 1;
    }
</style>


                    <div class="form-actions">
                        <button type="submit" class="btn-primary" wire:loading.attr="disabled">
                            <span wire:loading.remove>Save ➡</span>
                            <span wire:loading>Saving...</span>
                        </button>
                    </div>
                </form>

            </div>
        </div>
    </div>
@endif


        @if ($registerd)
            <!-- Quick Stats -->
            <div class="quick-stats">
                <div class="stat-card applications">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value">42</div>
                            <div class="stat-label">New Applications</div>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-file-alt"></i>
                        </div>
                    </div>
                    <div class="stat-trend">+12% from last week</div>
                </div>

                <div class="stat-card views">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value">1,248</div>
                            <div class="stat-label">Profile Views</div>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-eye"></i>
                        </div>
                    </div>
                    <div class="stat-trend">+23% from last week</div>
                </div>

                <div class="stat-card hires">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value">8</div>
                            <div class="stat-label">Total Hires</div>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-user-check"></i>
                        </div>
                    </div>
                    <div class="stat-trend">+2 this month</div>
                </div>

                <div class="stat-card jobs">
                    <div class="stat-header">
                        <div>
                            <div class="stat-value">15</div>
                            <div class="stat-label">Active Jobs</div>
                        </div>
                        <div class="stat-icon">
                            <i class="fas fa-briefcase"></i>
                        </div>
                    </div>
                    <div class="stat-trend">3 ending soon</div>
                </div>
            </div>

            <!-- Dashboard Content -->
            <div class="dashboard-content">
                <div class="main-column">
                    <!-- Recent Applications -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Recent Applications</h3>
                            <a href="#" class="view-all">View All <i class="fas fa-chevron-right"></i></a>
                        </div>

                        <div class="applications-list">
                            <div class="application-item">
                                <div class="appl-content">
                                    <h4>Sarah Johnson</h4>
                                    <p>Senior UX Designer</p>
                                </div>
                                <div class="appl-time">2 hours ago</div>
                                <div class="appl-actions">
                                    <button class="btn btn-primary">View</button>
                                    <button class="btn btn-outline">Message</button>
                                </div>
                            </div>

                            <div class="application-item">
                                <div class="appl-content">
                                    <h4>Michael Chen</h4>
                                    <p>Frontend Developer</p>
                                </div>
                                <div class="appl-time">Yesterday</div>
                                <div class="appl-actions">
                                    <button class="btn btn-primary">View</button>
                                    <button class="btn btn-outline">Message</button>
                                </div>
                            </div>

                            <div class="application-item">
                                <div class="appl-content">
                                    <h4>Emma Wilson</h4>
                                    <p>Product Manager</p>
                                </div>
                                <div class="appl-time">2 days ago</div>
                                <div class="appl-actions">
                                    <button class="btn btn-primary">View</button>
                                    <button class="btn btn-outline">Message</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Job Postings -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Your Job Postings</h3>
                            <a href="#" class="view-all">View All <i class="fas fa-chevron-right"></i></a>
                        </div>

                        <div class="job-listings">
                            @if ($createdjobslist)
                                @foreach ($createdjobslist as $job)
                                    <div class="job-item">
                                        <h4 class="job-title">{{ $job->job_title ?? 'N/A' }}</h4>
                                        <div class="job-details">
                                            <span>{{ $job->job_type ?? 'N/A' }}</span>
                                            <span>{{ $job->workplace_option ?? 'N/A' }}</span>
                                            @if ($job->salary_type == 'range')
                                                <span>${{ $job->min_salary ?? 0 }} - ${{ $job->max_salary ?? 0 }}</span>
                                            @else
                                                <span>Fixed Price</span>
                                            @endif

                                        </div>
                                        <div class="job-meta">
                                            <div class="applicant-count">24 Applicants</div>

                                            <div class="status-toggle">
                                                <label class="switch">
                                                    <input type="checkbox"
                                                        wire:click="toggleStatus({{ $job->id }})"
                                                        {{ $job->status == 'published' ? 'checked' : '' }}>
                                                    <span class="slider round"></span>
                                                </label>
                                                <span
                                                    class="status {{ $job->status == 'published' ? 'status-active' : 'status-closed' }}">
                                                    {{ $job->status == 'published' ? 'Active' : 'Deactive' }}
                                                </span>

                                            </div>
                                        </div>

                                    </div>
                                @endforeach
                            @endif





                        </div>
                    </div>
                </div>

                <div class="side-column">
                    <!-- Quick Actions -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Quick Actions</h3>
                        </div>

                        <div class="quick-actions-grid">
                            <div class="action-btn">
                                <i class="fas fa-briefcase"></i>
                                <span>Post a Job</span>
                            </div>
                            <div class="action-btn">
                                <i class="fas fa-search"></i>
                                <span>Find Candidates</span>
                            </div>
                            <div class="action-btn">
                                <i class="fas fa-calendar-alt"></i>
                                <span>Schedule Interview</span>
                            </div>
                            <div class="action-btn">
                                <i class="fas fa-file-alt"></i>
                                <span>Reports</span>
                            </div>
                        </div>
                    </div>

                    <!-- Upcoming Interviews -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Upcoming Interviews</h3>
                            <a href="#" class="view-all">View All <i class="fas fa-chevron-right"></i></a>
                        </div>

                        <div class="interviews-list">
                            <div class="application-item">
                                <div class="appl-content">
                                    <h4>Interview with Sarah Johnson</h4>
                                    <p>Today, 3:00 PM - Zoom</p>
                                </div>
                            </div>

                            <div class="application-item">
                                <div class="appl-content">
                                    <h4>Interview with Michael Chen</h4>
                                    <p>Tomorrow, 10:30 AM - Office</p>
                                </div>
                            </div>

                            <div class="application-item">
                                <div class="appl-content">
                                    <h4>Interview with Emma Wilson</h4>
                                    <p>Jun 12, 2:00 PM - Google Meet</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </main>



    <script>
        // Simple JavaScript for interactivity
        document.addEventListener('DOMContentLoaded', function() {
            // Navigation menu click handling
            const navItems = document.querySelectorAll('.nav-item');
            navItems.forEach(item => {
                item.addEventListener('click', function() {
                    navItems.forEach(i => i.classList.remove('active'));
                    this.classList.add('active');
                });
            });

            // Quick action buttons
            const actionButtons = document.querySelectorAll('.action-btn');
            actionButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const action = this.querySelector('span').textContent;
                    alert(`You selected: ${action}`);
                });
            });

            // Application buttons
            const applButtons = document.querySelectorAll('.appl-actions .btn');
            applButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const action = this.textContent;
                    const applicant = this.closest('.application-item').querySelector('h4')
                        .textContent;
                    alert(`You chose to ${action} ${applicant}'s application`);
                });
            });
        });
    </script>
    <style>
        :root {
            --primary: #4361ee;
            --secondary: #3a0ca3;
            --accent: #f72585;
            --light: #f8f9fa;
            --dark: #212529;
            --success: #4cc9f0;
            --warning: #f9c74f;
            --danger: #f94144;
            --gray: #adb5bd;
            --light-gray: #e9ecef;
            --card-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            --smooth-transition: all 0.3s ease;
        }

        .switch {
            position: relative;
            display: inline-block;
            width: 50px;
            height: 26px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: .4s;
            border-radius: 34px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 18px;
            width: 18px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            transition: .4s;
            border-radius: 50%;
        }

        input:checked+.slider {
            background-color: #28a745;
            /* green */
        }

        input:checked+.slider:before {
            transform: translateX(24px);
        }

        .status-label {
            margin-left: 10px;
            font-weight: bold;
        }

        .form-title {
            font-size: 26px;
            font-weight: 700;
            text-align: center;
            margin-bottom: 30px;
            color: #333;
        }

        .form-title {
            font-size: 26px;
            font-weight: 700;
            text-align: center;
            margin-bottom: 30px;
            color: #333;
        }

        /* Layout */
        .form-container {
            display: flex;
            gap: 50px;
        }

        /* Steps */
        .form-steps {
            flex: 1;
            position: relative;
            display: flex;
            flex-direction: column;
            gap: 40px;
            padding-right: 30px;
        }

        .step {
            font-size: 15px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 12px;
            color: #888;
            position: relative;
        }

        .step .icon {
            font-size: 16px;
            width: 40px;
            /* fixed size */
            height: 40px;
            display: flex;
            /* center icon */
            align-items: center;
            justify-content: center;
            background: #eee;
            border-radius: 50%;
            /* perfect circle */
            transition: 0.3s;
            color: #555;
        }

        .step.active .icon {
            background: linear-gradient(135deg, #4a6cf7, #657eed);
            color: #fff;
            box-shadow: 0 4px 10px rgba(74, 108, 247, 0.3);
        }


        .progress-line {
            position: absolute;
            left: 16px;
            top: 30px;
            bottom: 0;
            width: 3px;
            background: linear-gradient(to bottom, #4a6cf7, #a5b7ff);
            border-radius: 2px;
            z-index: -1;
        }

        /* Form Fields */
        .form-fields {
            flex: 2;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            margin-bottom: 6px;
            font-weight: 600;
            color: #444;
        }

        .form-group input,
        .form-group textarea {
            width: 100%;
            padding: 12px 14px;
            border: 1px solid #ccc;
            border-radius: 10px;
            font-size: 14px;
            transition: all 0.3s;
            background: #fafafa;
        }

        .form-group input:focus,
        .form-group textarea:focus {
            border-color: #4a6cf7;
            box-shadow: 0 0 8px rgba(74, 108, 247, 0.3);
            background: white;
            outline: none;
        }

        textarea {
            min-height: 90px;
            resize: vertical;
        }

        /* Buttons */
        .form-actions {
            display: flex;
            justify-content: flex-end;
            gap: 15px;
            margin-top: 30px;
        }

        .btn-primary {
            background: linear-gradient(135deg, #4a6cf7, #657eed);
            color: white;
            border: none;
            padding: 12px 28px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
        }

        .btn-secondary {
            background: #f0f0f0;
            color: #444;
            border: none;
            padding: 12px 28px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
            transition: background 0.3s;
        }

        .btn-secondary:hover {
            background: #ddd;
        }


        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: #f8f9fa;
            color: #333;
            line-height: 1.6;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 20px;
        }



        .nav-menu {
            display: flex;
            gap: 5px;
        }

        .nav-item {
            padding: 10px 20px;
            border-radius: 20px;
            font-weight: 500;
            cursor: pointer;
            transition: var(--smooth-transition);
        }

        .nav-item:hover,
        .nav-item.active {
            background: var(--primary);
            color: white;
        }

        .user-actions {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .search-box {
            display: flex;
            align-items: center;
            background: var(--light-gray);
            border-radius: 20px;
            padding: 8px 15px;
        }

        .search-box input {
            border: none;
            background: transparent;
            padding: 5px;
            width: 180px;
            outline: none;
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 10px;
            cursor: pointer;
        }

        .user-profile img {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--primary);
        }

        /* Welcome Banner */
        .welcome-banner {
            background: linear-gradient(120deg, var(--primary), var(--secondary));
            color: white;
            border-radius: 12px;
            padding: 25px;
            margin: 30px 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .welcome-content h1 {
            font-size: 28px;
            margin-bottom: 10px;
        }

        .welcome-content p {
            opacity: 0.9;
            max-width: 600px;
        }

        .welcome-cta {
            background: white;
            color: var(--primary);
            border: none;
            padding: 12px 25px;
            border-radius: 30px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--smooth-transition);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .welcome-cta:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.15);
        }

        /* Quick Stats */
        .quick-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 20px;
            box-shadow: var(--card-shadow);
            display: flex;
            flex-direction: column;
            transition: var(--smooth-transition);
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.12);
        }

        .stat-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
        }

        .applications .stat-icon {
            background: rgba(67, 97, 238, 0.15);
            color: var(--primary);
        }

        .views .stat-icon {
            background: rgba(76, 201, 240, 0.15);
            color: var(--success);
        }

        .hires .stat-icon {
            background: rgba(249, 65, 68, 0.15);
            color: var(--danger);
        }

        .jobs .stat-icon {
            background: rgba(249, 199, 79, 0.15);
            color: var(--warning);
        }

        .stat-value {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 5px;
        }

        .stat-label {
            color: var(--gray);
            font-size: 14px;
            font-weight: 500;
        }

        /* Main Dashboard Content */
        .dashboard-content {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: 25px;
            margin-bottom: 40px;
        }

        .main-column,
        .side-column {
            display: flex;
            flex-direction: column;
            gap: 25px;
        }

        .card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: var(--card-shadow);
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .card-title {
            font-size: 18px;
            font-weight: 600;
            color: var(--dark);
        }

        .view-all {
            color: var(--primary);
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 5px;
        }

        /* Applications Card */
        .application-item {
            display: flex;
            align-items: center;
            padding: 15px 0;
            border-bottom: 1px solid var(--light-gray);
        }

        .application-item:last-child {
            border-bottom: none;
        }

        .appl-content {
            flex: 1;
        }

        .appl-content h4 {
            font-size: 16px;
            margin-bottom: 5px;
        }

        .appl-content p {
            font-size: 14px;
            color: var(--gray);
        }

        .appl-time {
            font-size: 12px;
            color: var(--gray);
        }

        .appl-actions {
            display: flex;
            gap: 10px;
        }

        .error-msg {
            color: #f94144;
            font-size: 13px;
            margin-top: 5px;
            display: block;
        }

        .btn {
            padding: 8px 15px;
            border-radius: 6px;
            border: none;
            font-weight: 500;
            cursor: pointer;
            transition: var(--smooth-transition);
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-outline {
            background: transparent;
            border: 1px solid var(--primary);
            color: var(--primary);
        }

        /* Job Listings */
        .job-item {
            padding: 15px 0;
            border-bottom: 1px solid var(--light-gray);
        }

        .job-item:last-child {
            border-bottom: none;
        }

        .job-title {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .job-details {
            display: flex;
            gap: 15px;
            font-size: 14px;
            color: var(--gray);
            margin-bottom: 10px;
        }

        .job-meta {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .applicant-count {
            font-size: 14px;
            color: var(--primary);
            font-weight: 500;
        }

        .status {
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
        }

        .status-active {
            background: rgba(76, 201, 240, 0.15);
            color: var(--success);
        }

        .status-closed {
            background: rgba(249, 65, 68, 0.15);
            color: var(--danger);
        }

        /* Quick Actions */
        .quick-actions-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }

        .action-btn {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            background: var(--light);
            border-radius: 10px;
            padding: 20px 15px;
            text-align: center;
            cursor: pointer;
            transition: var(--smooth-transition);
        }

        .action-btn:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-3px);
        }

        .action-btn i {
            font-size: 24px;
            margin-bottom: 10px;
        }

        .action-btn span {
            font-size: 14px;
            font-weight: 500;
        }

        /* Footer */
        footer {
            background: white;
            padding: 20px 0;
            text-align: center;
            color: var(--gray);
            font-size: 14px;
            margin-top: 40px;
            border-top: 1px solid var(--light-gray);
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .dashboard-content {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                gap: 15px;
            }

            .nav-menu {
                order: 3;
                width: 100%;
                overflow-x: auto;
                padding-bottom: 10px;
            }

            .welcome-banner {
                flex-direction: column;
                text-align: center;
                gap: 20px;
            }



            .quick-stats {
                grid-template-columns: repeat(2, 1fr);
            }

            .quick-actions-grid {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 480px) {
            .quick-stats {
                grid-template-columns: 1fr;
            }

            .user-actions {
                flex-direction: column;
                gap: 10px;
            }

            .search-box {
                width: 100%;
            }
        }
    </style>
</div>
