<div>
    <div class="d-flex justify-content-center align-items-center vh-100 bg-light">
    <div class="card shadow-lg p-4" style="width: 400px; border-radius: 15px;">
        <h3 class="text-center mb-4">Admin Login</h3>

        @if ($errorMessage)
            <div class="alert alert-danger">{{ $errorMessage }}</div>
        @endif

        <form wire:submit.prevent="login">
            <div class="mb-3">
                <label for="email" class="form-label fw-semibold">Email</label>
                <input type="email" wire:model.defer="email" id="email" class="form-control" placeholder="Enter email" />
                @error('email') <span class="text-danger small">{{ $message }}</span> @enderror
            </div>

            <div class="mb-3">
                <label for="password" class="form-label fw-semibold">Password</label>
                <input type="password" wire:model.defer="password" id="password" class="form-control" placeholder="Enter password" />
                @error('password') <span class="text-danger small">{{ $message }}</span> @enderror
            </div>

            <div class="form-check mb-3" hidden>
                <input class="form-check-input" type="checkbox" wire:model="remember" id="remember">
                <label class="form-check-label" for="remember">
                    Remember me
                </label>
            </div>

            <button type="submit" class="btn btn-primary w-100">Login</button>
        </form>
    </div>
</div>

</div>
