<div>
        <div class="container">
        <div class="page-inner">
            <div class="page-header">
                <h3 class="fw-bold mb-3">Job Category Dashboard</h3>
                <ul class="breadcrumbs mb-3">
                    <li class="nav-home">
                        <a href="#">
                            <i class="fas fa-home icon-home"></i>
                        </a>
                    </li>
                    <li class="separator">
                        <i class="fas fa-chevron-right icon-arrow-right"></i>
                    </li>
                    <li class="nav-item">
                        <a href="#">Dashboard</a>
                    </li>
                    <li class="separator">
                        <i class="fas fa-chevron-right icon-arrow-right"></i>
                    </li>
                    <li class="nav-item">
                        <a href="#">Job Categories</a>
                    </li>
                </ul>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">Create Job Category</div>
                        </div>
                        <div class="card-body">
                            <form id="categoryForm">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="categoryName">Category Name</label>
                                            <input
                                                type="text"
                                                class="form-control"
                                                id="categoryName"
                                                placeholder="Enter Category Name"
                                                required
                                            />
                                        </div>
                                         </div>
                                         <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="categoryImage">Category Image</label>
                                            <input
                                                type="file"
                                                class="form-control"
                                                id="categoryImage"
                                                accept="image/*"
                                            />
                                            <div class="image-preview mt-2" id="imagePreview">
                                                <span class="text-muted">Image Preview</span>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </form>
                        </div>
                        <div class="card-action">
                            <button type="submit" form="categoryForm" class="btn btn-success">Submit</button>
                            <button type="reset" form="categoryForm" class="btn btn-danger">Cancel</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">Job Categories</div>
                        </div>
                        <div class="card-body">
                            <table id="categoriesTable" class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Image</th>
                                        <th>Category Name</th>
                                        <th>Slug</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td><img src="https://via.placeholder.com/50" class="category-image" alt="Technology"></td>
                                        <td>Technology</td>
                                        <td>Jobs related to IT, software development, and tech services</td>
                                        <td><span class="badge bg-success">Active</span></td>
                                        <td class="action-buttons">
                                            <button class="btn btn-sm btn-primary"><i class="fas fa-edit"></i></button>
                                            <button class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td><img src="https://via.placeholder.com/50" class="category-image" alt="Healthcare"></td>
                                        <td>Healthcare</td>
                                        <td>Medical, nursing, and healthcare related positions</td>
                                        <td><span class="badge bg-success">Active</span></td>
                                        <td class="action-buttons">
                                            <button class="btn btn-sm btn-primary"><i class="fas fa-edit"></i></button>
                                            <button class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></button>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>3</td>
                                        <td><img src="https://via.placeholder.com/50" class="category-image" alt="Education"></td>
                                        <td>Education</td>
                                        <td>Teaching, academic, and educational roles</td>
                                        <td><span class="badge bg-warning">Inactive</span></td>
                                        <td class="action-buttons">
                                            <button class="btn btn-sm btn-primary"><i class="fas fa-edit"></i></button>
                                            <button class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <script>
        $(document).ready(function() {
            // Initialize DataTable
            $('#categoriesTable').DataTable({
                "pageLength": 10,
                "responsive": true
            });

            // Image preview functionality
            $('#categoryImage').change(function() {
                const file = this.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        $('#imagePreview').html(`<img src="${e.target.result}" alt="Preview">`);
                    }
                    reader.readAsDataURL(file);
                }
            });

            // Form submission
            $('#categoryForm').on('submit', function(e) {
                e.preventDefault();

                // Get form values
                const categoryName = $('#categoryName').val();
                const categoryDescription = $('#categoryDescription').val();
                const categoryImage = $('#categoryImage')[0].files[0];

                // Simple validation
                if (!categoryName) {
                    alert('Please enter a category name');
                    return;
                }

                // In a real application, you would send this data to the server
                // For this demo, we'll just log it and show a success message
                console.log({
                    categoryName,
                    categoryDescription,
                    categoryImage: categoryImage ? categoryImage.name : 'No image selected'
                });

                alert('Category created successfully!');

                // Reset form
                $('#categoryForm')[0].reset();
                $('#imagePreview').html('<span class="text-muted">Image Preview</span>');
            });
        });
    </script>
</div>
