<div>
    <div class="container py-2">
        <div class="page-inner">

            @if (session()->has('message'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('message') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif

            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">
                                {{ $editingId ? 'Edit Job Category' : 'Create Job Category' }}
                            </div>
                        </div>
                        <div class="card-body">
                            <form wire:submit.prevent="saveCategory">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="categoryName">Category Name</label>
                                            <input type="text"
                                                class="form-control @error('name') is-invalid @enderror"
                                                id="categoryName" placeholder="Enter Category Name" wire:model="name"
                                                required />
                                            @error('name')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="categoryDescription">Description</label>
                                            <textarea class="form-control @error('description') is-invalid @enderror" id="categoryDescription"
                                                placeholder="Enter Category Description" wire:model="description" rows="1"></textarea>
                                            @error('description')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="categoryImage">Category Image</label>
                                            <input type="file"
                                                class="form-control @error('image') is-invalid @enderror"
                                                id="categoryImage" accept="image/*" wire:model="image" />
                                            @error('image')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror

                                            @if ($image)
                                                <div class="image-preview mt-2">
                                                    <img src="{{ $image->temporaryUrl() }}" alt="Preview"
                                                        style="max-width: 100px; max-height: 100px;">
                                                    <div class="text-muted small mt-1">Image Preview</div>
                                                </div>
                                            @elseif($editingId)
                                                @php
                                                    $currentCategory = \App\Models\JobCategory::find($editingId);
                                                @endphp
                                                @if ($currentCategory && $currentCategory->image)
                                                    <div class="image-preview mt-2">
                                                        <img src="{{ $currentCategory->image_url }}" alt="Current Image"
                                                            style="max-width: 100px; max-height: 100px;">
                                                        <div class="text-muted small mt-1">Current Image</div>
                                                    </div>
                                                @else
                                                    <div class="image-preview mt-2">
                                                        <span class="text-muted">No image uploaded</span>
                                                    </div>
                                                @endif
                                            @else
                                                <div class="image-preview mt-2">
                                                    <span class="text-muted">Image Preview</span>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="categoryStatus">Status</label>
                                            <select class="form-control @error('status') is-invalid @enderror"
                                                id="categoryStatus" wire:model="status">
                                                <option value="1">Active</option>
                                                <option value="0">Inactive</option>
                                            </select>
                                            @error('status')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                       <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="base">Base</label>
                                            <select class="form-control @error('base') is-invalid @enderror"
                                                id="base" wire:model="base">
                                                <option >Choose base</option>
                                                <option value="com">.com</option>
                                                <option value="au">.au</option>
                                                <option value="lk">.lk</option>
                                                <option value="nz">.nz</option>
                                            </select>
                                            @error('status')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="card-action">
                            <button type="submit" wire:click="saveCategory" class="btn btn-success">
                                {{ $editingId ? 'Update' : 'Submit' }}
                            </button>
                            @if ($editingId)
                                <button type="button" wire:click="resetForm" class="btn btn-secondary">Cancel</button>
                            @else
                                <button type="reset" wire:click="resetForm" class="btn btn-danger">Cancel</button>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-4">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">Job Categories</div>
                        </div>
                        <div class="card-body">
                            <table id="categoriesTable" class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Image</th>
                                        <th>Category Name</th>
                                        <th>Slug</th>
                                        <th>Description</th>
                                        <th>Base</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($categories as $category)
                                        <tr>
                                            <td>{{ $category->id }}</td>
                                            <td>
                                                <img src="{{ asset('job-categories/' . $category->image) }}"
                                                    class="category-image" alt="{{ $category->name }}"
                                                    style="width: 50px; height: 50px; object-fit: cover; border-radius: 4px;">

                                            </td>
                                            <td>{{ $category->name }}</td>
                                            <td>{{ $category->slug }}</td>
                                            <td>{{ $category->description ?? 'N/A' }}</td>
                                             <td>{{ $category->base ?? 'N/A' }}</td>
                                            <td>
                                                <span class="badge bg-{{ $category->status_badge }}">
                                                    {{ $category->status_text }}
                                                </span>
                                            </td>
                                            <td class="action-buttons">
                                                <button class="btn btn-sm btn-primary"
                                                    wire:click="editCategory({{ $category->id }})" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <button class="btn btn-sm btn-danger"
                                                    wire:click="deleteCategory({{ $category->id }})"
                                                    wire:confirm="Are you sure you want to delete this category?"
                                                    title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" class="text-center">No categories found.</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            $(document).ready(function() {
                // Initialize DataTable
                $('#categoriesTable').DataTable({
                    "pageLength": 10,
                    "responsive": true,
                    "columnDefs": [{
                            "orderable": true,
                            "targets": [0, 2, 5]
                        },
                        {
                            "orderable": false,
                            "targets": [1, 3, 4, 6]
                        }
                    ]
                });
            });

            // Image preview for file input
            document.addEventListener('livewire:initialized', () => {
                const categoryImage = document.getElementById('categoryImage');
                if (categoryImage) {
                    categoryImage.addEventListener('change', function() {
                        const file = this.files[0];
                        if (file) {
                            const reader = new FileReader();
                            reader.onload = function(e) {
                                const preview = document.querySelector('#categoryImage ~ .image-preview');
                                if (preview) {
                                    preview.innerHTML = `<img src="${e.target.result}" alt="Preview" style="max-width: 100px; max-height: 100px;">
                                <div class="text-muted small mt-1">Image Preview</div>`;
                                }
                            }
                            reader.readAsDataURL(file);
                        }
                    });
                }
            });
        </script>
    @endpush
</div>
