<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SKILLPOTS - Fixed Header</title>
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Phosphor Icons -->
    <link rel="stylesheet" href="https://unpkg.com/@phosphor-icons/web@2.0.3/src/regular/style.css" />
<link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://cdnjs.cloudflare.com">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-LN+7fdVzj6u52u30Kp6M/trliBMCMKTyK833zpbD+pXdCLuTusPj697FH4R/5mcr" crossorigin="anonymous">
 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Tailwind CSS -->
    <script src="https://cdn.jsdelivr.net/npm/@tailwindcss/browser@4"></script>



    <!-- Custom Stylesheets (loaded after frameworks to override) -->
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/recruiters.css') }}">

</head>
<body>
  <header class="header" id="header">
    <!-- Logo -->

     <a href="{{ route('skillpot.home') }}" class="logo">
        <img src="{{ asset('images/logo.jpeg') }}" alt="SKILLPOTS" class="logo-image">
        <span class="logo-text" style="color: #002B66">SKILLPOTS</span>
    </a>
    <!-- Navigation -->
    <nav class="nav" id="nav">
        <a href="#">Home</a>
      <a href="#">Job Search</a>
      <a href="#">Profile</a>
      <a href="#">Career advice</a>
       <a href="#">Explore Companies</a>
      <a href="#">Contact us</a>


      <!-- Mobile buttons (visible only in mobile view) -->

    </nav>

    <!-- Buttons -->
    <div class="header-buttons">
      <button class="btn btn-green"><i class="ph ph-sign-in"></i> Login</button>
    </div>

    <!-- Mobile menu toggle -->
    <button class="menu-toggle" id="menuToggle">
      <span></span>
      <span></span>
      <span></span>
    </button>
  </header>


        <main id="main-content" class="main">
        @yield('content')

    </main>
 <footer class="footer">
        <div class="footer-container">
            <div class="footer-content">
                <div class="footer-brand">
                    <div class="footer-logo">
                        <span class="footer-logo-text">SKILLPOTS</span>
                    </div>
                    <p class="footer-description">
                        Find your dream job or hire the best talent with our AI-powered platform.
                    </p>
                    <div class="footer-social">
                        <a href="#" class="social-icon" aria-label="Facebook">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="#" class="social-icon" aria-label="Twitter">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="#" class="social-icon" aria-label="LinkedIn">
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                        <a href="#" class="social-icon" aria-label="Instagram">
                            <i class="fab fa-instagram"></i>
                        </a>
                    </div>
                </div>

                <div class="footer-column">
                    <h3>Job Seekers</h3>
                    <ul class="footer-links">
                        <li><a href="#">Job Search</a></li>
                        <li><a href="#">Profile</a></li>
                        <li><a href="#">Saved Jobs</a></li>
                        <li><a href="#">Applications</a></li>
                        <li><a href="#">Resources</a></li>
                    </ul>
                </div>

                <div class="footer-column">
                    <h3>Employers</h3>
                    <ul class="footer-links">
                        <li><a href="#">Free Register</a></li>
                        <li><a href="#">Post a Job</a></li>
                        <li><a href="#">Search Candidates</a></li>
                        <li><a href="#">Pricing Plans</a></li>
                        <li><a href="#">Dashboard</a></li>
                    </ul>
                </div>

                <div class="footer-column">
                    <h3>Quick Links</h3>
                    <ul class="footer-links">
                        <li><a href="#">How It Works</a></li>
                        <li><a href="#">About Us</a></li>
                        <li><a href="#">Blog</a></li>
                        <li><a href="#">FAQ</a></li>
                        <li><a href="#">Support</a></li>
                    </ul>
                </div>

                <div class="footer-column footer-contact">
                    <h3>Contact Us</h3>
                    <p><i class="fas fa-envelope"></i> skillpots@gmail.com</p>
                    <p><i class="fas fa-phone"></i> +1 (555) 123-4567</p>
                    <p><i class="fas fa-map-marker-alt"></i> 123 Main St, City, Country</p>
                </div>
            </div>

            <div class="footer-bottom">
                <p>Copyright © 2025 Skillpots | Design by SATASME</p>
            </div>
        </div>
    </footer>



</body>
</html>
