@extends('layouts.app')
@section('title', 'SKILLPOTS - Find Your Dream Job')
@section('content')
    <!-- Hero Section -->

    <livewire:web.index.modal.signinmodal />
    <livewire:web.index.modal.signupmodal />
    <main >

        <div class="hero-section" style="background-color: #0e636b">
            <div class="container" style="background-color: #0e636b">
                <h1>AI-Powered Career Matching</h1>
                <p class="subtitle">Harness the power of Artificial Intelligence to connect world-class talent with top
                    employers</p>

                <div class="search-container">
                    <input type="text" class="search-input" placeholder="Search jobs, skills, or companies...">
                    <button class="search-btn">Search</button>
                </div>

                <div class="action-buttons">
                    <button class="btn btn-secondary">Post a Job</button>
                    <button class="btn btn-secondary">Find Jobs</button>
                </div>

                <div class="features">
                    <div class="feature-item">Smart recommendations</div>
                    <div class="feature-item">Faster hiring</div>
                    <div class="feature-item">Better matches</div>
                </div>
            </div>
        </div>

        <!-- Hero End -->

        <!-- Featured Categories -->
        <section class="pt-80">
            <div class="container-fluid">

                <livewire:web.index.home.categorycomponent />
            </div>
        </section>
        <!-- Featured Categories End -->

        <!-- Services Start -->
        <section class="services-filter py-80">
            <div class="container-fluid">
                <div class="row mb-40 justify-content-between align-items-end">
                    <div class="col-auto">
                        <h2 class="fw-bold section-title">Latest Job</h2>
                        <p class="section-desc">Get some Inspirations from 86K+ skills</p>
                    </div>
                    <div class="col-auto mt-30 mt-md-0">
                        <div class="filters-btns d-flex flex-wrap align-items-center gap-3">
                            <button class="service-filter-btn active" data-filter="*">
                                All
                            </button>
                            <button class="service-filter-btn" data-filter=".app">
                                App Design
                            </button>
                            <button class="service-filter-btn" data-filter=".website">
                                Website
                            </button>
                            <button class="service-filter-btn" data-filter=".logo">
                                Logo
                            </button>
                            <button class="service-filter-btn" data-filter=".vcard">
                                Card Design
                            </button>

                        </div>
                    </div>
                </div>
                <div class="row grid">
                    <article class="col-xl-4 col-md-6 mb-4 grid-item website">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>

                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="HCL Technologies" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">HCL Technologies</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Remote</span>
                                                <span class="badge urgent">Urgent</span>
                                            </div>
                                        </div>
                                    </div>

                                    <button class="save-job-btn" data-job-id="123">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Senior Software Engineer</a>
                                </h3>

                                <p class="job-excerpt">We're looking for an experienced engineer to lead our platform
                                    development team...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon" title="JavaScript">JS</span>
                                        <span class="tech-icon" title="Python">PY</span>
                                        <span class="tech-icon" title="Cloud">☁️</span>
                                    </div>
                                    <span class="experience-level">5+ years</span>
                                </div>

                                <div class="job-meta">
                                    <div class="tech-stack">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Sydney</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-briefcase"></i>
                                            <span>Full-time</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-calendar"></i>
                                            <span>Posted 2d ago</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now">Apply Now</button>
                                    <button class="btn-view-details">View Details</button>
                                </div>
                            </div>

                            <div class="glass-reflection"></div>
                        </div>
                    </article>

                    <article class="col-xl-4 col-md-6 mb-4 grid-item website">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>

                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="HCL Technologies" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">HCL Technologies</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Remote</span>
                                                <span class="badge urgent">Urgent</span>
                                            </div>
                                        </div>
                                    </div>

                                    <button class="save-job-btn" data-job-id="123">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Senior Software Engineer</a>
                                </h3>

                                <p class="job-excerpt">We're looking for an experienced engineer to lead our platform
                                    development team...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon" title="JavaScript">JS</span>
                                        <span class="tech-icon" title="Python">PY</span>
                                        <span class="tech-icon" title="Cloud">☁️</span>
                                    </div>
                                    <span class="experience-level">5+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Sydney</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-briefcase"></i>
                                            <span>Full-time</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-calendar"></i>
                                            <span>Posted 2d ago</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now">Apply Now</button>
                                    <button class="btn-view-details">View Details</button>
                                </div>
                            </div>

                            <div class="glass-reflection"></div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4 grid-item website">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>

                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="HCL Technologies" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">HCL Technologies</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Remote</span>
                                                <span class="badge urgent">Urgent</span>
                                            </div>
                                        </div>
                                    </div>

                                    <button class="save-job-btn" data-job-id="123">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Senior Software Engineer</a>
                                </h3>

                                <p class="job-excerpt">We're looking for an experienced engineer to lead our platform
                                    development team...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon" title="JavaScript">JS</span>
                                        <span class="tech-icon" title="Python">PY</span>
                                        <span class="tech-icon" title="Cloud">☁️</span>
                                    </div>
                                    <span class="experience-level">5+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Sydney</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-briefcase"></i>
                                            <span>Full-time</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-calendar"></i>
                                            <span>Posted 2d ago</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now">Apply Now</button>
                                    <button class="btn-view-details">View Details</button>
                                </div>
                            </div>

                            <div class="glass-reflection"></div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4 grid-item website">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>

                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="HCL Technologies" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">HCL Technologies</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Remote</span>
                                                <span class="badge urgent">Urgent</span>
                                            </div>
                                        </div>
                                    </div>

                                    <button class="save-job-btn" data-job-id="123">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Senior Software Engineer</a>
                                </h3>

                                <p class="job-excerpt">We're looking for an experienced engineer to lead our platform
                                    development team...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon" title="JavaScript">JS</span>
                                        <span class="tech-icon" title="Python">PY</span>
                                        <span class="tech-icon" title="Cloud">☁️</span>
                                    </div>
                                    <span class="experience-level">5+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Sydney</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-briefcase"></i>
                                            <span>Full-time</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-calendar"></i>
                                            <span>Posted 2d ago</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now">Apply Now</button>
                                    <button class="btn-view-details">View Details</button>
                                </div>
                            </div>

                            <div class="glass-reflection"></div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4 grid-item website">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>

                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="HCL Technologies" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">HCL Technologies</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Remote</span>
                                                <span class="badge urgent">Urgent</span>
                                            </div>
                                        </div>
                                    </div>

                                    <button class="save-job-btn" data-job-id="123">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Senior Software Engineer</a>
                                </h3>

                                <p class="job-excerpt">We're looking for an experienced engineer to lead our platform
                                    development team...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon" title="JavaScript">JS</span>
                                        <span class="tech-icon" title="Python">PY</span>
                                        <span class="tech-icon" title="Cloud">☁️</span>
                                    </div>
                                    <span class="experience-level">5+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Sydney</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-briefcase"></i>
                                            <span>Full-time</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-calendar"></i>
                                            <span>Posted 2d ago</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now">Apply Now</button>
                                    <button class="btn-view-details">View Details</button>
                                </div>
                            </div>

                            <div class="glass-reflection"></div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4 grid-item website">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>

                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="HCL Technologies" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">HCL Technologies</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Remote</span>
                                                <span class="badge urgent">Urgent</span>
                                            </div>
                                        </div>
                                    </div>

                                    <button class="save-job-btn" data-job-id="123">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Senior Software Engineer</a>
                                </h3>

                                <p class="job-excerpt">We're looking for an experienced engineer to lead our platform
                                    development team...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon" title="JavaScript">JS</span>
                                        <span class="tech-icon" title="Python">PY</span>
                                        <span class="tech-icon" title="Cloud">☁️</span>
                                    </div>
                                    <span class="experience-level">5+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Sydney</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-briefcase"></i>
                                            <span>Full-time</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-calendar"></i>
                                            <span>Posted 2d ago</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now">Apply Now</button>
                                    <button class="btn-view-details">View Details</button>
                                </div>
                            </div>

                            <div class="glass-reflection"></div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4 grid-item website">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>

                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="HCL Technologies" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">HCL Technologies</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Remote</span>
                                                <span class="badge urgent">Urgent</span>
                                            </div>
                                        </div>
                                    </div>

                                    <button class="save-job-btn" data-job-id="123">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Senior Software Engineer</a>
                                </h3>

                                <p class="job-excerpt">We're looking for an experienced engineer to lead our platform
                                    development team...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon" title="JavaScript">JS</span>
                                        <span class="tech-icon" title="Python">PY</span>
                                        <span class="tech-icon" title="Cloud">☁️</span>
                                    </div>
                                    <span class="experience-level">5+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Sydney</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-briefcase"></i>
                                            <span>Full-time</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-calendar"></i>
                                            <span>Posted 2d ago</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now">Apply Now</button>
                                    <button class="btn-view-details">View Details</button>
                                </div>
                            </div>

                            <div class="glass-reflection"></div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4 grid-item website">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>

                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="HCL Technologies" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">HCL Technologies</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Remote</span>
                                                <span class="badge urgent">Urgent</span>
                                            </div>
                                        </div>
                                    </div>

                                    <button class="save-job-btn" data-job-id="123">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Senior Software Engineer</a>
                                </h3>

                                <p class="job-excerpt">We're looking for an experienced engineer to lead our platform
                                    development team...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon" title="JavaScript">JS</span>
                                        <span class="tech-icon" title="Python">PY</span>
                                        <span class="tech-icon" title="Cloud">☁️</span>
                                    </div>
                                    <span class="experience-level">5+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Sydney</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-briefcase"></i>
                                            <span>Full-time</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-calendar"></i>
                                            <span>Posted 2d ago</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now">Apply Now</button>
                                    <button class="btn-view-details">View Details</button>
                                </div>
                            </div>

                            <div class="glass-reflection"></div>
                        </div>
                    </article>
                </div>
                <div class="row justify-content-center mt-5">
                    <div class="col-auto">
                        <div>
                            <a href="services.html" class="w-btn-secondary-lg">View More
                                <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke="currentColor" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Services End -->

        <!-- Cta Start -->
        <section class="cta-area" hidden>
            <div class="container">
                <div class="bg-darkGreen cta-area-bg">
                    <div class="row align-items-center">
                        <div class="col-12 col-xl-7">
                            <div class="cta-content" data-aos="fade-up" data-aos-duration="1000"
                                data-aos-easing="linear">
                                <p class="cta-subtitle fw-bold mb-2">Explore New Life</p>
                                <h2 class="section-title-light fw-bold mb-4">
                                    Don’t just find. Be found put your CV in front of great
                                    employers
                                </h2>
                                <p class="section-desc-light mb-40">
                                    There are many variations of passages of Lorem Ipsum
                                    available, but the majority have suffered alteration in some
                                    form, by injected humour, or randomised words.
                                </p>
                                <a href="#" class="cta-btn-link">
                                    Job Post Now
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="10"
                                        viewBox="0 0 14 10" fill="none">
                                        <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                    </svg></a>
                            </div>
                            <div class="cta-counter mt-5">
                                <div class="cta-counter-item">
                                    <h3 class="cta-counter-title fw-bold">
                                        <span class="counter">950</span><span>M+</span>
                                    </h3>
                                    <p class="cta-counter-desc fw-bold">Total Jobseeker</p>
                                </div>
                                <div class="cta-counter-item">
                                    <h3 class="cta-counter-title fw-bold">
                                        <span class="counter">32</span><span>M+</span>
                                    </h3>
                                    <p class="cta-counter-desc fw-bold">Total Employer</p>
                                </div>
                                <div class="cta-counter-item">
                                    <h3 class="cta-counter-title fw-bold">
                                        <span class="counter">120</span><span>M+</span>
                                    </h3>
                                    <p class="cta-counter-desc fw-bold">Total Companies</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-xl-5 mt-5 mt-xl-0">
                            <div class="cta-img">
                                <img src="web/assets/img/cta/cta-img.png" class="img-fluid w-100" alt="" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Cta End -->

        <!-- Recent Job   -->
        <section class="py-70" hidden>
            <div class="container">
                <div class="row justify-content-between align-items-end mb-40">
                    <div class="col-auto">
                        <div>
                            <h2 class="fw-bold section-title">Recent Job Post</h2>
                            <p class="section-desc">
                                Get some Inspirations from 86K+ skills
                            </p>
                        </div>
                    </div>
                    <div class="col-auto mt-30 mt-md-0">
                        <div>
                            <a href="job-posts.html" class="w-btn-link">
                                View More
                                <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 9.77393L13 5.53583M13 5.53583L9 1.29774M13 5.53583L1 5.53583"
                                        stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <article class="col-xl-4 col-md-6 mb-4" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="job-post-horizontal align-items-center bg-offWhite d-flex gap-3">
                            <div class="job-post-horizontal-img">
                                <img src="web/assets/img/job/jp-1.png" alt="" />
                            </div>
                            <div class="flex-grow-1">
                                <div class="mb-3 d-flex gap-3 align-items-center">
                                    <p class="job-type-badge-primary">Urgent</p>
                                    <h4 class="job-price-range fw-medium">$100</h4>
                                </div>
                                <h3 class="job-post-horizontal-title fw-semibold mb-3">
                                    <a href="job-details.html">
                                        Software engineer for android Development...
                                    </a>
                                </h3>
                                <a href="job-details.html" class="w-btn-link">
                                    Apply Now
                                    <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 9.77393L13 5.53583M13 5.53583L9 1.29774M13 5.53583L1 5.53583"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="job-post-horizontal align-items-center d-flex gap-3 bg-offWhite">
                            <div class="job-post-horizontal-img">
                                <img src="web/assets/img/job/jp-2.png" alt="" />
                            </div>
                            <div class="flex-grow-1">
                                <div class="mb-3 d-flex gap-3 align-items-center">
                                    <p class="job-type-badge-primary">Urgent</p>
                                    <h4 class="job-price-range fw-medium">$25-$30</h4>
                                </div>
                                <h3 class="job-post-horizontal-title fw-semibold mb-3">
                                    <a href="job-details.html">
                                        Senior Sales and Best Marketing Executive
                                    </a>
                                </h3>
                                <a href="job-details.html" class="w-btn-link">
                                    Apply Now
                                    <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 9.77393L13 5.53583M13 5.53583L9 1.29774M13 5.53583L1 5.53583"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="job-post-horizontal align-items-center d-flex gap-3 bg-offWhite">
                            <div class="job-post-horizontal-img">
                                <img src="web/assets/img/job/jp-3.png" alt="" />
                            </div>
                            <div class="flex-grow-1">
                                <div class="mb-3 d-flex gap-3 align-items-center">
                                    <p class="job-type-badge-primary">Urgent</p>
                                    <h4 class="job-price-range fw-medium">$25-$30</h4>
                                </div>
                                <h3 class="job-post-horizontal-title fw-semibold mb-3">
                                    <a href="job-details.html">
                                        Senior Manager, Finance and Administration
                                    </a>
                                </h3>
                                <a href="job-details.html" class="w-btn-link">
                                    Apply Now
                                    <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 9.77393L13 5.53583M13 5.53583L9 1.29774M13 5.53583L1 5.53583"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="job-post-horizontal align-items-center d-flex gap-3 bg-offWhite">
                            <div class="job-post-horizontal-img">
                                <img src="web/assets/img/job/jp-4.png" alt="" />
                            </div>
                            <div class="flex-grow-1">
                                <div class="mb-3 d-flex gap-3 align-items-center">
                                    <p class="job-type-badge-primary">Urgent</p>
                                    <h4 class="job-price-range fw-medium">$25-$30</h4>
                                </div>
                                <h3 class="job-post-horizontal-title fw-semibold mb-3">
                                    <a href="job-details.html">
                                        Software engineer for android Development...
                                    </a>
                                </h3>
                                <a href="job-details.html" class="w-btn-link">
                                    Apply Now
                                    <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 9.77393L13 5.53583M13 5.53583L9 1.29774M13 5.53583L1 5.53583"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="job-post-horizontal align-items-center d-flex gap-3 bg-offWhite">
                            <div class="job-post-horizontal-img">
                                <img src="web/assets/img/job/jp-5.png" alt="" />
                            </div>
                            <div class="flex-grow-1">
                                <div class="mb-3 d-flex gap-3 align-items-center">
                                    <p class="job-type-badge-primary">Urgent</p>
                                    <h4 class="job-price-range fw-medium">$25-$30</h4>
                                </div>
                                <h3 class="job-post-horizontal-title fw-semibold mb-3">
                                    <a href="job-details.html">
                                        Senior Sales and Best Marketing Executive
                                    </a>
                                </h3>
                                <a href="job-details.html" class="w-btn-link">
                                    Apply Now
                                    <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 9.77393L13 5.53583M13 5.53583L9 1.29774M13 5.53583L1 5.53583"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="job-post-horizontal align-items-center d-flex gap-3 bg-offWhite">
                            <div class="job-post-horizontal-img">
                                <img src="web/assets/img/job/jp-6.png" alt="" />
                            </div>
                            <div class="flex-grow-1">
                                <div class="mb-3 d-flex gap-3 align-items-center">
                                    <p class="job-type-badge-primary">Urgent</p>
                                    <h4 class="job-price-range fw-medium">$25-$30</h4>
                                </div>
                                <h3 class="job-post-horizontal-title fw-semibold mb-3">
                                    <a href="job-details.html">
                                        Senior Manager, Finance and Administration
                                    </a>
                                </h3>
                                <a href="job-details.html" class="w-btn-link">
                                    Apply Now
                                    <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 9.77393L13 5.53583M13 5.53583L9 1.29774M13 5.53583L1 5.53583"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="job-post-horizontal align-items-center d-flex gap-3 bg-offWhite">
                            <div class="job-post-horizontal-img">
                                <img src="web/assets/img/job/jp-7.png" alt="" />
                            </div>
                            <div class="flex-grow-1">
                                <div class="mb-3 d-flex gap-3 align-items-center">
                                    <p class="job-type-badge-primary">Urgent</p>
                                    <h4 class="job-price-range fw-medium">$25-$30</h4>
                                </div>
                                <h3 class="job-post-horizontal-title fw-semibold mb-3">
                                    <a href="job-details.html">
                                        Software engineer for android Development...
                                    </a>
                                </h3>
                                <a href="job-details.html" class="w-btn-link">
                                    Apply Now
                                    <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 9.77393L13 5.53583M13 5.53583L9 1.29774M13 5.53583L1 5.53583"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="job-post-horizontal align-items-center d-flex gap-3 bg-offWhite">
                            <div class="job-post-horizontal-img">
                                <img src="web/assets/img/job/jp-8.png" alt="" />
                            </div>
                            <div class="flex-grow-1">
                                <div class="mb-3 d-flex gap-3 align-items-center">
                                    <p class="job-type-badge-primary">Urgent</p>
                                    <h4 class="job-price-range fw-medium">$25-$30</h4>
                                </div>
                                <h3 class="job-post-horizontal-title fw-semibold mb-3">
                                    <a href="job-details.html">
                                        Senior Sales and Best Marketing Executive
                                    </a>
                                </h3>
                                <a href="job-details.html" class="w-btn-link">
                                    Apply Now
                                    <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 9.77393L13 5.53583M13 5.53583L9 1.29774M13 5.53583L1 5.53583"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl-4 col-md-6 mb-4" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="job-post-horizontal align-items-center d-flex gap-3 bg-offWhite">
                            <div class="job-post-horizontal-img">
                                <img src="web/assets/img/job/jp-9.png" alt="" />
                            </div>
                            <div class="flex-grow-1">
                                <div class="mb-3 d-flex gap-3 align-items-center">
                                    <p class="job-type-badge-primary">Urgent</p>
                                    <h4 class="job-price-range fw-medium">$25-$30</h4>
                                </div>
                                <h3 class="job-post-horizontal-title fw-semibold mb-3">
                                    <a href="job-details.html">
                                        Senior Manager, Finance and Administration
                                    </a>
                                </h3>
                                <a href="job-details.html" class="w-btn-link">
                                    Apply Now
                                    <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 9.77393L13 5.53583M13 5.53583L9 1.29774M13 5.53583L1 5.53583"
                                            stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </section>
        <!-- Recent Job End -->

        <!-- Feature Tab Start-->
        <section class="py-110 bg-offWhite" hidden>
            <div class="container">
                <div class="row">
                    <div class="col-xl-5">
                        <div class="feature-tab-left" class="hero-two-title text-white fw-bold mb-4" data-aos="fade-up"
                            data-aos-duration="1000" data-aos-easing="linear">
                            <div class="mb-5">
                                <h2 class="section-title fw-bold">
                                    A whole world of freelance talent at your fingertip
                                </h2>
                            </div>
                            <nav>
                                <div class="d-flex flex-column" id="nav-tab" role="tablist">
                                    <div class="feature-tab feature-tab-two">
                                        <div class="d-flex align-items-center gap-3">
                                            <div>
                                                <img src="web/assets/img/about/tab-icon-1.png" alt="" />
                                            </div>
                                            <div>
                                                <h3 class="text-24 fw-bold text-dark-300 mb-2">
                                                    Proof of Quality Works
                                                </h3>
                                                <p class="text-dark-200 fs-6">
                                                    There are many variations of passages of Lorem our
                                                    Ipsum available, but the majority have suffered
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="feature-tab feature-tab-two">
                                        <div class="d-flex align-items-center gap-3">
                                            <div>
                                                <img src="web/assets/img/about/tab-icon-2.png" alt="" />
                                            </div>
                                            <div>
                                                <h3 class="text-24 fw-bold text-dark-300 mb-2">
                                                    No Cost Until You Hire
                                                </h3>
                                                <p class="text-dark-200 fs-6">
                                                    There are many variations of passages of Lorem our
                                                    Ipsum available, but the majority have suffered
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="feature-tab feature-tab-two">
                                        <div class="d-flex align-items-center gap-3">
                                            <div>
                                                <img src="web/assets/img/about/tab-icon-3.png" alt="" />
                                            </div>
                                            <div>
                                                <h3 class="text-24 fw-bold text-dark-300 mb-2">
                                                    Safe and Secure Payment Both
                                                </h3>
                                                <p class="text-dark-200 fs-6">
                                                    There are many variations of passages of Lorem our
                                                    Ipsum available, but the majority have suffered
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </nav>
                        </div>
                    </div>
                    <div class="col-xl-7">
                        <div class="feature-tab-right" class="hero-two-title text-white fw-bold mb-4" data-aos="fade-up"
                            data-aos-duration="1000" data-aos-easing="linear">
                            <div class="position-relative feature-tab-images">
                                <img src="web/assets/img/about/f-girl.png" class="img-fluid" alt="" />
                                <img src="web/assets/img/about/v-card-1.png"
                                    class="position-absolute feature-tab-img-one d-none d-xl-block" alt="" />
                                <img src="web/assets/img/about/v-card-2.png"
                                    class="position-absolute feature-tab-img-two d-none d-xl-block" alt="" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Feature Tab End-->

        <!-- Top Sellers -->
        <section class="top-sellers-area">
            <div class="container">
                <div class="row justify-content-between align-items-end mb-40">
                    <div class="col-auto">
                        <h2 class="fw-bold section-title">Top Companies</h2>
                        <p class="section-desc">Get some Inspirations from 86K+ skills</p>
                    </div>
                    <div class="col-auto mt-30 mt-md-0">
                        <div class="d-flex justify-content-end">
                            <a href="freelancers.html" class="w-btn-link">View More
                                <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke="currentColor" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center g-4">
                    <article class="col-xl col-lg-4 col-md-6" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="top-seller-card style-two position-relative">
                            <div class="job-type-badge position-absolute d-flex flex-column gap-2">
                                <p class="job-type-badge-tertiary">Top</p>
                                <p class="job-type-badge-secondary">Negotiable</p>
                            </div>
                            <div class="d-flex flex-column justify-content-center align-items-center">
                                <div class="seller-profile-img mb-4">
                                    <img src="web/assets/img/top-seller/1.png" alt="" />
                                </div>

                                <h3 class="top-seller-name fw-bold">HCL Technologies</h3>
                                <p class="top-seller-title">20 Job Post</p>
                                <div class="top-seller-rating mb-4">
                                    <p class="d-flex align-items-center top-seller-rating">
                                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M11.1141 4.65628C11.0407 4.42385 10.8406 4.25929 10.6048 4.23731L7.38803 3.93649L6.11676 0.870622C6.0229 0.645376 5.80934 0.5 5.57163 0.5C5.33392 0.5 5.12027 0.645376 5.02701 0.870622L3.75574 3.93649L0.538508 4.23731C0.302669 4.25973 0.102963 4.42429 0.0291678 4.65628C-0.0442024 4.8887 0.0235566 5.14364 0.201923 5.30478L2.63351 7.5011L1.91656 10.7539C1.8641 10.993 1.95422 11.2403 2.14687 11.3838C2.25042 11.4613 2.37208 11.5 2.49417 11.5C2.59908 11.5 2.70407 11.4713 2.79785 11.4135L5.57163 9.70504L8.3449 11.4135C8.54835 11.5387 8.80417 11.5272 8.99639 11.3838C9.18904 11.2403 9.27916 10.993 9.22671 10.7539L8.50975 7.5011L10.9413 5.30478C11.1196 5.14364 11.1875 4.88923 11.1141 4.65628Z"
                                                fill="currentColor" />
                                        </svg>
                                        <span class="top-seller-review">(399 Job Available)</span>
                                    </p>
                                </div>
                                <a href="#" class="w-btn-primary-lg">
                                    View Profile
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="10"
                                        viewBox="0 0 14 10" fill="none">
                                        <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                    </svg></a>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl col-lg-4 col-md-6" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="top-seller-card style-two position-relative">
                            <div class="job-type-badge position-absolute d-flex flex-column gap-2">
                                <p class="job-type-badge-tertiary">Top</p>
                                <p class="job-type-badge-secondary">Negotiable</p>
                            </div>
                            <div class="d-flex flex-column justify-content-center align-items-center">
                                <div class="seller-profile-img mb-4">
                                    <img src="web/assets/img/top-seller/2.png" alt="" />
                                </div>

                                <h3 class="top-seller-name fw-bold">LB Finance</h3>
                                <p class="top-seller-title">10 Job Post</p>
                                <div class="top-seller-rating mb-4">
                                    <p class="d-flex align-items-center top-seller-rating">
                                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M11.1141 4.65628C11.0407 4.42385 10.8406 4.25929 10.6048 4.23731L7.38803 3.93649L6.11676 0.870622C6.0229 0.645376 5.80934 0.5 5.57163 0.5C5.33392 0.5 5.12027 0.645376 5.02701 0.870622L3.75574 3.93649L0.538508 4.23731C0.302669 4.25973 0.102963 4.42429 0.0291678 4.65628C-0.0442024 4.8887 0.0235566 5.14364 0.201923 5.30478L2.63351 7.5011L1.91656 10.7539C1.8641 10.993 1.95422 11.2403 2.14687 11.3838C2.25042 11.4613 2.37208 11.5 2.49417 11.5C2.59908 11.5 2.70407 11.4713 2.79785 11.4135L5.57163 9.70504L8.3449 11.4135C8.54835 11.5387 8.80417 11.5272 8.99639 11.3838C9.18904 11.2403 9.27916 10.993 9.22671 10.7539L8.50975 7.5011L10.9413 5.30478C11.1196 5.14364 11.1875 4.88923 11.1141 4.65628Z"
                                                fill="currentColor" />
                                        </svg>
                                        <span class="top-seller-review">(399 Job Available)</span>
                                    </p>
                                </div>
                                <a href="#" class="w-btn-primary-lg">
                                    View Profile
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="10"
                                        viewBox="0 0 14 10" fill="none">
                                        <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                    </svg></a>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl col-lg-4 col-md-6" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="top-seller-card style-two position-relative">
                            <div class="job-type-badge position-absolute d-flex flex-column gap-2">
                                <p class="job-type-badge-tertiary">Top</p>
                                <p class="job-type-badge-secondary">Negotiable</p>
                            </div>
                            <div class="d-flex flex-column justify-content-center align-items-center">
                                <div class="seller-profile-img mb-4">
                                    <img src="web/assets/img/top-seller/3.png" alt="" />
                                </div>

                                <h3 class="top-seller-name fw-bold">Sufankho Jhon</h3>
                                <p class="top-seller-title">UiUx Designer</p>
                                <div class="top-seller-rating mb-4">
                                    <p class="d-flex align-items-center top-seller-rating">
                                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M11.1141 4.65628C11.0407 4.42385 10.8406 4.25929 10.6048 4.23731L7.38803 3.93649L6.11676 0.870622C6.0229 0.645376 5.80934 0.5 5.57163 0.5C5.33392 0.5 5.12027 0.645376 5.02701 0.870622L3.75574 3.93649L0.538508 4.23731C0.302669 4.25973 0.102963 4.42429 0.0291678 4.65628C-0.0442024 4.8887 0.0235566 5.14364 0.201923 5.30478L2.63351 7.5011L1.91656 10.7539C1.8641 10.993 1.95422 11.2403 2.14687 11.3838C2.25042 11.4613 2.37208 11.5 2.49417 11.5C2.59908 11.5 2.70407 11.4713 2.79785 11.4135L5.57163 9.70504L8.3449 11.4135C8.54835 11.5387 8.80417 11.5272 8.99639 11.3838C9.18904 11.2403 9.27916 10.993 9.22671 10.7539L8.50975 7.5011L10.9413 5.30478C11.1196 5.14364 11.1875 4.88923 11.1141 4.65628Z"
                                                fill="currentColor" />
                                        </svg>
                                        4.9 <span class="top-seller-review">(399 Reviews)</span>
                                    </p>
                                </div>
                                <a href="#" class="w-btn-primary-lg">
                                    View Profile
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="10"
                                        viewBox="0 0 14 10" fill="none">
                                        <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                    </svg></a>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl col-lg-4 col-md-6" data-aos="fade-up" data-aos-duration="1000"
                        data-aos-easing="linear">
                        <div class="top-seller-card style-two position-relative">
                            <div class="job-type-badge position-absolute d-flex flex-column gap-2">
                                <p class="job-type-badge-tertiary">Top</p>
                                <p class="job-type-badge-secondary">Negotiable</p>
                            </div>
                            <div class="d-flex flex-column justify-content-center align-items-center">
                                <div class="seller-profile-img mb-4">
                                    <img src="web/assets/img/top-seller/4.png" alt="" />
                                </div>
                                <h3 class="top-seller-name fw-bold">Sufankho Jhon</h3>
                                <p class="top-seller-title">UiUx Designer</p>
                                <div class="top-seller-rating mb-4">
                                    <p class="d-flex align-items-center top-seller-rating">
                                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M11.1141 4.65628C11.0407 4.42385 10.8406 4.25929 10.6048 4.23731L7.38803 3.93649L6.11676 0.870622C6.0229 0.645376 5.80934 0.5 5.57163 0.5C5.33392 0.5 5.12027 0.645376 5.02701 0.870622L3.75574 3.93649L0.538508 4.23731C0.302669 4.25973 0.102963 4.42429 0.0291678 4.65628C-0.0442024 4.8887 0.0235566 5.14364 0.201923 5.30478L2.63351 7.5011L1.91656 10.7539C1.8641 10.993 1.95422 11.2403 2.14687 11.3838C2.25042 11.4613 2.37208 11.5 2.49417 11.5C2.59908 11.5 2.70407 11.4713 2.79785 11.4135L5.57163 9.70504L8.3449 11.4135C8.54835 11.5387 8.80417 11.5272 8.99639 11.3838C9.18904 11.2403 9.27916 10.993 9.22671 10.7539L8.50975 7.5011L10.9413 5.30478C11.1196 5.14364 11.1875 4.88923 11.1141 4.65628Z"
                                                fill="currentColor" />
                                        </svg>
                                        4.9 <span class="top-seller-review">(399 Reviews)</span>
                                    </p>
                                </div>
                                <a href="#" class="w-btn-primary-lg">
                                    View Profile
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="10"
                                        viewBox="0 0 14 10" fill="none">
                                        <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                    </svg></a>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </section>
        <!-- Top Sellers End -->

        <!-- Core Cta -->
        <section class="pt-110 pb-80" hidden>
            <div class="container">
                <div class="cta-wrapper position-relative"
                    style="
              background: url('web/assets/img/cta/cta-bg.png') no-repeat center
                center/cover;
            ">
                    <div class="row justify-content-between">
                        <div class="col-lg-6">
                            <div data-aos="fade-up" data-aos-duration="1000" data-aos-easing="linear">
                                <h2 class="section-title-light fw-bold mb-4">
                                    Find the talent needed to get your business growing.
                                </h2>
                                <p class="text-white mb-5">
                                    There are many variations of passages of Lorem Ipsum
                                    available, but the majority have suffered alteration in some
                                    form, by injected humour.
                                </p>
                                <a href="contact.html" class="cta-btn-link">
                                    Get Started
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="10"
                                        viewBox="0 0 14 10" fill="none">
                                        <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                    </svg></a>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div>
                                <img src="web/assets/img/cta/men-women.png"
                                    class="cta-people position-absolute d-none d-lg-block" alt="" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Core Cta End -->

        <!-- Testimonial -->
        {{-- <section class="bg-offWhite py-110">
            <div class="container">
                <div class="row mb-40 justify-content-center">
                    <div class="co-auto">
                        <div class="text-center">
                            <h2 class="fw-bold section-title">Testimonial</h2>
                            <p class="section-desc">
                                Received 4.8/5 Stars in Over 10,000+ Reviews.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="swiper testimonialsSlider">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="swiper testimonialsSliderBottom mt-4">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="testimonial-card bg-white">
                            <div class="testimonial-content">
                                <div class="d-flex gap-2 align-items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                        viewBox="0 0 35 35" fill="none">
                                        <path
                                            d="M17.5 0C27.165 0 35 7.83502 35 17.5C35 27.165 27.165 35 17.5 35C7.83502 35 0 27.165 0 17.5C0 7.83502 7.83502 0 17.5 0Z"
                                            fill="#F7F5F0" />
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M19.1352 21.6719C18.4288 20.3063 18.0757 18.823 18.0757 17.222C18.0757 15.5975 18.5054 14.2555 19.3647 13.196C20.2241 12.1365 21.5602 11.6068 23.3731 11.6068V13.8317C22.7374 13.8317 22.2724 13.973 21.9781 14.2555C21.6838 14.538 21.5367 15.0795 21.5367 15.88V16.2332H24.1147V21.6719H19.1352ZM11.8246 21.6719C11.1183 20.3063 10.7651 18.823 10.7651 17.222C10.7651 15.5975 11.1948 14.2555 12.0542 13.196C12.9135 12.1365 14.2497 11.6068 16.0626 11.6068V13.8317C15.4269 13.8317 14.9619 13.973 14.6676 14.2555C14.3733 14.538 14.2261 15.0795 14.2261 15.88V16.2332H16.8042V21.6719H11.8246Z"
                                            fill="currentColor" />
                                    </svg>
                                    <span class="testimonial-title">Very Solid!!</span>
                                </div>
                                <p class="testimonial-feedback">
                                    There are many variations of a passages of Lorem Ipsum
                                    available, but the as majority have suffered alteration in
                                    some form.
                                </p>
                            </div>
                            <div class="testimonial-meta d-flex align-items-center justify-content-between">
                                <div class="d-flex gap-3 align-items-center">
                                    <div>
                                        <img src="web/assets/img/testimonial/au-1.png" class="testimonial-author-img"
                                            alt="" />
                                    </div>
                                    <div>
                                        <h4 class="testimonial-author-name fw-semibold">
                                            Black Marvin
                                        </h4>
                                        <p class="testimonial-author-title">Nursing Assistant</p>
                                    </div>
                                </div>
                                <div>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="95" height="16"
                                        viewBox="0 0 95 16" fill="none">
                                        <path
                                            d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M94.9784 5.78722C94.9267 5.62592 94.7908 5.5107 94.6257 5.48436L89.707 4.77331L87.4936 0.246895C87.4192 0.0954657 87.2671 0 87.1021 0C86.937 0 86.7849 0.0954657 86.7105 0.250187L84.5262 4.78977L79.6075 5.53375C79.4425 5.56008 79.3066 5.6753 79.2548 5.8366C79.203 5.99791 79.2483 6.17567 79.3681 6.29089L82.9374 9.80997L82.1122 14.794C82.0831 14.9619 82.151 15.1297 82.2869 15.2285C82.3613 15.2845 82.452 15.3141 82.5426 15.3141C82.6138 15.3141 82.6817 15.2976 82.7464 15.2614L87.1377 12.8945L91.5418 15.2351C91.6066 15.268 91.6745 15.2845 91.7425 15.2845C91.9819 15.2845 92.1793 15.0836 92.1793 14.84C92.1793 14.8038 92.1761 14.7709 92.1664 14.738L91.3153 9.78364L94.862 6.2448C94.9882 6.12629 95.0302 5.94853 94.9784 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z"
                                            fill="#FF9E15" />
                                        <path
                                            d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z"
                                            fill="#FF9E15" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section> --}}
        <!-- Testimonial End -->

        <!-- Recently Viewed Start -->
        <section class="py-110" hidden>
            <div class="container">
                <div class="row justify-content-between align-items-end mb-40">
                    <div class="col-auto">
                        <h2 class="fw-bold section-title">Recently Viewed</h2>
                        <p class="section-desc">Get some Inspirations from 86K+ skills</p>
                    </div>
                    <div class="col-auto mt-30 mt-md-0">
                        <div class="d-flex justify-content-end">
                            <a href="services.html" class="w-btn-link">View More
                                <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke="currentColor" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="row g-4">
                    <article class="col-xl-3 col-md-6 col-lg-4">
                        <div class="service-card-two style-three">
                            <div class="position-relative">
                                <img src="web/assets/img/services/sc-2-1.png" class="service-card-two-img w-100"
                                    alt="" />
                                <button class="service-card-wishlist-btn">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"
                                        viewBox="0 0 32 32" fill="none">
                                        <circle cx="16" cy="16" r="16" fill="white" />
                                        <path
                                            d="M16.68 9.51314L16 10.2438L15.3199 9.51315C13.442 7.49562 10.3974 7.49562 8.5195 9.51314C6.64161 11.5307 6.64161 14.8017 8.5195 16.8192L14.6399 23.3947C15.391 24.2018 16.6089 24.2018 17.3601 23.3947L23.4804 16.8192C25.3583 14.8017 25.3583 11.5307 23.4804 9.51314C21.6026 7.49562 18.5579 7.49562 16.68 9.51314Z"
                                            stroke="#22BE0D" stroke-linejoin="round" />
                                    </svg>
                                </button>
                            </div>
                            <div class="service-card-two-body">
                                <div class="d-flex align-items-center gap-1">

                                    <span class="service-card-rating">
                                        <i class="fa fa-map-marker-alt"></i> Sydney (Full time)
                                    </span>

                                </div>
                                <h3 class="service-card-title fw-semibold">
                                    <a href="#">Cleaning Service Elementor </a>
                                </h3>
                                <div class="d-flex justify-content-between">
                                    <div class="d-flex align-items-center gap-3">
                                        <img src="web/assets/img/avatar/u-sm-1.png" class="service-card-author-img"
                                            alt="" />
                                        <a href="#" class="service-card-author-name">Nankathan</a>
                                    </div>
                                    <div>
                                        <h5 class="service-card-price fw-bold">Part Time</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl-3 col-md-6 col-lg-4">
                        <div class="service-card-two style-three">
                            <div class="position-relative">
                                <img src="web/assets/img/services/sc-2-2.png" class="service-card-two-img w-100"
                                    alt="" />
                                <button class="service-card-wishlist-btn">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"
                                        viewBox="0 0 32 32" fill="none">
                                        <circle cx="16" cy="16" r="16" fill="white" />
                                        <path
                                            d="M16.68 9.51314L16 10.2438L15.3199 9.51315C13.442 7.49562 10.3974 7.49562 8.5195 9.51314C6.64161 11.5307 6.64161 14.8017 8.5195 16.8192L14.6399 23.3947C15.391 24.2018 16.6089 24.2018 17.3601 23.3947L23.4804 16.8192C25.3583 14.8017 25.3583 11.5307 23.4804 9.51314C21.6026 7.49562 18.5579 7.49562 16.68 9.51314Z"
                                            stroke="#22BE0D" stroke-linejoin="round" />
                                    </svg>
                                </button>
                            </div>
                            <div class="service-card-two-body">
                                <div class="d-flex align-items-center gap-1">

                                    <span class="service-card-rating">
                                        <i class="fa fa-map-marker-alt"></i> Sydney (Full time)
                                    </span>

                                </div>
                                <h3 class="service-card-title fw-semibold">
                                    <a href="#">Cleaning Service Elementor </a>
                                </h3>
                                <div class="d-flex justify-content-between">
                                    <div class="d-flex align-items-center gap-3">
                                        <img src="web/assets/img/avatar/u-sm-1.png" class="service-card-author-img"
                                            alt="" />
                                        <a href="#" class="service-card-author-name">Nankathan</a>
                                    </div>
                                    <div>
                                        <h5 class="service-card-price fw-bold">Full Time</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl-3 col-md-6 col-lg-4">
                        <div class="service-card-two style-three">
                            <div class="position-relative">
                                <img src="web/assets/img/services/sc-2-3.png" class="service-card-two-img w-100"
                                    alt="" />
                                <button class="service-card-wishlist-btn">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"
                                        viewBox="0 0 32 32" fill="none">
                                        <circle cx="16" cy="16" r="16" fill="white" />
                                        <path
                                            d="M16.68 9.51314L16 10.2438L15.3199 9.51315C13.442 7.49562 10.3974 7.49562 8.5195 9.51314C6.64161 11.5307 6.64161 14.8017 8.5195 16.8192L14.6399 23.3947C15.391 24.2018 16.6089 24.2018 17.3601 23.3947L23.4804 16.8192C25.3583 14.8017 25.3583 11.5307 23.4804 9.51314C21.6026 7.49562 18.5579 7.49562 16.68 9.51314Z"
                                            stroke="#22BE0D" stroke-linejoin="round" />
                                    </svg>
                                </button>
                            </div>
                            <div class="service-card-two-body">
                                <div class="d-flex align-items-center gap-1">

                                    <span class="service-card-rating">
                                        <i class="fa fa-map-marker-alt"></i> Sydney (Full time)
                                    </span>

                                </div>
                                <h3 class="service-card-title fw-semibold">
                                    <a href="#">Cleaning Service Elementor </a>
                                </h3>
                                <div class="d-flex justify-content-between">
                                    <div class="d-flex align-items-center gap-3">
                                        <img src="web/assets/img/avatar/u-sm-1.png" class="service-card-author-img"
                                            alt="" />
                                        <a href="#" class="service-card-author-name">Nankathan</a>
                                    </div>
                                    <div>
                                        <h5 class="service-card-price fw-bold">Contract</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </article>
                    <article class="col-xl-3 col-md-6 col-lg-4">
                        <div class="service-card-two style-three">
                            <div class="position-relative">
                                <img src="web/assets/img/services/sc-2-4.png" class="service-card-two-img w-100"
                                    alt="" />
                                <button class="service-card-wishlist-btn">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"
                                        viewBox="0 0 32 32" fill="none">
                                        <circle cx="16" cy="16" r="16" fill="white" />
                                        <path
                                            d="M16.68 9.51314L16 10.2438L15.3199 9.51315C13.442 7.49562 10.3974 7.49562 8.5195 9.51314C6.64161 11.5307 6.64161 14.8017 8.5195 16.8192L14.6399 23.3947C15.391 24.2018 16.6089 24.2018 17.3601 23.3947L23.4804 16.8192C25.3583 14.8017 25.3583 11.5307 23.4804 9.51314C21.6026 7.49562 18.5579 7.49562 16.68 9.51314Z"
                                            stroke="#22BE0D" stroke-linejoin="round" />
                                    </svg>
                                </button>
                            </div>
                            <div class="service-card-two-body">
                                <div class="d-flex align-items-center gap-1">

                                    <span class="service-card-rating">
                                        <i class="fa fa-map-marker-alt"></i> Sydney (Full time)
                                    </span>

                                </div>
                                <h3 class="service-card-title fw-semibold">
                                    <a href="#">Cleaning Service Elementor </a>
                                </h3>
                                <div class="d-flex justify-content-between">
                                    <div class="d-flex align-items-center gap-3">
                                        <img src="web/assets/img/avatar/u-sm-1.png" class="service-card-author-img"
                                            alt="" />
                                        <a href="#" class="service-card-author-name">Nankathan</a>
                                    </div>
                                    <div>
                                        <h5 class="service-card-price fw-bold">Full Time</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </section>
        <!-- Recently Viewed End -->
    </main>
@endsection
