@extends('layouts.app')
@section('title', 'SKILLPOTS - Find Your Dream Job')
@section('content')
<!-- Hero Section -->

<livewire:web.index.modal.signinmodal/>
<livewire:web.index.modal.signupmodal/>
   <!-- Hero Section -->


    <!-- Featured Jobs -->

   <livewire:web.index.findjob.findjobview/>


<style>
  .filter-card.compact {
    border-radius: 12px;
  }
  .form-check-sm .form-check-input {
    width: 0.85em;
    height: 0.85em;
    margin-top: 0.2em;
  }
  .form-check-sm .form-check-label {
    font-size: 0.8rem;
  }
  .compact-range {
    height: 2px;
  }
  .btn-group-sm .btn {
    font-size: 0.75rem;
    padding: 0.3rem 0.6rem;
  }

  .skill-badge {
    background-color: #f1f3f5;
    color: #333;
    border-radius: 20px;
    padding: 0.3rem 0.6rem;
    font-size: 0.75rem;
    margin-right: 5px;
  }
  .job-card-attractive {
    border: none;
    border-radius: 15px;
    transition: transform 0.2s ease;
  }
  .job-card-attractive:hover {
    transform: translateY(-5px);
    box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  }
</style>

      <script>
        document.addEventListener('DOMContentLoaded', function() {
            const jobCards = document.querySelectorAll('.job-card');
            const jobTypeFilter = document.getElementById('job-type');
            const locationFilter = document.getElementById('location');
            const salaryFilter = document.getElementById('salary');
            const skillsFilter = document.getElementById('skills');
            const applyFiltersBtn = document.getElementById('apply-filters');
            const resetFiltersBtn = document.getElementById('reset-filters');

            // Apply filters when the button is clicked
            applyFiltersBtn.addEventListener('click', filterJobs);

            // Reset all filters
            resetFiltersBtn.addEventListener('click', function() {
                jobTypeFilter.value = 'all';
                locationFilter.value = 'all';
                salaryFilter.value = 'all';
                skillsFilter.value = 'all';
                filterJobs();
            });

            function filterJobs() {
                const selectedType = jobTypeFilter.value;
                const selectedLocation = locationFilter.value;
                const selectedSalary = salaryFilter.value;
                const selectedSkill = skillsFilter.value;

                jobCards.forEach(card => {
                    const cardType = card.getAttribute('data-type');
                    const cardLocation = card.getAttribute('data-location');
                    const cardSalary = card.getAttribute('data-salary');
                    const cardSkills = card.getAttribute('data-skills');

                    // Check if the card matches all selected filters
                    const typeMatch = selectedType === 'all' ||
                                     (selectedType === 'Remote' && cardLocation === 'Remote') ||
                                     cardType === selectedType;

                    const locationMatch = selectedLocation === 'all' ||
                                         cardLocation === selectedLocation;

                    const salaryMatch = selectedSalary === 'all' || checkSalaryMatch(cardSalary, selectedSalary);

                    const skillMatch = selectedSkill === 'all' ||
                                      cardSkills.toLowerCase().includes(selectedSkill.toLowerCase());

                    // Show or hide the card based on filter matches
                    if (typeMatch && locationMatch && salaryMatch && skillMatch) {
                        card.style.display = 'block';
                    } else {
                        card.style.display = 'none';
                    }
                });

                // Check if no jobs are visible
                const visibleJobs = document.querySelectorAll('.job-card[style="display: block"]');
                let noJobsMessage = document.querySelector('.no-jobs-message');

                if (visibleJobs.length === 0) {
                    if (!noJobsMessage) {
                        noJobsMessage = document.createElement('div');
                        noJobsMessage.className = 'no-jobs-message';
                        noJobsMessage.innerHTML = '<h3>No jobs match your filters</h3><p>Try adjusting your filters to see more results</p>';
                        document.getElementById('jobs-container').appendChild(noJobsMessage);
                    }
                } else if (noJobsMessage) {
                    noJobsMessage.remove();
                }
            }

            function checkSalaryMatch(cardSalary, selectedSalary) {
                const [cardMin, cardMax] = cardSalary.split('-').map(Number);

                switch(selectedSalary) {
                    case '0-50000':
                        return cardMax <= 50000;
                    case '50000-80000':
                        return cardMin >= 50000 && cardMax <= 80000;
                    case '80000-100000':
                        return cardMin >= 80000 && cardMax <= 100000;
                    case '100000+':
                        return cardMin >= 100000;
                    default:
                        return true;
                }
            }
        });
    </script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: #f5f7f9;
            color: #333;
            line-height: 1.6;
        }

        .container {
            max-width: 1200px;
            margin: 40px auto;
            padding: 0 20px;
        }
        .job-card-attractive {
    border: 1px solid #eee;
    border-radius: 16px;
    transition: all 0.3s ease;
  }
  .job-card-attractive:hover {
    transform: translateY(-6px);
    box-shadow: 0 12px 28px rgba(0,0,0,0.08);
    border-color: #ddd;
  }
  .company-logo-circle {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1rem;
  }
  .skill-badge {
    background: #f8f9fa;
    border: 1px solid #e5e7eb;
    color: #333;
    font-size: 0.75rem;
    padding: 0.4em 0.6em;
    margin-right: 0.3rem;
    border-radius: 6px;
  }
  .btn {
    border-radius: 8px;
    font-weight: 500;
  }

        .section-title {
            text-align: center;
            margin-bottom: 40px;
        }

        .section-title h2 {
            font-size: 32px;
            color: #2c3e50;
            margin-bottom: 10px;
        }

        .section-title p {
            color: #7f8c8d;
            font-size: 18px;
        }

        .filter-container {
            background: white;
            border-radius: 8px;
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }

        .filter-title {
            font-size: 20px;
            margin-bottom: 20px;
            color: #2c3e50;
            display: flex;
            align-items: center;
        }

        .filter-title i {
            margin-right: 10px;
            color: #3498db;
        }

        .filter-options {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
        }

        .filter-group {
            flex: 1;
            min-width: 200px;
        }

        .filter-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #34495e;
        }

        .filter-group select, .filter-group input {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 16px;
            background-color: #f8f9fa;
        }

        .filter-buttons {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
            margin-top: 20px;
        }

        .filter-btn {
            padding: 12px 24px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .apply-filter {
            background-color: #3498db;
            color: white;
        }

        .apply-filter:hover {
            background-color: #2980b9;
        }

        .reset-filter {
            background-color: #e7e7e7;
            color: #333;
        }

        .reset-filter:hover {
            background-color: #ddd;
        }


        .no-jobs-message {
            grid-column: 1 / -1;
            text-align: center;
            padding: 40px;
            background: white;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
        }

        .no-jobs-message h3 {
            color: #7f8c8d;
            margin-bottom: 15px;
        }

        @media (max-width: 768px) {
            .filter-options {
                flex-direction: column;
            }

            .jobs-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>

    <!-- Job Categories -->
    <section class="categories">
        <div class="container">
            <div class="section-title">
                <h2>Explore by Category</h2>
                <p>Find jobs in your field of expertise</p>
            </div>
            <div class="categories-grid">
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-code"></i>
                    </div>
                    <h3>Technology</h3>
                    <p>1250 jobs available</p>
                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3>Finance</h3>
                    <p>750 jobs available</p>
                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-paint-brush"></i>
                    </div>
                    <h3>Design</h3>
                    <p>680 jobs available</p>
                </div>
                <div class="category-card">
                    <div class="category-icon">
                        <i class="fas fa-bullhorn"></i>
                    </div>
                    <h3>Marketing</h3>
                    <p>940 jobs available</p>
                </div>
            </div>
        </div>
    </section>

    <script>
        // Simple JavaScript for interactive elements
        document.addEventListener('DOMContentLoaded', function() {
            const applyButtons = document.querySelectorAll('.apply-btn');

            applyButtons.forEach(button => {
                button.addEventListener('click', function() {
                    alert('Application process would start here!');
                });
            });

            const searchBtn = document.querySelector('.search-btn');
            if (searchBtn) {
                searchBtn.addEventListener('click', function() {
                    alert('Search functionality would be implemented here!');
                });
            }
        });
    </script>
     <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        :root {
            --primary: #4a6cfa;

            --secondary: #ff6b6b;
            --dark: #2d3748;
            --light: #f8f9fa;
            --gray: #718096;
            --success: #48bb78;
            --gradient-start: #0834c2;
            --gradient-end: #c5e8fe;
        }

        body {
            background-color: #ffffff;
            color: var(--dark);
            line-height: 1.6;
        }

        .container {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        /* Modern Hero Section */
        .hero {
            position: relative;
            padding: 100px 0;
            background: linear-gradient(135deg, var(--gradient-start) 0%, var(--gradient-end) 100%);
            color: white;
            overflow: hidden;
        }

        .hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url("data:image/svg+xml,%3Csvg width='100' height='100' viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M11 18c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm48 25c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm-43-7c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm63 31c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM34 90c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm56-76c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM12 86c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm28-65c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm23-11c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-6 60c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm29 22c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zM32 63c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm57-13c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-9-21c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM60 91c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM35 41c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM12 60c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2z' fill='%23ffffff' fill-opacity='0.1' fill-rule='evenodd'/%3E%3C/svg%3E");
            opacity: 0.5;
        }

        .hero-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: relative;
            z-index: 2;
            max-width: 100%;
        }

        .hero-text {
            flex: 1;
            padding-right: 50px;
            max-width: 600px;
        }

        .hero-text h1 {
            font-size: 3.2rem;
            margin-bottom: 20px;
            font-weight: 800;
            line-height: 1.2;
        }

        .hero-text p {
            font-size: 1.2rem;
            margin-bottom: 30px;
            opacity: 0.9;
        }

        .search-box {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            padding: 20px;
            border-radius: 16px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
            margin-top: 30px;
            display: flex;
            align-items: center;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .search-input {
            flex: 1;
            padding: 15px;
            border: none;
            border-radius: 8px;
            margin-right: 10px;
            font-size: 16px;
            background: rgba(255, 255, 255, 0.9);
        }

        .search-btn {
            background-color: white;
            color: var(--primary);

            border: none;
            padding: 15px 45px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 700;
            transition: all 0.3s;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .search-btn:hover {
            background-color: var(--primary-dark);
            color: white;
            transform: translateY(-2px);
        }

        .hero-image {
            flex: 1;
            text-align: center;
            position: relative;
        }

        .hero-image img {
            max-width: 100%;
            height: auto;
            border-radius: 16px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
            transform: perspective(800px) rotateY(-10deg);
            transition: transform 0.5s;
        }

        .hero-image img:hover {
            transform: perspective(800px) rotateY(0);
        }

        /* Stats Section */
        .hero-stats {
            display: flex;
            margin-top: 40px;
            gap: 30px;
        }

        .stat-item {
            display: flex;
            align-items: center;
        }

        .stat-icon {
            font-size: 1.8rem;
            margin-right: 15px;
            opacity: 0.9;
        }

        .stat-content h3 {
            font-size: 1.5rem;
            margin-bottom: 5px;
        }

        .stat-content p {
            font-size: 0.9rem;
            margin: 0;
            opacity: 0.8;
        }

        /* Responsive Design */
        @media (max-width: 992px) {
            .hero-content {
                flex-direction: column;
                text-align: center;
            }

            .hero-text {
                padding-right: 0;
                margin-bottom: 40px;
            }

            .hero-stats {
                justify-content: center;
            }
        }

        @media (max-width: 768px) {
            .hero-text h1 {
                font-size: 2.5rem;
            }

            .search-box {
                flex-direction: column;
            }

            .search-input {
                margin-right: 0;
                margin-bottom: 10px;
            }

            .hero-stats {
                flex-direction: column;
                gap: 20px;
            }
        }

        /* Rest of your existing styles remain the same */
        .section-title {
            text-align: center;
            margin: 60px 0 40px;
        }

        .section-title h2 {
            font-size: 2.5rem;
            color: var(--dark);
            margin-bottom: 15px;
        }

        .section-title p {
            color: var(--gray);
            font-size: 1.1rem;
        }

        .jobs-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 25px;
            margin-bottom: 60px;
        }

        .job-card {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: transform 0.3s;
        }

        .job-card:hover {
            transform: translateY(-5px);
        }

        .job-header {
            padding: 20px;
            border-bottom: 1px solid #eee;
        }

        .job-title {
            font-size: 1.3rem;
            margin-bottom: 10px;
        }

        .company {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }



        .company-name {
            font-weight: 500;
        }

        .job-details {
            padding: 20px;
        }

        .job-detail {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
            color: var(--gray);
        }

        .job-detail i {
            margin-right: 10px;
            color: var(--primary);
        }

        .job-tags {
            display: flex;
            flex-wrap: wrap;
            margin: 15px 0;
        }

        .tag {
            padding: 5px 10px;
            background-color: #e6e9ff;
            border-radius: 20px;
            font-size: 0.8rem;
            margin-right: 8px;
            margin-bottom: 8px;
            color: var(--primary);
        }

        .apply-btn {
            width: 100%;
            text-align: center;
            padding: 12px;
            background-color: var(--primary);
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-weight: 600;
            transition: background-color 0.3s;
        }

        .apply-btn:hover {
            background-color: #3a5bd9;
        }

        /* Categories Section */
        .categories {
            background-color: white;
            padding: 60px 0;
        }

        .categories-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
        }

        .category-card {
            background-color: var(--light);
            padding: 30px;
            border-radius: 10px;
            text-align: center;
            transition: transform 0.3s;
        }

        .category-card:hover {
            transform: translateY(-5px);
            background-color: #e6e9ff;
        }

        .category-icon {
            font-size: 2.5rem;
            color: var(--primary);
            margin-bottom: 20px;
        }

        .category-card h3 {
            margin-bottom: 15px;
        }

        .category-card p {
            color: var(--gray);
        }
    </style>
@endsection

