

@extends('layouts.employersiteapp')
@section('title', 'SKILLPOTS - Hire Top Talent')
@section('content')
    <!-- Hero Section -->
    <main>
        <div class="hero-section" style="background-color: #0e636b">
            <div class="container" style="background-color: #0e636b">
                <h1>AI-Powered Talent Acquisition</h1>
                <p class="subtitle">Connect with qualified candidates faster using our intelligent matching system</p>

                <div class="search-container">
                    <input type="text" class="search-input" placeholder="Search for candidates, skills, or positions...">
                    <button class="search-btn" style="background-color: #ebba1b; color: #0e636b;">Search</button>
                </div>

                <div class="action-buttons">
                    <button class="btn btn-secondary" style="background-color: #ebba1b; color: #0e636b;">Post a Job</button>
                    <button class="btn btn-secondary">Browse Candidates</button>
                </div>

                <div class="features">
                    <div class="feature-item">Smart candidate matching</div>
                    <div class="feature-item">Reduce time-to-hire</div>
                    <div class="feature-item">Quality applicants</div>
                </div>
            </div>
        </div>

        <!-- Stats Section -->
        <section class="py-80 bg-offWhite">
            <div class="container">
                <div class="row text-center">
                    <div class="col-md-3 mb-4">
                        <div class="stat-card">
                            <h2 class="fw-bold" style="color: #0e636b; font-size: 48px;">50K+</h2>
                            <p class="text-dark-200">Active Candidates</p>
                        </div>
                    </div>
                    <div class="col-md-3 mb-4">
                        <div class="stat-card">
                            <h2 class="fw-bold" style="color: #0e636b; font-size: 48px;">12K+</h2>
                            <p class="text-dark-200">Companies Hiring</p>
                        </div>
                    </div>
                    <div class="col-md-3 mb-4">
                        <div class="stat-card">
                            <h2 class="fw-bold" style="color: #0e636b; font-size: 48px;">95%</h2>
                            <p class="text-dark-200">Satisfaction Rate</p>
                        </div>
                    </div>
                    <div class="col-md-3 mb-4">
                        <div class="stat-card">
                            <h2 class="fw-bold" style="color: #0e636b; font-size: 48px;">30%</h2>
                            <p class="text-dark-200">Faster Hiring</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Popular Job Categories for Hiring -->
        <section class="pt-80">
            <div class="container-fluid">
                <div class="row mb-40 justify-content-center">
                    <div class="col-auto text-center">
                        <h2 class="fw-bold section-title">Most In-Demand Skills</h2>
                        <p class="section-desc">Find candidates in these popular categories</p>
                    </div>
                </div>
                <livewire:web.index.home.categorycomponent />
            </div>
        </section>

        <!-- Top Candidates Section -->
        <section class="py-80">
            <div class="container-fluid">
                <div class="row mb-40 justify-content-between align-items-end">
                    <div class="col-auto">
                        <h2 class="fw-bold section-title">Featured Candidates</h2>
                        <p class="section-desc">Top talent available for hire</p>
                    </div>
                    <div class="col-auto mt-30 mt-md-0">
                        <div class="filters-btns d-flex flex-wrap align-items-center gap-3">
                            <button class="service-filter-btn active" data-filter="*">All</button>
                            <button class="service-filter-btn" data-filter=".tech">Technology</button>
                            <button class="service-filter-btn" data-filter=".design">Design</button>
                            <button class="service-filter-btn" data-filter=".marketing">Marketing</button>
                            <button class="service-filter-btn" data-filter=".sales">Sales</button>
                        </div>
                    </div>
                </div>
                <div class="row grid">
                    <!-- Candidate Card 1 -->
                    <article class="col-xl-4 col-md-6 mb-4 grid-item tech">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>
                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="Candidate" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">John Smith</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Available</span>
                                                <span class="badge" style="background-color: #ebba1b; color: #0e636b;">Verified</span>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="save-job-btn" data-job-id="123">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Senior Full Stack Developer</a>
                                </h3>

                                <p class="job-excerpt">8+ years experience in React, Node.js, and cloud architecture. Led teams of 5+ developers...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon" title="React">React</span>
                                        <span class="tech-icon" title="Node.js">Node</span>
                                        <span class="tech-icon" title="AWS">AWS</span>
                                    </div>
                                    <span class="experience-level">8+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Sydney</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-dollar-sign"></i>
                                            <span>$120K-$150K</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-clock"></i>
                                            <span>Immediate</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now" style="background-color: #0e636b;">View Profile</button>
                                    <button class="btn-view-details">Contact</button>
                                </div>
                            </div>
                            <div class="glass-reflection"></div>
                        </div>
                    </article>

                    <!-- Candidate Card 2 -->
                    <article class="col-xl-4 col-md-6 mb-4 grid-item design">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>
                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="Candidate" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">Sarah Johnson</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Remote OK</span>
                                                <span class="badge" style="background-color: #ebba1b; color: #0e636b;">Top Rated</span>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="save-job-btn">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Senior UX/UI Designer</a>
                                </h3>

                                <p class="job-excerpt">Creative designer with 6 years experience in SaaS products. Expert in Figma and user research...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon">Figma</span>
                                        <span class="tech-icon">Adobe</span>
                                        <span class="tech-icon">UX</span>
                                    </div>
                                    <span class="experience-level">6+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Melbourne</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-dollar-sign"></i>
                                            <span>$95K-$120K</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-clock"></i>
                                            <span>2 weeks</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now" style="background-color: #0e636b;">View Profile</button>
                                    <button class="btn-view-details">Contact</button>
                                </div>
                            </div>
                            <div class="glass-reflection"></div>
                        </div>
                    </article>

                    <!-- Candidate Card 3 -->
                    <article class="col-xl-4 col-md-6 mb-4 grid-item marketing">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>
                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="Candidate" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">Michael Chen</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Available</span>
                                                <span class="badge" style="background-color: #ebba1b; color: #0e636b;">Verified</span>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="save-job-btn">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Digital Marketing Manager</a>
                                </h3>

                                <p class="job-excerpt">Results-driven marketer with proven track record in SEO, PPC, and content strategy...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon">SEO</span>
                                        <span class="tech-icon">GA4</span>
                                        <span class="tech-icon">Ads</span>
                                    </div>
                                    <span class="experience-level">5+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Brisbane</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-dollar-sign"></i>
                                            <span>$85K-$110K</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-clock"></i>
                                            <span>Immediate</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now" style="background-color: #0e636b;">View Profile</button>
                                    <button class="btn-view-details">Contact</button>
                                </div>
                            </div>
                            <div class="glass-reflection"></div>
                        </div>
                    </article>

                    <!-- Add 3 more candidate cards following the same pattern -->
                    <article class="col-xl-4 col-md-6 mb-4 grid-item tech">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>
                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="Candidate" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">Emma Wilson</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Remote</span>
                                                <span class="badge" style="background-color: #ebba1b; color: #0e636b;">Premium</span>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="save-job-btn">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">DevOps Engineer</a>
                                </h3>

                                <p class="job-excerpt">Infrastructure expert specializing in Kubernetes, Docker, and CI/CD automation...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon">K8s</span>
                                        <span class="tech-icon">Docker</span>
                                        <span class="tech-icon">AWS</span>
                                    </div>
                                    <span class="experience-level">7+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Perth</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-dollar-sign"></i>
                                            <span>$115K-$140K</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-clock"></i>
                                            <span>1 month</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now" style="background-color: #0e636b;">View Profile</button>
                                    <button class="btn-view-details">Contact</button>
                                </div>
                            </div>
                            <div class="glass-reflection"></div>
                        </div>
                    </article>

                    <article class="col-xl-4 col-md-6 mb-4 grid-item sales">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>
                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="Candidate" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">David Brown</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Available</span>
                                                <span class="badge" style="background-color: #ebba1b; color: #0e636b;">Top Rated</span>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="save-job-btn">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Sales Director</a>
                                </h3>

                                <p class="job-excerpt">10+ years building and leading high-performing sales teams. B2B SaaS specialist...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon">B2B</span>
                                        <span class="tech-icon">SaaS</span>
                                        <span class="tech-icon">CRM</span>
                                    </div>
                                    <span class="experience-level">10+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Sydney</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-dollar-sign"></i>
                                            <span>$140K-$180K</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-clock"></i>
                                            <span>Immediate</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now" style="background-color: #0e636b;">View Profile</button>
                                    <button class="btn-view-details">Contact</button>
                                </div>
                            </div>
                            <div class="glass-reflection"></div>
                        </div>
                    </article>

                    <article class="col-xl-4 col-md-6 mb-4 grid-item design">
                        <div class="job-card-glass">
                            <div class="glass-background"></div>
                            <div class="job-card-content">
                                <div class="job-card-top">
                                    <div class="company-section">
                                        <div class="company-avatar">
                                            <img src="web/assets/img/avatar/u-sm-1.png" alt="Candidate" />
                                        </div>
                                        <div class="company-details">
                                            <h4 class="company-name">Lisa Anderson</h4>
                                            <div class="job-badges">
                                                <span class="badge remote">Remote OK</span>
                                                <span class="badge" style="background-color: #ebba1b; color: #0e636b;">Verified</span>
                                            </div>
                                        </div>
                                    </div>
                                    <button class="save-job-btn">
                                        <i class="far fa-bookmark"></i>
                                    </button>
                                </div>

                                <h3 class="job-title-glass">
                                    <a href="#">Product Designer</a>
                                </h3>

                                <p class="job-excerpt">Award-winning designer with expertise in design systems and mobile-first experiences...</p>

                                <div class="tech-stack">
                                    <div class="tech-icons">
                                        <span class="tech-icon">Figma</span>
                                        <span class="tech-icon">Sketch</span>
                                        <span class="tech-icon">DS</span>
                                    </div>
                                    <span class="experience-level">5+ years</span>
                                </div>

                                <div class="job-meta-glass">
                                    <div class="meta-grid">
                                        <div class="meta-cell">
                                            <i class="fas fa-location-dot"></i>
                                            <span>Melbourne</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-dollar-sign"></i>
                                            <span>$100K-$125K</span>
                                        </div>
                                        <div class="meta-cell">
                                            <i class="fas fa-clock"></i>
                                            <span>2 weeks</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="job-card-actions">
                                    <button class="btn-apply-now" style="background-color: #0e636b;">View Profile</button>
                                    <button class="btn-view-details">Contact</button>
                                </div>
                            </div>
                            <div class="glass-reflection"></div>
                        </div>
                    </article>
                </div>

                <div class="row justify-content-center mt-5">
                    <div class="col-auto">
                        <a href="#" class="w-btn-secondary-lg" style="background-color: #0e636b;">
                            View All Candidates
                            <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke="currentColor" stroke-width="1.5"
                                    stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </section>

        <!-- How It Works Section -->
        <section class="py-110 bg-offWhite">
            <div class="container">
                <div class="row mb-40 justify-content-center">
                    <div class="col-auto text-center">
                        <h2 class="fw-bold section-title">How Skillpots Works</h2>
                        <p class="section-desc">Find and hire top talent in 3 simple steps</p>
                    </div>
                </div>
                <div class="row g-4">
                    <div class="col-md-4">
                        <div class="text-center p-4">
                            <div class="mb-4">
                                <div style="width: 80px; height: 80px; background-color: #0e636b; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                    <i class="fas fa-file-alt" style="font-size: 32px; color: #ebba1b;"></i>
                                </div>
                            </div>
                            <h4 class="fw-bold mb-3">1. Post Your Job</h4>
                            <p>Create a detailed job posting with your requirements and our AI will match you with qualified candidates</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="text-center p-4">
                            <div class="mb-4">
                                <div style="width: 80px; height: 80px; background-color: #0e636b; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                    <i class="fas fa-users" style="font-size: 32px; color: #ebba1b;"></i>
                                </div>
                            </div>
                            <h4 class="fw-bold mb-3">2. Review Candidates</h4>
                            <p>Browse through matched candidates, review profiles, and shortlist the best fits for your team</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="text-center p-4">
                            <div class="mb-4">
                                <div style="width: 80px; height: 80px; background-color: #0e636b; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                    <i class="fas fa-handshake" style="font-size: 32px; color: #ebba1b;"></i>
                                </div>
                            </div>
                            <h4 class="fw-bold mb-3">3. Hire & Onboard</h4>
                            <p>Schedule interviews, make offers, and onboard your new team member seamlessly through our platform</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Success Stories -->
        <section class="top-sellers-area py-4">
            <div class="container-fluid">
                <div class="row justify-content-between align-items-end mb-40">
                    <div class="col-auto">
                        <h2 class="fw-bold section-title">Success Stories</h2>
                        <p class="section-desc">Companies that found their perfect match</p>
                    </div>
                    <div class="col-auto mt-30 mt-md-0">
                        <div class="d-flex justify-content-end">
                            <a href="#" class="w-btn-link">View More
                                <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke="currentColor" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center g-4">
                    <article class="col-xl-4 col-lg-4 col-md-6">
                        <div class="bg-white p-4 rounded" style="box-shadow: 0 4px 20px rgba(0,0,0,0.1);">
                            <div class="d-flex align-items-center mb-3">
                                <img src="web/assets/img/top-seller/1.png" alt="Company" style="width: 60px; height: 60px; border-radius: 50%;" />
                                <div class="ms-3">
                                    <h5 class="fw-bold mb-0">Tech Innovations Ltd</h5>
                                    <p class="text-muted mb-0">Technology</p>
                                </div>
                            </div>
                            <p class="mb-3">"We hired 5 excellent developers through Skillpots in just 2 weeks. The AI matching saved us countless hours!"</p>
                            <div class="d-flex align-items-center">
                                <span class="badge" style="background-color: #0e636b; color: #fff;">5 Hires</span>
                                <span class="ms-2 text-muted">2 weeks</span>
                            </div>
                        </div>
                    </article>

                    <article class="col-xl-4 col-lg-4 col-md-6">
                        <div class="bg-white p-4 rounded" style="box-shadow: 0 4px 20px rgba(0,0,0,0.1);">
                            <div class="d-flex align-items-center mb-3">
                                <img src="web/assets/img/top-seller/2.png" alt="Company" style="width: 60px; height: 60px; border-radius: 50%;" />
                                <div class="ms-3">
                                    <h5 class="fw-bold mb-0">Creative Agency Co</h5>
                                    <p class="text-muted mb-0">Design</p>
                                </div>
                            </div>
                            <p class="mb-3">"Found our lead designer here. The quality of candidates is outstanding compared to other platforms."</p>
                            <div class="d-flex align-items-center">
                                <span class="badge" style="background-color: #1a4d2e; color: #fff;">3 Hires</span>
                                <span class="ms-2 text-muted">1 month</span>
                            </div>
                        </div>
                    </article>

                    <article class="col-xl-4 col-lg-4 col-md-6">
                        <div class="bg-white p-4 rounded" style="box-shadow: 0 4px 20px rgba(0,0,0,0.1);">
                            <div class="d-flex align-items-center mb-3">
                                <img src="web/assets/img/top-seller/3.png" alt="Company" style="width: 60px; height: 60px; border-radius: 50%;" />
                                <div class="ms-3">
                                    <h5 class="fw-bold mb-0">StartUp Ventures</h5>
                                    <p class="text-muted mb-0">Startup</p>
                                </div>
                            </div>
                            <p class="mb-3">"As a startup, we needed to move fast. Skillpots helped us build our entire engineering team in under a month."</p>
                            <div class="d-flex align-items-center">
                                <span class="badge" style="background-color: #0e636b; color: #fff;">8 Hires</span>
                                <span class="ms-2 text-muted">3 weeks</span>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </section>

        <!-- Pricing CTA -->
        <section class="pt-110 pb-80">
            <div class="container">
                <div class="cta-wrapper position-relative"
                    style="background: linear-gradient(135deg, #0e636b 0%, #0e636b 100%); border-radius: 20px; padding: 60px 40px;">
                    <div class="row justify-content-between align-items-center">
                        <div class="col-lg-7">
                            <div>
                                <h2 class="section-title-light fw-bold mb-4">
                                    Ready to Find Your Next Star Employee?
                                </h2>
                                <p class="text-white mb-4" style="font-size: 18px;">
                                    Join thousands of companies hiring top talent through Skillpots. Post your first job for free and see the difference AI-powered matching makes.
                                </p>
                                <div class="d-flex gap-3 flex-wrap">
                                    <a href="#" class="cta-btn-link" style="background-color: #ebba1b; color: #0e636b; padding: 15px 30px; border-radius: 8px; text-decoration: none; font-weight: bold;">
                                        Post a Job - Free
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="10"
                                            viewBox="0 0 14 10" fill="none">
                                            <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke="currentColor" stroke-width="1.5"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </a>
                                    <a href="#" style="background-color: transparent; border: 2px solid #fff; color: #fff; padding: 15px 30px; border-radius: 8px; text-decoration: none; font-weight: bold;">
                                        View Pricing Plans
                                    </a>
                                </div>
                                <div class="mt-4">
                                    <small class="text-white">✓ No credit card required  ✓ Cancel anytime  ✓ 14-day free trial</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5 text-center mt-4 mt-lg-0">
                            <div style="background-color: rgba(255,255,255,0.1); padding: 30px; border-radius: 15px; backdrop-filter: blur(10px);">
                                <h3 class="text-white fw-bold mb-3">Our Platform Stats</h3>
                                <div class="row text-white">
                                    <div class="col-6 mb-3">
                                        <h2 class="fw-bold mb-0" style="color: #ebba1b;">98%</h2>
                                        <small>Success Rate</small>
                                    </div>
                                    <div class="col-6 mb-3">
                                        <h2 class="fw-bold mb-0" style="color: #ebba1b;">14</h2>
                                        <small>Avg. Days to Hire</small>
                                    </div>
                                    <div class="col-6">
                                        <h2 class="fw-bold mb-0" style="color: #ebba1b;">50K+</h2>
                                        <small>Active Candidates</small>
                                    </div>
                                    <div class="col-6">
                                        <h2 class="fw-bold mb-0" style="color: #ebba1b;">12K+</h2>
                                        <small>Companies Hiring</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Why Choose Skillpots -->
        <section class="py-80 bg-offWhite">
            <div class="container">
                <div class="row mb-60 justify-content-center">
                    <div class="col-lg-8 text-center pb-2">
                        <h2 class="fw-bold section-title mb-3">Why Employers Choose Skillpots</h2>
                        <p class="section-desc">The most advanced recruitment platform designed for modern hiring teams</p>
                    </div>
                </div>
                <div class="row g-4">
                    <div class="col-lg-4 col-md-6">
                        <div class="bg-white p-4 rounded h-100" style="box-shadow: 0 4px 20px rgba(0,0,0,0.08);">
                            <div class="d-flex align-items-start mb-3">
                                <div style="width: 50px; height: 50px; background-color: #0e636b; border-radius: 10px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <i class="fas fa-brain" style="color: #ebba1b; font-size: 24px;"></i>
                                </div>
                                <div class="ms-3">
                                    <h5 class="fw-bold mb-2">AI-Powered Matching</h5>
                                    <p class="mb-0">Our intelligent algorithm matches you with candidates who fit your exact requirements</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="bg-white p-4 rounded h-100" style="box-shadow: 0 4px 20px rgba(0,0,0,0.08);">
                            <div class="d-flex align-items-start mb-3">
                                <div style="width: 50px; height: 50px; background-color: #0e636b; border-radius: 10px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <i class="fas fa-shield-alt" style="color: #ebba1b; font-size: 24px;"></i>
                                </div>
                                <div class="ms-3">
                                    <h5 class="fw-bold mb-2">Verified Candidates</h5>
                                    <p class="mb-0">All profiles are verified with background checks and skill assessments</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="bg-white p-4 rounded h-100" style="box-shadow: 0 4px 20px rgba(0,0,0,0.08);">
                            <div class="d-flex align-items-start mb-3">
                                <div style="width: 50px; height: 50px; background-color: #0e636b; border-radius: 10px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <i class="fas fa-clock" style="color: #ebba1b; font-size: 24px;"></i>
                                </div>
                                <div class="ms-3">
                                    <h5 class="fw-bold mb-2">Faster Hiring</h5>
                                    <p class="mb-0">Reduce your time-to-hire by 50% with our streamlined process</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="bg-white p-4 rounded h-100" style="box-shadow: 0 4px 20px rgba(0,0,0,0.08);">
                            <div class="d-flex align-items-start mb-3">
                                <div style="width: 50px; height: 50px; background-color: #0e636b; border-radius: 10px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <i class="fas fa-chart-line" style="color: #ebba1b; font-size: 24px;"></i>
                                </div>
                                <div class="ms-3">
                                    <h5 class="fw-bold mb-2">Analytics Dashboard</h5>
                                    <p class="mb-0">Track your hiring metrics and optimize your recruitment strategy</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="bg-white p-4 rounded h-100" style="box-shadow: 0 4px 20px rgba(0,0,0,0.08);">
                            <div class="d-flex align-items-start mb-3">
                                <div style="width: 50px; height: 50px; background-color: #0e636b; border-radius: 10px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <i class="fas fa-headset" style="color: #ebba1b; font-size: 24px;"></i>
                                </div>
                                <div class="ms-3">
                                    <h5 class="fw-bold mb-2">Dedicated Support</h5>
                                    <p class="mb-0">Get help from our recruitment experts whenever you need it</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="bg-white p-4 rounded h-100" style="box-shadow: 0 4px 20px rgba(0,0,0,0.08);">
                            <div class="d-flex align-items-start mb-3">
                                <div style="width: 50px; height: 50px; background-color: #0e636b; border-radius: 10px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <i class="fas fa-dollar-sign" style="color: #ebba1b; font-size: 24px;"></i>
                                </div>
                                <div class="ms-3">
                                    <h5 class="fw-bold mb-2">Cost Effective</h5>
                                    <p class="mb-0">Save up to 70% compared to traditional recruitment agencies</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Recent Jobs Posted -->
        <section class="py-110" hidden>
            <div class="container">
                <div class="row justify-content-between align-items-end mb-40">
                    <div class="col-auto">
                        <h2 class="fw-bold section-title">Recently Posted Jobs</h2>
                        <p class="section-desc">Latest opportunities from top companies</p>
                    </div>
                    <div class="col-auto mt-30 mt-md-0">
                        <a href="#" class="w-btn-link">
                            View All Jobs
                            <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 9.77393L13 5.53583M13 5.53583L9 1.29774M13 5.53583L1 5.53583"
                                    stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                                    stroke-linejoin="round" />
                            </svg>
                        </a>
                    </div>
                </div>
                <div class="row g-4">
                    <article class="col-xl-6 col-md-6">
                        <div class="bg-white p-4 rounded" style="box-shadow: 0 4px 20px rgba(0,0,0,0.08); border-left: 4px solid #0e636b;">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div class="d-flex gap-3">
                                    <img src="web/assets/img/top-seller/1.png" alt="Company" style="width: 50px; height: 50px; border-radius: 8px;" />
                                    <div>
                                        <h5 class="fw-bold mb-1">Senior React Developer</h5>
                                        <p class="mb-0 text-muted">Tech Innovations Ltd</p>
                                    </div>
                                </div>
                                <span class="badge" style="background-color: #0e636b; color: #fff;">25 Applied</span>
                            </div>
                            <div class="d-flex gap-3 mb-3 flex-wrap">
                                <small><i class="fas fa-location-dot"></i> Sydney</small>
                                <small><i class="fas fa-dollar-sign"></i> $120K-$150K</small>
                                <small><i class="fas fa-briefcase"></i> Full-time</small>
                                <small><i class="fas fa-clock"></i> Posted 2 hours ago</small>
                            </div>
                            <p class="mb-3">Looking for an experienced React developer to join our growing team...</p>
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex gap-2">
                                    <span class="badge bg-light text-dark">React</span>
                                    <span class="badge bg-light text-dark">TypeScript</span>
                                    <span class="badge bg-light text-dark">Node.js</span>
                                </div>
                                <a href="#" class="text-decoration-none" style="color: #0e636b; font-weight: 600;">View Applications →</a>
                            </div>
                        </div>
                    </article>

                    <article class="col-xl-6 col-md-6">
                        <div class="bg-white p-4 rounded" style="box-shadow: 0 4px 20px rgba(0,0,0,0.08); border-left: 4px solid #0e636b;">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div class="d-flex gap-3">
                                    <img src="web/assets/img/top-seller/2.png" alt="Company" style="width: 50px; height: 50px; border-radius: 8px;" />
                                    <div>
                                        <h5 class="fw-bold mb-1">UX/UI Designer</h5>
                                        <p class="mb-0 text-muted">Creative Agency Co</p>
                                    </div>
                                </div>
                                <span class="badge" style="background-color: #0e636b; color: #fff;">18 Applied</span>
                            </div>
                            <div class="d-flex gap-3 mb-3 flex-wrap">
                                <small><i class="fas fa-location-dot"></i> Melbourne</small>
                                <small><i class="fas fa-dollar-sign"></i> $95K-$120K</small>
                                <small><i class="fas fa-briefcase"></i> Full-time</small>
                                <small><i class="fas fa-clock"></i> Posted 5 hours ago</small>
                            </div>
                            <p class="mb-3">Seeking a talented designer to create beautiful user experiences...</p>
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex gap-2">
                                    <span class="badge bg-light text-dark">Figma</span>
                                    <span class="badge bg-light text-dark">Adobe XD</span>
                                    <span class="badge bg-light text-dark">UX</span>
                                </div>
                                <a href="#" class="text-decoration-none" style="color: #0e636b; font-weight: 600;">View Applications →</a>
                            </div>
                        </div>
                    </article>

                    <article class="col-xl-6 col-md-6">
                        <div class="bg-white p-4 rounded" style="box-shadow: 0 4px 20px rgba(0,0,0,0.08); border-left: 4px solid #0e636b;">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div class="d-flex gap-3">
                                    <img src="web/assets/img/top-seller/3.png" alt="Company" style="width: 50px; height: 50px; border-radius: 8px;" />
                                    <div>
                                        <h5 class="fw-bold mb-1">DevOps Engineer</h5>
                                        <p class="mb-0 text-muted">StartUp Ventures</p>
                                    </div>
                                </div>
                                <span class="badge" style="background-color: #0e636b; color: #fff;">32 Applied</span>
                            </div>
                            <div class="d-flex gap-3 mb-3 flex-wrap">
                                <small><i class="fas fa-location-dot"></i> Brisbane</small>
                                <small><i class="fas fa-dollar-sign"></i> $110K-$140K</small>
                                <small><i class="fas fa-briefcase"></i> Full-time</small>
                                <small><i class="fas fa-clock"></i> Posted 1 day ago</small>
                            </div>
                            <p class="mb-3">Join our infrastructure team and help us scale our platform...</p>
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex gap-2">
                                    <span class="badge bg-light text-dark">AWS</span>
                                    <span class="badge bg-light text-dark">Docker</span>
                                    <span class="badge bg-light text-dark">K8s</span>
                                </div>
                                <a href="#" class="text-decoration-none" style="color: #0e636b; font-weight: 600;">View Applications →</a>
                            </div>
                        </div>
                    </article>

                    <article class="col-xl-6 col-md-6">
                        <div class="bg-white p-4 rounded" style="box-shadow: 0 4px 20px rgba(0,0,0,0.08); border-left: 4px solid #0e636b;">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div class="d-flex gap-3">
                                    <img src="web/assets/img/top-seller/4.png" alt="Company" style="width: 50px; height: 50px; border-radius: 8px;" />
                                    <div>
                                        <h5 class="fw-bold mb-1">Marketing Manager</h5>
                                        <p class="mb-0 text-muted">Growth Marketing Inc</p>
                                    </div>
                                </div>
                                <span class="badge" style="background-color: #0e636b; color: #fff;">15 Applied</span>
                            </div>
                            <div class="d-flex gap-3 mb-3 flex-wrap">
                                <small><i class="fas fa-location-dot"></i> Perth</small>
                                <small><i class="fas fa-dollar-sign"></i> $90K-$115K</small>
                                <small><i class="fas fa-briefcase"></i> Full-time</small>
                                <small><i class="fas fa-clock"></i> Posted 1 day ago</small>
                            </div>
                            <p class="mb-3">Lead our marketing efforts and drive growth across all channels...</p>
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex gap-2">
                                    <span class="badge bg-light text-dark">SEO</span>
                                    <span class="badge bg-light text-dark">PPC</span>
                                    <span class="badge bg-light text-dark">Analytics</span>
                                </div>
                                <a href="#" class="text-decoration-none" style="color: #0e636b; font-weight: 600;">View Applications →</a>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </section>
    </main>
@endsection


