<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class superadmin extends Seeder
{
    /**
     * Run the database seeds.
     */
   public function run()
    {
        // Clear permission cache
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Example: create some permissions (customize as needed)
        $permissions = [
            'users.view',
            'users.create',
            'users.edit',
            'users.delete',
            'roles.view',
            'roles.create',
            'roles.edit',
            'roles.delete',
            'settings.view',
            'settings.edit',
            // add other app-specific permissions here...
        ];

        // Create permissions (idempotent)
        foreach ($permissions as $perm) {
            Permission::firstOrCreate(['name' => $perm]);
        }

        // Create or get super-admin role
        $superAdminRole = Role::firstOrCreate(['name' => 'super-admin']);

        // Give the role all permissions (or choose a subset)
        $allPermissionIds = Permission::pluck('id')->toArray();
        $superAdminRole->syncPermissions($allPermissionIds);

        // Create (or fetch) the super admin user
        $email ='admin@skillpot.com';
        $name  = 'Superadmin';
        $password = 'skillpot93'; // change in production

        $user = User::firstOrNew(['email' => $email]);
        $user->name = $name;
        $user->email = $email;
        $user->password = Hash::make($password);
        $user->status=1;
        $user->role='super-admin';
        // set other attrs if your User model requires them:
        if (method_exists($user, 'setRememberToken')) {
            $user->setRememberToken(Str::random(60));
        }
        $user->save();

        // Attach role
        if (! $user->hasRole($superAdminRole->name)) {
            $user->assignRole($superAdminRole);
        }

        $this->command->info("Super admin created: {$email} (password: {$password})");
    }

}
