<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RoleSeeder extends Seeder
{
     public function run(): void
    {
        // Create roles
        $jobseeker = Role::create(['name' => 'jobseeker']);
        $recruiter = Role::create(['name' => 'recruiter']);
        $admin = Role::create(['name' => 'admin']);

        // Create permissions (optional - for more granular control)
        $permissions = [
            'apply_jobs',
            'post_jobs',
            'manage_company',
            'view_applications',
            'manage_profile',
        ];

        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // Assign permissions to roles
        $jobseeker->givePermissionTo(['apply_jobs', 'manage_profile']);
        $recruiter->givePermissionTo(['post_jobs', 'manage_company', 'view_applications', 'manage_profile']);
        $admin->givePermissionTo($permissions);
    }
}
