<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::create('job_posts', function (Blueprint $table) {
            $table->id();

            // Job Details
            $table->string('job_title');
            $table->string('location');
            $table->enum('workplace_option', ['on-site', 'remote', 'hybrid'])->default('on-site');
            $table->enum('job_type', ['full-time', 'part-time', 'contract', 'temporary', 'internship']);
            $table->string('category');
            $table->text('description');

            // Salary & Benefits
            $table->enum('salary_type', ['fixed', 'range', 'negotiable'])->nullable();
            $table->string('currency')->default('USD');
            $table->decimal('min_salary', 10, 2)->nullable();
            $table->decimal('max_salary', 10, 2)->nullable();
            $table->enum('salary_period', ['hour', 'week', 'month', 'year'])->default('month');
            $table->json('benefits')->nullable();

            // Company Info
            $table->string('company_name')->nullable();
            $table->string('company_website')->nullable();
            $table->text('company_description')->nullable();
            $table->enum('company_size', ['1-10', '11-50', '51-200', '201-500', '501-1000', '1000+'])->nullable();
            $table->string('industry')->nullable();

            // Requirements
            $table->enum('experience_level', ['intern', 'entry', 'mid', 'senior', 'director', 'executive'])->nullable();
            $table->enum('education_level', ['high-school', 'associate', 'bachelor', 'master', 'phd', 'none'])->nullable();
            $table->text('skills')->nullable();
            $table->boolean('require_cover_letter')->default(false);
            $table->boolean('require_portfolio')->default(false);
            $table->boolean('require_references')->default(false);

            // Additional Info
            $table->text('preview_notes')->nullable();
            $table->enum('status', ['draft', 'pending', 'published', 'closed'])->default('draft');

            // Foreign key to employer
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('job_post');
    }
};
