<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('achievements', function (Blueprint $table) {
            $table->id();
          $table->foreignId('user_id')->constrained()->onDelete('cascade'); // if tied to a user
            $table->string('title'); // Achievement Title
            $table->string('issuer')->nullable(); // Issuer / Organization
            $table->date('date')->nullable(); // Date of achievement
            $table->text('description')->nullable(); // Description
            $table->string('link')->nullable(); // Optional proof/certificate link
            $table->timestamps();

            // If you want relationship with users

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('achievement');
    }
};
