<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class AIServices
{
    public static function generateProjectDescription(string $projectName): string
    {
        $apiKey = "sk-abcdef1234567890abcdef1234567890abcdef12"; // keep it in .env, not hardcoded
        $url = "https://api.openai.com/v1/responses";

        $data = [
            "model" => "gpt-4.1-mini", // lighter model, cheaper + fast
            "input" => "Generate a short description for a project named: {$projectName}"
        ];

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "Authorization: Bearer {$apiKey}"
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new \Exception('Curl error: ' . curl_error($ch));
        }

        curl_close($ch);

        $response = json_decode($result, true);

        // new Responses API → text is inside "output_text"
        return $response['output_text'] ?? 'No description generated.';
    }
    public function loadSuggestions($value)
    {
        try {
            $response = Http::withToken(config('services.openai.key')) // use config instead of hardcoding
                ->post('https://api.openai.com/v1/chat/completions', [
                    'model' => 'gpt-4o-mini',
                    'messages' => [
                        ['role' => 'system', 'content' => 'You are a career advisor.'],
                        [
                            'role' => 'user',
                            'content' => 'Suggest 10 professional skills only without description for a ' . $value,
                        ],
                    ],
                    'max_tokens' => 200,
                ]);

            $content = $response->json('choices.0.message.content');

            if ($content) {
                $skills = preg_split("/\r\n|\n|\r/", trim($content));

                return collect($skills)
                    ->map(function ($s) {
                        return preg_replace('/^\d+\.\s*/', '', trim($s)); // remove numbering
                    })
                    ->filter()
                    ->take(10)
                    ->toArray();
            }

            return [];
        } catch (\Exception $e) {
            return [
                'Laravel',
                'Livewire',
                'Spring Boot',
                'SQL',
                'React.js',
                'Flutter',
                'Docker',
                'REST API Development',
                'Git & Version Control',
                'Problem Solving'
            ];
        }
    }

    public function loadlangSuggestions($value)
    {
        try {
            $response = Http::withToken(config('services.openai.key'))
                ->post('https://api.openai.com/v1/chat/completions', [
                    'model' => 'gpt-4o-mini',
                    'messages' => [
                        ['role' => 'system', 'content' => 'You are a language suggestion assistant.'],
                        ['role' => 'user', 'content' => 'Suggest 5 languages related to ' . $value . ' only, no descriptions.'],
                    ],
                    'max_tokens' => 100,
                ]);

            $content = $response->json('choices.0.message.content');

            if ($content) {
                return collect(preg_split("/\r\n|\n|\r/", trim($content)))
                    ->map(fn($s) => preg_replace('/^\d+\.\s*/', '', trim($s)))
                    ->filter()
                    ->take(4)
                    ->toArray();
            }

            return [];
        } catch (\Exception $e) {
            return ['English', 'Spanish', 'French', 'German', 'Chinese', 'Japanese', 'Korean', 'Arabic', 'Hindi', 'Russian'];
        }
    }

    public function loadSummary($profileslogan)
    {
        try {
            $response = Http::withToken(config('services.openai.key'))
                ->post('https://api.openai.com/v1/chat/completions', [
                    'model' => 'gpt-4o-mini',
                    'messages' => [
                        ['role' => 'system', 'content' => 'You are a professional personal summary writer.'],
                        ['role' => 'user', 'content' => 'Generate a concise and engaging personal summary for this identity: ' . $profileslogan],
                    ],
                    'max_tokens' => 200,
                ]);

            $content = $response->json('choices.0.message.content');

            if ($content) {
                return trim($content);
            }

            return "A motivated professional with a strong background in various fields, eager to contribute and grow.";
        } catch (\Exception $e) {
            // Fallback summary if API fails
            return "A motivated professional with a strong background in various fields, eager to contribute and grow.";
        }
    }

    public function loadjobDescription($value)
    {



        try {
            $response = Http::withToken(config('services.openai.key'))
                ->post('https://api.openai.com/v1/chat/completions', [
                    'model' => 'gpt-4o-mini',
                    'messages' => [
                        ['role' => 'system', 'content' => 'You are an assistant that writes job descriptions.'],
                        ['role' => 'user', 'content' => 'Generate a professional job description for the position: ' . $value . '.
                    Include responsibilities, tasks, and objectives.']

                    ],
                    'max_tokens' => 200,
                ]);


            $content = $response->json('choices.0.message.content');

            if ($content) {
                return trim($content);
            }

            return "A motivated professional with a strong background in various fields, eager to contribute and grow.";
        } catch (\Exception $e) {
            // Fallback summary if API fails
            return "A motivated professional with a strong background in various fields, eager to contribute and grow.";
        }
    }


    public function loadSkills($jbtitle)
    {


        try {
            $response = Http::withToken(config('services.openai.key'))
                ->post('https://api.openai.com/v1/chat/completions', [
                    'model' => 'gpt-4o-mini',
                    'messages' => [
                        ['role' => 'system', 'content' => 'You are an assistant that suggests required skills for jobs.'],
                        ['role' => 'user', 'content' => 'List the top required skills for the position: ' . $jbtitle . '. Return each skill on a new line.']
                    ],
                    'max_tokens' => 200,
                ]);

            $skills = $response->json('choices.0.message.content') ?? '';
            if ($skills) {
                return trim($skills);
            }
            return "Too Many Request";
        } catch (\Throwable $th) {
            return "Too Many Request";
        }
    }
}
