<?php

namespace App\Providers;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\ServiceProvider;

class GeoIPServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
  public function boot()
    {
        $this->setDomainBasedOnCountry();
    }

    private function setDomainBasedOnCountry()
    {
        $ip = request()->ip();
        $countryCode = $this->getCountryCode($ip);

        $domainMap = [
            'LK' => 'skillpot.lk',
            'AU' => 'skillpot.com.au',
            'NZ' => 'skillpot.nz',
            'default' => 'skillpot.com',
        ];

        if (isset($domainMap[$countryCode])) {
            URL::forceRootUrl('https://' . $domainMap[$countryCode]);
        }
    }

    // private function getCountryCode($ip)
    // {
    //     // Same implementation as in middleware
    //     try {
    //         $response = file_get_contents("http://ip-api.com/json/{$ip}");
    //         $data = json_decode($response, true);

    //         if ($data && $data['status'] === 'success') {
    //             return $data['countryCode'];
    //         }
    //     } catch (\Exception $e) {
    //         // Log error
    //         Log::error('GeoIP error: ' . $e->getMessage());
    //     }

    //     return 'default'; // Default
    // }

    private function getCountryCode($ip)
{
    try {
        $location = geoip($ip);
        return $location->iso_code;
    } catch (\Exception $e) {
        return 'US'; // Default fallback
    }
}
}
