<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class JobQuestion extends Model
{
   use HasFactory;

    protected $fillable = [
        'job_post_id',
        'question',
        'type',
        'is_required',
        'order'
    ];

    public function jobPost(): BelongsTo
    {
        return $this->belongsTo(JobPost::class);
    }

    public function answers(): HasMany
    {
        return $this->hasMany(JobQuestionAnswer::class);
    }
}
