<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class JobCategory extends Model
{
     use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'image',
        'base',
        'description',
        'status'
    ];

   protected static function boot()
{
    parent::boot();

    static::creating(function ($category) {
        $category->slug = Str::slug($category->name . ' ' . $category->base);
    });

    static::updating(function ($category) {
        $category->slug = Str::slug($category->name . ' ' . $category->base);
    });
}

    public function getImageUrlAttribute()
    {
        if ($this->image) {
            return Storage::disk('public')->url('job-categories/' . $this->image);
        }

        return 'https://via.placeholder.com/50';
    }

    public function getStatusBadgeAttribute()
    {
        return $this->status ? 'success' : 'warning';
    }

    public function getStatusTextAttribute()
    {
        return $this->status ? 'Active' : 'Inactive';
    }

    // Helper method to get image path
    public function getImagePathAttribute()
    {
        if ($this->image) {
            return Storage::disk('public')->path('job-categories/' . $this->image);
        }
        return null;
    }
}
