<?php

namespace App\Livewire\Web\Register;

use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Livewire\Component;
use Illuminate\Validation\Rules;

class Registerpage extends Component
{
    public $userRole = 'jobseeker';
    public $username;
    public $email;
    public $password;
    public $password_confirmation;
    public $profession;
    public $company;
    public $position;
    public $mobile_no;
    public $profile_slogan;

    protected $rules = [
        'username' => 'required|string|max:255|unique:users,name',
        'email' => 'required|string|email|max:255|unique:users',
           'password' => 'required|confirmed|min:8',
        'profession' => 'nullable',
        'company' => 'nullable',
        'position' => 'nullable',
        'mobile_no' => 'nullable|string|max:20',
        'profile_slogan' => 'nullable|string|max:255',
    ];

    protected $messages = [
        'profession.required_if' => 'The profession field is required for jobseekers.',
        'company.required_if' => 'The company field is required for recruiters.',
        'position.required_if' => 'The position field is required for recruiters.',
    ];

    public function setRole($role)
    {
        $this->userRole = $role;
        // Clear role-specific fields when switching
        if ($role === 'jobseeker') {
            $this->reset(['company', 'position']);
        } else {
            $this->reset(['profession']);
        }
    }

    public function register()
    {

        $this->validate();

        $user = User::create([
            'name' => $this->username,
            'email' => $this->email,
            'password' => Hash::make($this->password),
            'role' => $this->userRole,
            'mobile_no' => $this->mobile_no,
            'profile_slogan' => $this->profile_slogan,
        ]);

        // Assign role based on selection
        if ($this->userRole === 'jobseeker') {
            $user->assignRole('jobseeker');
        } else {
            $user->assignRole('recruiter');
            // You might want to create a company profile here
        }

        // Send email verification notification
        $user->sendEmailVerificationNotification();

        session()->flash('message', 'Registration successful! Please check your email for verification.');

        // Reset form
        $this->reset();
        $this->userRole = 'jobseeker';

        // Optionally redirect to login page
        // return redirect()->route('login');
    }
    public function render()
    {
        return view('livewire.web.register.registerpage');
    }
}
