<?php

namespace App\Livewire\Web\Login;

use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class Loginpage extends Component
{
      public $email;
    public $password;
    public $showPassword = false;
    public $forgotPasswordMode = false;



    protected $rules = [
        'email' => 'required|email',
        'password' => 'required|min:6',
    ];
      public function submit()
    {
        $this->validate();

        if (Auth::attempt(['email' => $this->email, 'password' => $this->password])) {
            session()->flash('success', 'Welcome back!');
            return redirect()->route('skillpot.home');
        } else {
            $this->addError('email', 'Invalid email or password.');
        }
    }
    public function render()
    {
        return view('livewire.web.login.loginpage');
    }
}
