<?php

namespace App\Livewire\Web\Index\Profile;

use App\Models\Language;
use App\Models\Personalsummary;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Illuminate\Support\Str;

class Myprofile extends Component
{
    use WithFileUploads;
    public $profile_title = '';
    public $profile_url;
    public $editMode = false;
    public $profile_location = '';
    public $editLocation = false;
    public $is_employer = false;
    public $showEmployerModal = false;

    public $lang,$personalsummary;
    public $photo;

    protected $listeners = ['languageAdded' => 'mount','personalsummaryadded'=>'mount'];

    public function mount()
    {
        $this->profile_title = auth()->user()->profile_slogan ?? 'Please update';
        $this->profile_location = auth()->user()->address ?? 'Please update';
        $this->profile_url = auth()->user()->profile_url ?? 'N/A';
        $this->is_employer = auth()->user()->is_employer ?? false;
        $this->lang = $this->userLanguage();
        $this->personalsummary = $this->personalSummary();
    }

    public function personalSummary(){
        $summary = Personalsummary::where('user_id', $this->authUser()->id)->first();
        return $summary ?? 'Add a personal summary to your profile';
    }

    public function userLanguage(){
        $user = $this->authUser();
        $languageData = Language::where('user_id', $user->id)->get();
        return $languageData;
    }

    public function authUser(){
        $user = Auth::user();
        return $user;
    }

    public function edit()
    {
        $this->editMode = true;
    }

    public function save()
    {
        $this->validate([
            'profile_title' => ['required','string','max:100'],
        ]);

        auth()->user()->update(['profile_slogan' => $this->profile_title]);
        $this->editMode = false;

        $this->dispatch('notify', message: 'Profile title updated.');
    }

    public function cancel()
    {
        $this->profile_title = auth()->user()->profile_slogan ?? '';
        $this->editMode = false;
    }

    public function editlocation()
    {
        $this->editLocation = true;
    }

    public function saveLocation()
    {
        $this->validate([
            'profile_location' => 'required|string|max:150',
        ]);

        auth()->user()->update(['address' => $this->profile_location]);
        $this->editLocation = false;

        $this->dispatch('notify', message: 'Location updated.');
    }

    public function cancelLocation()
    {
        $this->profile_location = auth()->user()->address ?? '';
        $this->editLocation = false;
    }

    public function saveAvatar()
    {
        $this->validate([
            'photo' => 'required|image|max:1024',
        ]);

        // Delete old avatar if exists
        if (auth()->user()->profile_image && file_exists(public_path(auth()->user()->profile_image))) {
            unlink(public_path(auth()->user()->profile_image));
        }

        // Generate unique filename
        $filename = Str::uuid().'.'.$this->photo->getClientOriginalExtension();

        // Move file into public/avatars
        $this->photo->storeAs('avatars', $filename, 'public');

        // Save relative path
        auth()->user()->update(['profile_image' => $filename]);

        $this->photo = null;
        $this->dispatch('notify', message: 'Profile avatar updated.');
    }

    public function toggleEmployerMode()
    {
        $this->is_employer = !$this->is_employer;

        auth()->user()->update(['role' => 'employer']);

        // $message = $this->is_employer
        //     ? 'You are now in employer mode. You can post jobs and manage candidates.'
        //     : 'Switched to personal account mode.';

        // $this->dispatch('notify', message: $message);
        return redirect()->route('skillpot.home');
    }

    public function showEmployerModal()
    {
        $this->showEmployerModal = true;
    }

    public function closeEmployerModal()
    {
        $this->showEmployerModal = false;
    }

    public function add_modal_view(){
        $this->dispatch('view_profileaddmodal');
    }

    public function editpersonalsummary(){
        $this->dispatch('personalsummarymodal');
    }



    public function render()
    {
        return view('livewire.web.index.profile.myprofile');
    }
}
