<?php

namespace App\Livewire\Web\Index\Profile\Modal\Summary;

use App\Models\Personalsummary;
use App\Models\User;
use App\Services\AIServices;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class Personalsummarymodal extends Component
{
    public $personalsummarymodal = false;
    public $personal_summary = ''; // <-- add this property

    public $profileslogan;

    protected $listeners = ['personalsummarymodal' => 'openModal'];

    public function openModal()
    {
        $this->personalsummarymodal = true;
         $user=Auth::user();        // Optionally, load current user's summary
         $personalSummarydata=Personalsummary::where('user_id',$user->id)->first();
        $this->personal_summary = $personalSummarydata->summary ?? 'Add a personal summary to your profile';
    }

    public function closeModal()
    {
        $this->personalsummarymodal = false;
    }

public function savePersonalSummary()
{
    $this->validate([
        'personal_summary' => 'required|string|max:1000',
    ]);

    // Update if exists, otherwise create
    Personalsummary::updateOrCreate(
        ['user_id' => Auth::id()], // matching criteria
        ['summary' => $this->personal_summary] // values to update/create
    );

    $this->personalsummarymodal = false;

    // Dispatch event if needed
    $this->dispatch('personalsummaryadded');
}


   public function generateSummary(){
        $user=Auth::user();
        $getprofileData=User::find($user->id);
        $this->profileslogan=$getprofileData->profile_slogan;
        $aiService = new AIServices();
        $this->personal_summary = $aiService->loadSummary($this->profileslogan);
   }

    public function render()
    {
        return view('livewire.web.index.profile.modal.summary.personalsummarymodal');
    }
}
