<?php

namespace App\Livewire\Web\Index\Profile\Modal;

use App\Models\Skill;
use App\Services\AiService;
use App\Services\AIServices;
use Illuminate\Support\Facades\Http;
use Livewire\Component;

class Addskillmodal extends Component
{
    public $addskillmodal = false;
    public $skill = '';
    public $suggestions = [];

    protected $rules=[
        'skill'=>'required'
    ];

    protected $listeners = ['viewskillmodal' => 'openModal'];

    public function setSkill($value)
    {
        $this->skill = $value;
    }

    public function saveCourse()
    {
        // Save the skill logic
        // Example: Skill::create(['name' => $this->skill]);

        session()->flash('message', 'Skill saved successfully!');
        $this->closeModal();
    }

    public function openModal()
    {
        $this->addskillmodal = true;

    }

 public function updatedSkill($value)
{
    // Whenever skill input changes, this runs
    // You can trigger AI suggestions here dynamically if you want
    $this->loadSuggestions($value);
}
    public function closeModal()
    {
        $this->addskillmodal = false;
        $this->skill = '';
        $this->suggestions='';
    }

    private function loadSuggestions($value)
    {
          $aiService = new AIServices();
        $this->suggestions = $aiService->loadSuggestions($value);

    }

    public function saveSkill(){
     $this->validate();
      Skill::create([
            'user_id' => auth()->id(),
            'skills' => $this->skill,

        ]);

        // Close modal and reset form
        $this->closeModal();

        // Emit event to refresh parent component
        $this->dispatch('skillAdded');

    }

    public function render()
    {
        return view('livewire.web.index.profile.modal.addskillmodal');
    }
}
