<?php

namespace App\Livewire\Web\Index\Profile\Modal;

use App\Models\Expereince;
use App\Models\Project;
use App\Services\AiService;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class Addprojectmodal extends Component
{
    public $addprojectmodal=false;
public $associate,$description,$project_name;
    public $associatedlist = [];
    protected $listeners = ['viewprojectmodal' => 'openModal'];

        protected $rules = [
        'project_name' => 'required',

    ];
    public function mount()
    {
        $user = Auth::user();
        $this->associatedlist = Expereince::where('user_id', $user->id)->get();
    }
        public function openModal()
    {
        $this->addprojectmodal = true;
    }
   public function updatedProjectName()
    {
        if ($this->project_name) {
            $this->description = AiService::generateprojectDescription($this->project_name);

        }
    }

    public function closeModal()
    {
        $this->addprojectmodal = false;

    }
    public function saveproject(){
         $this->validate();

        Project::create([
            'project_name' => $this->project_name,
            'description' => $this->description,
            'associate' => $this->associate ?? '',
            'user_id' => auth()->id(), // assuming education belongs to user
        ]);

        $this->closeModal();

        // Optional: show a success message
        session()->flash('message', 'Project added successfully.');
    }
    public function render()
    {
        return view('livewire.web.index.profile.modal.addprojectmodal');
    }
}
