<?php

namespace App\Livewire\Web\Index\Profile\Modal;

use App\Models\Language;
use App\Services\AiService;
use App\Services\AIServices;
use Livewire\Component;

class Addlanguagemodal extends Component
{

    public $addlanguagemodal = false;
public $language, $level;
 public $suggestions = [];

protected $rules = [
    'language' => 'required|string|max:100',
    'level' => 'required|string',
];

   protected $listeners = ['viewlanguagemodal' => 'openModal'];

    public function updatedLanguage($value)
    {
        if (strlen($value) > 1) { // trigger only if user typed at least 2 chars
            $aiService = new AIServices();
            $this->suggestions = $aiService->loadlangSuggestions("language related to '$value'");
        } else {
            $this->suggestions = [];
        }
    }
public function saveLang()
{
    $this->validate();

    // Example save (adjust model/table as needed)
    Language::create([
        'user_id' => auth()->id(),
        'language' => $this->language,
        'level' => $this->level,
    ]);

    // Reset fields
    $this->reset(['language', 'level']);
    $this->dispatch('languageAdded');
    // Close modal
    $this->closeModal();

    session()->flash('message', 'Language added successfully!');
}
public function openModal()
{
    $this->addlanguagemodal = true;
}

public function setLanguage($lang)
    {
        $this->language = $lang;
        $this->suggestions = [];
    }

public function closeModal()
{
    $this->addlanguagemodal = false;
    $this->reset();
}

    public function render()
    {
        return view('livewire.web.index.profile.modal.addlanguagemodal');
    }
}
