<?php

namespace App\Livewire\Web\Index\Profile\Modal;

use App\Models\Education;
use Livewire\Component;

class Addedumodal extends Component
{
   public $addedumodal = false;

    // Form fields
    public $school;
    public $degree;
    public $fieldOfStudy;
    public $startMonth;
    public $startYear;
    public $endMonth;
    public $endYear;
    public $grade;
    public $activities;

    protected $listeners = ['viewedumodal' => 'openModal'];

    protected $rules = [
        'school' => 'required|string|max:255',
        'degree' => 'nullable|string|max:255',
        'fieldOfStudy' => 'nullable|string|max:255',
        'grade' => 'nullable|string|max:50',
        'activities' => 'nullable|string|max:500',
    ];

    public function openModal()
    {
        $this->addedumodal = true;
    }

    public function closeModal()
    {
        $this->addedumodal = false;
        $this->resetForm();
    }

    public function resetForm()
    {
        $this->school = '';
        $this->degree = '';
        $this->fieldOfStudy = '';
        $this->startMonth = '';
        $this->startYear = '';
        $this->endMonth = '';
        $this->endYear = '';
        $this->grade = '';
        $this->activities = '';
    }

    public function saveEducation()
    {
        $this->validate();

        Education::create([
            'school' => $this->school,
            'degree' => $this->degree,
            'field_of_study' => $this->fieldOfStudy,
            'start_month' => $this->startMonth ?? '',
            'start_year' => $this->startYear ?? '',
            'end_month' => $this->endMonth ?? '',
            'end_year' => $this->endYear ?? '',
            'grade' => $this->grade,
            'activities' => $this->activities,
            'user_id' => auth()->id(), // assuming education belongs to user
        ]);

        $this->closeModal();

        // Optional: show a success message
        session()->flash('message', 'Education added successfully.');
    }

    public function render()
    {
        return view('livewire.web.index.profile.modal.addedumodal');
    }
}
