<?php

namespace App\Livewire\Web\Index\Profile\Modal;

use App\Models\Course;
use Livewire\Component;

class Addcoursemodal extends Component
{
     public $addcoursemodal = false;
    public $courseName;
    public $status;
    public $description;

    protected $rules = [
        'courseName' => 'required|min:3|max:255',
        'status' => 'required',
        'description' => 'nullable|string|max:1000'
    ];

    protected $messages = [
        'courseName.required' => 'Course name is required.',
        'courseName.min' => 'Course name must be at least 3 characters.',
        'status.required' => 'Please select a status.',
        'status.in' => 'Status must be either completed or following.',
    ];
       protected $listeners = ['viewcoursemodal' => 'openModal'];
    public function openModal()
    {
        $this->addcoursemodal = true;
    }

    public function closeModal()
    {
        $this->addcoursemodal = false;
        $this->resetForm();
    }

    public function resetForm()
    {
        $this->reset(['courseName', 'status', 'description']);
        $this->resetErrorBag();
    }

    public function saveCourse()
    {
        $this->validate();

        // Save the course
        Course::create([
            'user_id' => auth()->id(),
            'course_name' => $this->courseName,
            'status' => $this->status,
            'description' => $this->description
        ]);

        // Close modal and reset form
        $this->closeModal();

        // Emit event to refresh parent component
        $this->dispatch('courseAdded');


    }

    public function render()
    {
        return view('livewire.web.index.profile.modal.addcoursemodal');
    }
}
