<?php

namespace App\Livewire\Web\Index\Profile\Modal;

use Livewire\Component;
use App\Models\Achievement;
use Illuminate\Support\Facades\Auth;

class Addachievementmodal extends Component
{
    public $addachievementmodal = false;

    // Form fields
    public $achievement_title;
    public $achievement_issuer;
    public $achievement_date;
    public $achievement_description;
    public $achievement_link;

    protected $listeners = ['viewachievementmodal' => 'openModal'];

    // Validation rules
    protected $rules = [
        'achievement_title'       => 'required|string|max:255',
        'achievement_issuer'      => 'nullable|string|max:255',
        'achievement_date'        => 'nullable|date',
        'achievement_description' => 'nullable|string',
        'achievement_link'        => 'nullable|url|max:255',
    ];

    // Open modal
    public function openModal()
    {
        $this->resetFields();
        $this->addachievementmodal = true;
    }

    // Close modal
    public function closeModal()
    {
        $this->addachievementmodal = false;
    }

    // Reset all fields
    private function resetFields()
    {
        $this->achievement_title = '';
        $this->achievement_issuer = '';
        $this->achievement_date = '';
        $this->achievement_description = '';
        $this->achievement_link = '';
    }

    // Save achievement
    public function saveAchievement()
    {
        $this->validate();

        Achievement::create([
            'user_id'    => Auth::id(),
            'title'      => $this->achievement_title,
            'issuer'     => $this->achievement_issuer,
            'date'       => $this->achievement_date,
            'description'=> $this->achievement_description,
            'link'       => $this->achievement_link,
        ]);

        session()->flash('success', 'Achievement added successfully ✅');

        $this->resetFields();
        $this->closeModal();

        // Optional: emit event to refresh parent list
        $this->dispatch('achievementAdded');
    }

    public function render()
    {
        return view('livewire.web.index.profile.modal.addachievementmodal');
    }
}
