<?php

namespace App\Livewire\Web\Index\Modal;

use App\Models\User;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Hash;
use Livewire\Component;
use Illuminate\Support\Str;

class Signupmodal extends Component
{
     public $username;
    public $email;
    public $password;
    public $role;
    public $confirm_password;
    public $showPassword = false;
    public $showconfirmPassword = false;
    public $passwordStrength = '';
      protected $listeners = ['signupmodalview' => 'openmodal'];
    public $opensignupmodal=false;

       protected $rules = [
        'username' => 'required|string|min:3',
        'email' => 'required|email|unique:users,email',
        'password' => 'required|string|min:6',
        'confirm_password' => 'required|string|min:6',
        'role' => 'required|in:jobseeker,employer',
    ];
    public function openmodal(){
        $this->opensignupmodal=true;
    }
       public function closeModal(){
        $this->opensignupmodal=false;
    }
    public function signinmodal(){
        $this->closeModal();
        $this->dispatch('opensigninmodal');
    }
    public function updatedPassword($value)
{

    $this->passwordStrength = $this->getPasswordStrength($value);

}

private function getPasswordStrength($password)
{
    $strength = 0;

    if (strlen($password) >= 8) $strength++;
    if (preg_match('/[A-Z]/', $password)) $strength++;
    if (preg_match('/[a-z]/', $password)) $strength++;
    if (preg_match('/[0-9]/', $password)) $strength++;
    if (preg_match('/[\W]/', $password)) $strength++; // special character

    if ($strength <= 2) return 'Weak';
    if ($strength <= 4) return 'Medium';
    return 'Strong';
}
   public function submit()
    {
        $this->validate();

        if ($this->password !== $this->confirm_password) {
            $this->addError('confirm_password', 'Passwords do not match.');
            return;
        }

       $user= User::create([
            'name' => $this->username,
            'email' => $this->email,
            'mobile_no'=>'',
             'role' => $this->role,
             'profile_url'=>Str::slug($this->username),
            'status'=>1,
            'password' => Hash::make($this->password), // hashed password
        ]);
        event(new Registered($user));

        session()->flash('success', 'User registered successfully! Please check your email and verify your account.');


        // Reset form
        $this->reset(['username', 'email', 'password', 'confirm_password']);
    }
    public function render()
    {
        return view('livewire.web.index.modal.signupmodal');
    }


}
