<?php

namespace App\Livewire\Web\Index\Home;

use App\Models\JobCategory;
use Livewire\Component;

class Categorycomponent extends Component
{
   public $sortBy = 'name_asc'; // Default sorting

    public function render()
    {
        $categories = JobCategory::where('status', true)
            ->when($this->sortBy === 'name_asc', function ($query) {
                return $query->orderBy('name', 'asc');
            })
            ->when($this->sortBy === 'name_desc', function ($query) {
                return $query->orderBy('name', 'desc');
            })
            ->when($this->sortBy === 'created_asc', function ($query) {
                return $query->orderBy('created_at', 'asc');
            })
            ->when($this->sortBy === 'created_desc', function ($query) {
                return $query->orderBy('created_at', 'desc');
            })
            ->get();

        return view('livewire.web.index.home.categorycomponent', compact('categories'));
    }

    public function updateSort($sortType)
    {
        $this->sortBy = $sortType;
    }
}
