<?php

namespace App\Livewire\Web\Index\Employer;

use App\Models\Businessprofile;
use App\Models\Jobpost;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Livewire\Component;
use Livewire\WithFileUploads;

class Dashboard extends Component
{
    use WithFileUploads;

    public $showBusinessForm = false;
    public $businessname, $email, $phone, $address, $createdjobslist, $logo;
    public $registerd = false;

    protected $listeners = ['businessprofileAdded' => 'mount'];

    protected $rules = [
        'businessname' => 'required|string|max:255',
        'email' => 'required|email|max:255',
        'phone' => 'required|string|max:20',
        'address' => 'required|string|max:500',
        'logo' => 'required|image|max:1024', // max 1MB
    ];

    public function mount()
    {
        $user = Auth::user();
        $business = Businessprofile::where('user_id', $user->id)->first();

        if ($business) {
            $this->registerd = true;
            $this->showBusinessForm = false;
        } else {
            $this->showBusinessForm = true;
        }

        $this->createdjobslist = Jobpost::where('user_id', $user->id)->take(3)->get();
    }

    public function toggleStatus($jobId)
    {
        $job = Jobpost::find($jobId);

        if ($job) {
            $job->status = $job->status === 'published' ? 'draft' : 'published';
            $job->save();
        }

        $this->mount(); // refresh component
    }

    public function postnewjob()
    {
        $business = Businessprofile::where('user_id', Auth::id())->first();

        if ($business) {
            return redirect()->route('jobs.create');
        } else {
            $this->showBusinessForm = true;
        }
    }

    public function saveBusinessprofile()
    {
        $this->dispatch('spinner:start');

        sleep(1); // optional: simulate loading
        $this->validate();

        // Handle logo upload
        $filename = null;
        if ($this->logo) {
             $filename = Str::uuid().'.'.$this->logo->getClientOriginalExtension();
        // Move file into public/avatars
        $this->logo->storeAs('avatars', $filename, 'public');
        }

        $result=Businessprofile::create([
            'user_id' => auth()->id(),
            'businessname' => $this->businessname,
            'email' => $this->email,
            'phone' => $this->phone,
            'address' => $this->address,
            'logo' => $filename,
            'status' => 1,
        ]);
        if($result){
            $user=User::find(auth()->id());
            $user->profile_image=$filename;
            $user->save();
        }

        // $this->dispatch('businessprofileAdded');
        return redirect()->route('my.employer.dashboard');
    }
    public function render()
    {
        return view('livewire.web.index.employer.dashboard');
    }
}
