<?php

namespace App\Livewire\Admin;

use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class Login extends Component
{
     public $email;
    public $password;
    public $remember = false;
    public $errorMessage = '';



    public function login()
    {
        $this->validate([
            'email' => 'required|email',
            'password' => 'required|min:6',
        ]);

        if (Auth::attempt(['email' => $this->email, 'password' => $this->password], $this->remember)) {
            $user = Auth::user();

            // Check if user has the 'super-admin' or 'admin' role
            if ($user->hasRole(['super-admin', 'admin'])) {
                return redirect()->route('admin.dashboard');
            } else {
                Auth::logout();
                $this->errorMessage = 'You do not have admin access.';
                return;
            }
        }

        $this->errorMessage = 'Invalid email or password.';
    }


    public function render()
    {
        return view('livewire.admin.login') ->layout('layouts.adminlayout', [
                'title' => 'Admin Login',
            ]);
    }
}
