<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

use Illuminate\Support\Facades\URL;
use Stevebauman\Location\Facades\Location;
use Symfony\Component\HttpFoundation\Response;

class RedirectByCountry
{

 public function handle(Request $request, Closure $next): Response
    {
        // Skip redirection for local environment
        if (app()->environment('local')) {
            return $next($request);
        }

        // Get user IP address
        $ip = $request->ip();

        // Get location data
        $position = Location::get($ip);

        if ($position && isset($position->countryName)) {
            $country = strtolower($position->countryName);

            // Define country → domain mapping
            $domains = [
                'sri lanka' => 'https://skillpot.lk',
                'new zealand' => 'https://skillpot.nz',
                'australia' => 'https://skillpot.com.au',
                'default' => 'https://skillpot.com',
            ];

            // Redirect if country matches one of our domains
            if (array_key_exists($country, $domains)) {
                $target = $domains[$country];

                if (!str_starts_with($request->getHost(), parse_url($target, PHP_URL_HOST))) {
                    return redirect()->away($target);
                }
            }
        }

        return $next($request);
    }
}
