<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Auth\Events\Verified;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Laravel\Socialite\Facades\Socialite;

class FrontController extends Controller
{
       public function index()
    {
        return view('home');
    }

    public function app(){
        return view('layouts.app');
    }

    public function sign_out(){
        Auth::logout();
        return redirect()->route('skillpot.home');
    }
    public function my_profile(){
      return view('myprofile.myprofile');
    }

    public function employerdashboard(){
        return view('employer.dashboard');
    }

    public function create_job(){
        return view('employer.job.createjob');
    }

    public function find_job(){
     return view('findjob');
    }

    public function verifyAccount(Request $request, $id, $hash)
    {
        $user = User::findOrFail($id);

        // Check if already verified
        if ($user->hasVerifiedEmail()) {
            return redirect()->route('skillpot.home')->with('status', 'Your email is already verified.');
        }

        // Verify hash
        if (! hash_equals((string) $hash, sha1($user->getEmailForVerification()))) {
            abort(403, 'Invalid verification link.');
        }

        // Mark email as verified
        if ($user->markEmailAsVerified()) {
            event(new Verified($user));
        }

        return redirect()->route('skillpot.home')->with('status', 'Your email has been successfully verified.');
    }

   public function gmailCallBack(){
      return Socialite::driver('google')->redirect();

    }

    public function job_apply(){
        return view('jobapply.jobapplydashboard');
    }

      public function handleCallback(){
     $user  =  Socialite::driver('google')->user();
     $data = DB::table('users')->where('email',$user->email)->first();


    if ($data) {
                Auth::login($data);
                return redirect()->route('skillpot.home');
            } else {
                $newUser = User::create([
                    'name' => $user->name,
                    'email' => $user->email,
                    'google_id'=> $user->id,
                    'password' => encrypt('123456dummy')
                ]);

                Auth::login($newUser);
               return redirect()->route('skillpot.home');
            }

    }

    public function loginpage(){
         return view('web.home.loginpage');
    }
    public function registerpage(){
         return view('web.home.registerpage');
    }

    public function jobseekerindex(){
        return view('web.home.jobseekerdashboard');
    }

    public function employersite(){
        return view('employersite');
    }

    public function employerindex(){
        return view('web.home.employyerdashboard');
    }

    public function employer_jobpost(){
        return view('web.home.employer.postjob');
    }

    public function employer_jobpostcreate(){
          return view('web.home.employer.createjob');
    }

}
